/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.space;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.constant.HugeType;

public class ConfigAPI
extends API {
    private static final String PATH = "graphspaces/%s/configs/rest";

    public ConfigAPI(RestClient client, String graphSpace) {
        super(client);
        this.path(String.format(PATH, graphSpace));
    }

    @Override
    protected String type() {
        return HugeType.CONFIGS.string();
    }

    public List<String> listConfigOptions() {
        RestResult result = this.client.get(this.path(), "config-fields");
        return result.readList("fields", String.class);
    }

    public Map<String, Object> get(String serviceName) {
        RestResult result = this.client.get(this.path(), serviceName);
        return (Map)result.readObject(Map.class);
    }

    public Map<String, Object> add(String serviceName, Map<String, Object> configs) {
        ImmutableMap data = ImmutableMap.of((Object)"name", (Object)serviceName, (Object)"config", configs);
        RestResult result = this.client.post(this.path(), data);
        return (Map)result.readObject(Map.class);
    }

    public Map<String, Object> update(String serviceName, Map<String, Object> config) {
        RestResult result = this.client.put(this.path(), serviceName, config);
        return (Map)result.readObject(Map.class);
    }

    public void delete(String serviceName) {
        this.client.delete(this.path(), serviceName);
    }
}

