/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.querymatcher;

import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.querymatcher.ColumnTracker;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.querymatcher.UserScanQueryMatcher;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class RawScanQueryMatcher
extends UserScanQueryMatcher {
    protected RawScanQueryMatcher(Scan scan, ScanInfo scanInfo, ColumnTracker columns, boolean hasNullColumn, long oldestUnexpiredTS, long now) {
        super(scan, scanInfo, columns, hasNullColumn, oldestUnexpiredTS, now);
    }

    @Override
    public ScanQueryMatcher.MatchCode match(Cell cell) throws IOException {
        if (this.filter != null && this.filter.filterAllRemaining()) {
            return ScanQueryMatcher.MatchCode.DONE_SCAN;
        }
        ScanQueryMatcher.MatchCode returnCode = this.preCheck(cell);
        if (returnCode != null) {
            return returnCode;
        }
        long timestamp = cell.getTimestamp();
        byte typeByte = cell.getTypeByte();
        return this.matchColumn(cell, timestamp, typeByte);
    }

    @Override
    protected void reset() {
    }

    @Override
    protected boolean isGet() {
        return false;
    }

    public static RawScanQueryMatcher create(Scan scan, ScanInfo scanInfo, ColumnTracker columns, boolean hasNullColumn, long oldestUnexpiredTS, long now) {
        if (scan.isReversed()) {
            if (scan.includeStopRow()) {
                return new RawScanQueryMatcher(scan, scanInfo, columns, hasNullColumn, oldestUnexpiredTS, now){

                    @Override
                    protected boolean moreRowsMayExistsAfter(int cmpToStopRow) {
                        return cmpToStopRow >= 0;
                    }
                };
            }
            return new RawScanQueryMatcher(scan, scanInfo, columns, hasNullColumn, oldestUnexpiredTS, now){

                @Override
                protected boolean moreRowsMayExistsAfter(int cmpToStopRow) {
                    return cmpToStopRow > 0;
                }
            };
        }
        if (scan.includeStopRow()) {
            return new RawScanQueryMatcher(scan, scanInfo, columns, hasNullColumn, oldestUnexpiredTS, now){

                @Override
                protected boolean moreRowsMayExistsAfter(int cmpToStopRow) {
                    return cmpToStopRow <= 0;
                }
            };
        }
        return new RawScanQueryMatcher(scan, scanInfo, columns, hasNullColumn, oldestUnexpiredTS, now){

            @Override
            protected boolean moreRowsMayExistsAfter(int cmpToStopRow) {
                return cmpToStopRow < 0;
            }
        };
    }
}

