/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.client;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.bifromq.basekv.client.IQueryPipeline;
import org.apache.bifromq.basekv.proto.KVRangeDescriptor;
import org.apache.bifromq.basekv.store.proto.KVRangeROReply;
import org.apache.bifromq.basekv.store.proto.KVRangeRORequest;
import org.apache.bifromq.baserpc.client.IRPCClient;
import org.slf4j.Logger;

class ManagedQueryPipeline
implements IQueryPipeline {
    private final Logger log;
    private final Disposable disposable;
    private final Consumer<KVRangeDescriptor> routePatcher;
    private volatile IRPCClient.IRequestPipeline<KVRangeRORequest, KVRangeROReply> ppln;

    ManagedQueryPipeline(Observable<IRPCClient.IRequestPipeline<KVRangeRORequest, KVRangeROReply>> pplnObservable, Consumer<KVRangeDescriptor> routePatcher, Logger log) {
        this.log = log;
        this.routePatcher = routePatcher;
        this.disposable = pplnObservable.subscribe(next -> {
            IRPCClient.IRequestPipeline<KVRangeRORequest, KVRangeROReply> old = this.ppln;
            this.ppln = next;
            if (old != null) {
                old.close();
            }
        });
    }

    @Override
    public CompletableFuture<KVRangeROReply> query(KVRangeRORequest request) {
        this.log.trace("Invoke ro range request: \n{}", (Object)request);
        return this.ppln.invoke((Object)request).thenApply(v -> {
            if (v.hasLatest()) {
                this.routePatcher.accept(v.getLatest());
            }
            return v;
        });
    }

    @Override
    public void close() {
        this.disposable.dispose();
        if (this.ppln != null) {
            this.ppln.close();
        }
    }
}

