/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.starter.config;

import com.google.common.base.Strings;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.file.Paths;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.bifromq.basehookloader.BaseHookLoader;
import org.apache.bifromq.basekv.localengine.StructUtil;
import org.apache.bifromq.basekv.localengine.spi.IKVEngineProvider;
import org.apache.bifromq.starter.config.StandaloneConfig;
import org.apache.bifromq.starter.config.model.ClusterConfig;
import org.apache.bifromq.starter.config.model.EngineConfig;
import org.apache.bifromq.starter.config.model.RPCConfig;
import org.apache.bifromq.starter.config.model.SSLContextConfig;
import org.apache.bifromq.starter.config.model.ServerSSLContextConfig;
import org.apache.bifromq.starter.config.model.api.APIServerConfig;
import org.apache.bifromq.starter.config.model.dist.DistWorkerConfig;
import org.apache.bifromq.starter.config.model.inbox.InboxStoreConfig;
import org.apache.bifromq.starter.config.model.mqtt.MQTTServerConfig;
import org.apache.bifromq.starter.config.model.retain.RetainStoreConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneConfigConsolidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StandaloneConfigConsolidator.class);
    private static final String USER_DIR_PROP = "user.dir";
    private static final String DATA_DIR_PROP = "DATA_DIR";
    private static final String DATA_PATH_ROOT = "dataPathRoot";

    public static void consolidate(StandaloneConfig config) {
        StandaloneConfigConsolidator.consolidateClusterConfig(config);
        StandaloneConfigConsolidator.consolidateMQTTServerConfig(config);
        StandaloneConfigConsolidator.consolidateRPCConfig(config);
        StandaloneConfigConsolidator.consolidateAPIServerConfig(config);
        StandaloneConfigConsolidator.consolidateEngineConfigs(config);
    }

    private static void consolidateEngineConfigs(StandaloneConfig config) {
        RetainStoreConfig retainStore;
        InboxStoreConfig inboxStore;
        DistWorkerConfig distWorker = config.getDistServiceConfig().getWorker();
        if (distWorker != null) {
            StandaloneConfigConsolidator.consolidateEngine(distWorker.getDataEngineConfig(), true, "dist_data");
            StandaloneConfigConsolidator.consolidateEngine(distWorker.getWalEngineConfig(), false, "dist_wal");
        }
        if ((inboxStore = config.getInboxServiceConfig().getStore()) != null) {
            StandaloneConfigConsolidator.consolidateEngine(inboxStore.getDataEngineConfig(), true, "inbox_data");
            StandaloneConfigConsolidator.consolidateEngine(inboxStore.getWalEngineConfig(), false, "inbox_wal");
        }
        if ((retainStore = config.getRetainServiceConfig().getStore()) != null) {
            StandaloneConfigConsolidator.consolidateEngine(retainStore.getDataEngineConfig(), true, "retain_data");
            StandaloneConfigConsolidator.consolidateEngine(retainStore.getWalEngineConfig(), false, "retain_wal");
        }
    }

    private static void consolidateEngine(EngineConfig cfg, boolean cpable, String name) {
        String type;
        if (cfg == null) {
            cfg = new EngineConfig();
        }
        if (Strings.isNullOrEmpty((String)(type = cfg.getType()))) {
            type = "rocksdb";
            cfg.setType(type);
        }
        IKVEngineProvider provider = StandaloneConfigConsolidator.findProvider(type);
        Struct base = cpable ? provider.defaultsForCPable() : provider.defaultsForWALable();
        EngineConfig override = cfg;
        Map<String, Object> merged = StandaloneConfigConsolidator.overlay(base, override);
        StandaloneConfigConsolidator.derivePathsIfNeeded(cfg, merged, cpable, name);
        cfg.clear();
        cfg.setProps(merged);
    }

    private static void consolidateClusterConfig(StandaloneConfig config) {
        ClusterConfig clusterConfig = config.getClusterConfig();
        if (Strings.isNullOrEmpty((String)clusterConfig.getHost())) {
            clusterConfig.setHost(StandaloneConfigConsolidator.resolveHost(config));
        }
        if (Strings.isNullOrEmpty((String)clusterConfig.getEnv())) {
            throw new IllegalArgumentException("Cluster env cannot be null or empty string");
        }
        if (!Strings.isNullOrEmpty((String)clusterConfig.getClusterDomainName()) && clusterConfig.getPort() == 0) {
            throw new IllegalArgumentException("Port number must be specified and make sure all members use same number if seed address is resolved from domain name");
        }
    }

    private static void consolidateMQTTServerConfig(StandaloneConfig config) {
        block10: {
            MQTTServerConfig mqttServerConfig = config.getMqttServiceConfig().getServer();
            if (mqttServerConfig.getTcpListener().getHost() == null) {
                mqttServerConfig.getTcpListener().setHost("0.0.0.0");
            }
            if (mqttServerConfig.getTlsListener().getHost() == null) {
                mqttServerConfig.getTlsListener().setHost(mqttServerConfig.getTcpListener().getHost());
            }
            if (mqttServerConfig.getWsListener().getHost() == null) {
                mqttServerConfig.getWsListener().setHost(mqttServerConfig.getTcpListener().getHost());
            }
            if (mqttServerConfig.getWssListener().getHost() == null) {
                mqttServerConfig.getWssListener().setHost(mqttServerConfig.getTcpListener().getHost());
            }
            if (mqttServerConfig.getWssListener().isEnable() && mqttServerConfig.getWssListener().getSslConfig() == null || mqttServerConfig.getTlsListener().isEnable() && mqttServerConfig.getTlsListener().getSslConfig() == null) {
                try {
                    ServerSSLContextConfig sslContextConfig = StandaloneConfigConsolidator.genSelfSignedServerCert();
                    if (mqttServerConfig.getTlsListener().isEnable() && mqttServerConfig.getTlsListener().getSslConfig() == null) {
                        mqttServerConfig.getTlsListener().setSslConfig(sslContextConfig);
                    }
                    if (mqttServerConfig.getWssListener().isEnable() && mqttServerConfig.getWssListener().getSslConfig() == null) {
                        mqttServerConfig.getWssListener().setSslConfig(sslContextConfig);
                    }
                }
                catch (Throwable e) {
                    log.warn("Unable to generate self-signed certificate, mqtt over tls or wss will be disabled", e);
                    if (mqttServerConfig.getTlsListener().isEnable() && mqttServerConfig.getTlsListener().getSslConfig() == null) {
                        mqttServerConfig.getTlsListener().setEnable(false);
                    }
                    if (!mqttServerConfig.getWssListener().isEnable() || mqttServerConfig.getWssListener().getSslConfig() != null) break block10;
                    mqttServerConfig.getWssListener().setEnable(false);
                }
            }
        }
    }

    private static void consolidateRPCConfig(StandaloneConfig config) {
        RPCConfig rpcConfig = config.getRpcConfig();
        if (rpcConfig.getHost() == null) {
            rpcConfig.setHost(StandaloneConfigConsolidator.resolveHost(config));
        }
        if (rpcConfig.isEnableSSL() && rpcConfig.getClientSSLConfig() == null && rpcConfig.getServerSSLConfig() == null) {
            rpcConfig.setClientSSLConfig(new SSLContextConfig());
            try {
                log.warn("Generate self-signed certificate for RPC server");
                rpcConfig.setServerSSLConfig(StandaloneConfigConsolidator.genSelfSignedServerCert());
            }
            catch (Throwable e) {
                log.warn("Unable to generate self-signed certificate, rpc client ssl will be disabled", e);
                rpcConfig.setEnableSSL(false);
                rpcConfig.setClientSSLConfig(null);
                rpcConfig.setServerSSLConfig(null);
            }
        }
    }

    private static void consolidateAPIServerConfig(StandaloneConfig config) {
        APIServerConfig apiServerConfig = config.getApiServerConfig();
        if (apiServerConfig.getHost() == null) {
            apiServerConfig.setHost(StandaloneConfigConsolidator.resolveHost(config));
        }
        if (apiServerConfig.isEnableSSL() && apiServerConfig.getSslConfig() == null) {
            try {
                apiServerConfig.setSslConfig(StandaloneConfigConsolidator.genSelfSignedServerCert());
            }
            catch (Throwable e) {
                log.warn("Unable to generate self-signed certificate, Https API listener is be disabled", e);
                apiServerConfig.setEnableSSL(false);
            }
        }
    }

    private static String resolveHost(StandaloneConfig config) {
        String host = config.getMqttServiceConfig().getServer().getTcpListener().getHost();
        if (!"0.0.0.0".equals(host)) {
            return host;
        }
        host = config.getRpcConfig().getHost();
        if (!Strings.isNullOrEmpty((String)host)) {
            return host;
        }
        host = config.getClusterConfig().getHost();
        if (!Strings.isNullOrEmpty((String)host)) {
            return host;
        }
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || !inetAddress.isSiteLocalAddress()) continue;
                return inetAddress.getHostAddress();
            }
        }
        throw new IllegalStateException("Unable to resolve host, please specify host in config file");
    }

    private static ServerSSLContextConfig genSelfSignedServerCert() throws CertificateException {
        SelfSignedCertificate selfCert = new SelfSignedCertificate();
        ServerSSLContextConfig sslContextConfig = new ServerSSLContextConfig();
        sslContextConfig.setCertFile(selfCert.certificate().getAbsolutePath());
        sslContextConfig.setKeyFile(selfCert.privateKey().getAbsolutePath());
        return sslContextConfig;
    }

    private static IKVEngineProvider findProvider(String type) {
        Map providers = BaseHookLoader.load(IKVEngineProvider.class);
        IKVEngineProvider found = null;
        for (IKVEngineProvider p : providers.values()) {
            if (!p.type().equalsIgnoreCase(type)) continue;
            if (found != null) {
                throw new IllegalStateException("Duplicate storage engine provider type: " + type);
            }
            found = p;
        }
        if (found == null) {
            throw new IllegalArgumentException("Unsupported storage engine type: " + type);
        }
        return found;
    }

    private static Map<String, Object> overlay(Struct base, Map<String, Object> override) {
        HashMap<String, Object> merged = new HashMap<String, Object>();
        base.getFieldsMap().forEach((k, defVal) -> {
            if (override.containsKey(k)) {
                Value newVal = StructUtil.toValue(override.get(k));
                if (defVal.getKindCase() != newVal.getKindCase()) {
                    log.warn("Invalid engine config value type: {}, required={}", (Object)newVal.getKindCase(), (Object)defVal.getKindCase());
                    merged.put((String)k, StandaloneConfigConsolidator.normalizeNumber(StructUtil.fromValue((Value)defVal)));
                } else {
                    merged.put((String)k, StandaloneConfigConsolidator.normalizeNumber(StructUtil.fromValue((Value)newVal)));
                }
            } else {
                merged.put((String)k, StandaloneConfigConsolidator.normalizeNumber(StructUtil.fromValue((Value)defVal)));
            }
        });
        override.forEach((k, v) -> {
            if (!merged.containsKey(k) && !k.equals(DATA_PATH_ROOT)) {
                log.warn("Unrecognized engine config: {}={}", k, v);
            }
        });
        return merged;
    }

    private static Object normalizeNumber(Object v) {
        long l;
        double d;
        if (v instanceof Number && Double.isFinite(d = ((Number)v).doubleValue()) && d == (double)(l = (long)d)) {
            if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                return (int)l;
            }
            return l;
        }
        return v;
    }

    private static void derivePathsIfNeeded(EngineConfig cfg, Map<String, Object> completeConf, boolean cpable, String name) {
        String dataRootPath;
        if (!"rocksdb".equalsIgnoreCase(cfg.getType())) {
            return;
        }
        if (cfg.containsKey(DATA_PATH_ROOT)) {
            completeConf.put(DATA_PATH_ROOT, cfg.get(DATA_PATH_ROOT));
            if (Paths.get((String)cfg.get(DATA_PATH_ROOT), new String[0]).isAbsolute()) {
                dataRootPath = (String)cfg.get(DATA_PATH_ROOT);
            } else {
                String userDir = System.getProperty(USER_DIR_PROP);
                String dataDir = System.getProperty(DATA_DIR_PROP, userDir);
                dataRootPath = Paths.get(dataDir, (String)cfg.get(DATA_PATH_ROOT)).toAbsolutePath().toString();
            }
        } else {
            String userDir = System.getProperty(USER_DIR_PROP);
            String dataDir = System.getProperty(DATA_DIR_PROP, userDir);
            dataRootPath = Paths.get(dataDir, new String[0]).toAbsolutePath().toString();
        }
        completeConf.put("dbRootDir", Paths.get(dataRootPath, name).toString());
        if (cpable) {
            completeConf.put("dbCheckpointRootDir", Paths.get(dataRootPath, name + "_cp").toString());
        }
    }
}

