/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.range;

import com.google.common.collect.Maps;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.bifromq.basekv.store.range.IKVRangeQueryLinearizer;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

class KVRangeQueryLinearizer
implements IKVRangeQueryLinearizer {
    private final Logger log;
    private final ConcurrentMap<CompletableFuture<Long>, CompletableFuture<Void>> readIndexes = Maps.newConcurrentMap();
    private final ConcurrentLinkedDeque<ToLinearize> toBeLinearized = new ConcurrentLinkedDeque();
    private final Supplier<CompletableFuture<Long>> readIndexProvider;
    private final Function<Supplier<CompletableFuture<Void>>, CompletableFuture<Void>> recordDuration;
    private final Executor executor;
    private final AtomicBoolean linearizing = new AtomicBoolean();
    private volatile long lastAppliedIndex = 0L;

    KVRangeQueryLinearizer(Supplier<CompletableFuture<Long>> readIndexProvider, Executor executor, long lastAppliedIndex, Function<Supplier<CompletableFuture<Void>>, CompletableFuture<Void>> recordDuration, String ... tags) {
        this.readIndexProvider = readIndexProvider;
        this.recordDuration = recordDuration;
        this.executor = executor;
        this.lastAppliedIndex = lastAppliedIndex;
        this.log = MDCLogger.getLogger(KVRangeQueryLinearizer.class, (String[])tags);
    }

    @Override
    public CompletionStage<Void> linearize() {
        return this.recordDuration.apply(() -> {
            CompletableFuture onDone = new CompletableFuture();
            CompletableFuture<Long> readIndex = this.readIndexProvider.get();
            this.readIndexes.put(readIndex, onDone);
            readIndex.whenCompleteAsync((ri, e) -> {
                if (e != null) {
                    this.log.debug("failed to get readIndex", e);
                    ((CompletableFuture)this.readIndexes.remove(readIndex)).completeExceptionally((Throwable)e);
                } else if (ri <= this.lastAppliedIndex) {
                    ((CompletableFuture)this.readIndexes.remove(readIndex)).complete(null);
                } else {
                    this.readIndexes.remove(readIndex, onDone);
                    if (!onDone.isDone()) {
                        this.toBeLinearized.add(new ToLinearize((long)ri, onDone));
                        this.schedule();
                    }
                }
            }, this.executor);
            return onDone;
        });
    }

    @Override
    public void afterLogApplied(long logIndex) {
        if (logIndex >= this.lastAppliedIndex) {
            this.lastAppliedIndex = logIndex;
            this.schedule();
        }
    }

    private void schedule() {
        if (this.linearizing.compareAndSet(false, true)) {
            this.executor.execute(this::doLinearize);
        }
    }

    private void doLinearize() {
        ToLinearize toLinearize;
        while ((toLinearize = this.toBeLinearized.poll()) != null) {
            if (toLinearize.readIndex <= this.lastAppliedIndex) {
                toLinearize.onDone.complete(null);
                continue;
            }
            this.toBeLinearized.addFirst(toLinearize);
            break;
        }
        this.linearizing.set(false);
        toLinearize = this.toBeLinearized.peek();
        if (toLinearize != null && toLinearize.readIndex <= this.lastAppliedIndex) {
            this.schedule();
        }
    }

    private static class ToLinearize {
        final long readIndex;
        final CompletableFuture<Void> onDone;

        @Generated
        public ToLinearize(long readIndex, CompletableFuture<Void> onDone) {
            this.readIndex = readIndex;
            this.onDone = onDone;
        }
    }
}

