/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler.v5;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.apache.bifromq.inbox.storage.proto.LWT;
import org.apache.bifromq.metrics.ITenantMeter;
import org.apache.bifromq.mqtt.handler.IMQTTProtocolHelper;
import org.apache.bifromq.mqtt.handler.MQTTTransientSessionHandler;
import org.apache.bifromq.mqtt.handler.TenantSettings;
import org.apache.bifromq.mqtt.handler.condition.Condition;
import org.apache.bifromq.mqtt.handler.record.ProtocolResponse;
import org.apache.bifromq.mqtt.handler.v5.IReAuthenticator;
import org.apache.bifromq.mqtt.handler.v5.MQTT5ProtocolHelper;
import org.apache.bifromq.type.ClientInfo;

public final class MQTT5TransientSessionHandler
extends MQTTTransientSessionHandler {
    private final IMQTTProtocolHelper helper;
    private final IReAuthenticator reAuthenticator;

    public MQTT5TransientSessionHandler(MqttConnectMessage connMsg, TenantSettings settings, ITenantMeter tenantMeter, Condition oomCondition, String userSessionId, int keepAliveTimeSeconds, ClientInfo clientInfo, LWT willMessage, ChannelHandlerContext ctx) {
        super(settings, tenantMeter, oomCondition, userSessionId, keepAliveTimeSeconds, clientInfo, willMessage, ctx);
        this.helper = new MQTT5ProtocolHelper(connMsg, settings, clientInfo, this.sessionCtx.userPropsCustomizer);
        this.reAuthenticator = IReAuthenticator.create(connMsg, this.authProvider, clientInfo, x$0 -> this.handleProtocolResponse((ProtocolResponse)x$0), (Executor)ctx.executor());
    }

    @Override
    protected IMQTTProtocolHelper helper() {
        return this.helper;
    }

    @Override
    protected void handleOther(MqttMessage message) {
        if (message.fixedHeader().messageType() == MqttMessageType.AUTH) {
            this.reAuthenticator.onAuth(message);
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        super.handlerAdded(ctx);
        this.memUsage.addAndGet(this.estBaseMemSize());
    }

    @Override
    public void doTearDown(ChannelHandlerContext ctx) {
        super.doTearDown(ctx);
        this.memUsage.addAndGet(-this.estBaseMemSize());
    }

    private int estBaseMemSize() {
        int s = 376;
        s += this.userSessionId.length();
        s += this.clientInfo.getSerializedSize();
        if (this.willMessage() != null) {
            s += this.willMessage().getSerializedSize();
        }
        return s;
    }

    @Generated
    public static MQTT5TransientSessionHandlerBuilder builder() {
        return new MQTT5TransientSessionHandlerBuilder();
    }

    @Generated
    public static class MQTT5TransientSessionHandlerBuilder {
        @Generated
        private MqttConnectMessage connMsg;
        @Generated
        private TenantSettings settings;
        @Generated
        private ITenantMeter tenantMeter;
        @Generated
        private Condition oomCondition;
        @Generated
        private String userSessionId;
        @Generated
        private int keepAliveTimeSeconds;
        @Generated
        private ClientInfo clientInfo;
        @Generated
        private LWT willMessage;
        @Generated
        private ChannelHandlerContext ctx;

        @Generated
        MQTT5TransientSessionHandlerBuilder() {
        }

        @Generated
        public MQTT5TransientSessionHandlerBuilder connMsg(MqttConnectMessage connMsg) {
            this.connMsg = connMsg;
            return this;
        }

        @Generated
        public MQTT5TransientSessionHandlerBuilder settings(TenantSettings settings) {
            this.settings = settings;
            return this;
        }

        @Generated
        public MQTT5TransientSessionHandlerBuilder tenantMeter(ITenantMeter tenantMeter) {
            this.tenantMeter = tenantMeter;
            return this;
        }

        @Generated
        public MQTT5TransientSessionHandlerBuilder oomCondition(Condition oomCondition) {
            this.oomCondition = oomCondition;
            return this;
        }

        @Generated
        public MQTT5TransientSessionHandlerBuilder userSessionId(String userSessionId) {
            this.userSessionId = userSessionId;
            return this;
        }

        @Generated
        public MQTT5TransientSessionHandlerBuilder keepAliveTimeSeconds(int keepAliveTimeSeconds) {
            this.keepAliveTimeSeconds = keepAliveTimeSeconds;
            return this;
        }

        @Generated
        public MQTT5TransientSessionHandlerBuilder clientInfo(ClientInfo clientInfo) {
            this.clientInfo = clientInfo;
            return this;
        }

        @Generated
        public MQTT5TransientSessionHandlerBuilder willMessage(LWT willMessage) {
            this.willMessage = willMessage;
            return this;
        }

        @Generated
        public MQTT5TransientSessionHandlerBuilder ctx(ChannelHandlerContext ctx) {
            this.ctx = ctx;
            return this;
        }

        @Generated
        public MQTT5TransientSessionHandler build() {
            return new MQTT5TransientSessionHandler(this.connMsg, this.settings, this.tenantMeter, this.oomCondition, this.userSessionId, this.keepAliveTimeSeconds, this.clientInfo, this.willMessage, this.ctx);
        }

        @Generated
        public String toString() {
            return "MQTT5TransientSessionHandler.MQTT5TransientSessionHandlerBuilder(connMsg=" + String.valueOf(this.connMsg) + ", settings=" + String.valueOf(this.settings) + ", tenantMeter=" + String.valueOf(this.tenantMeter) + ", oomCondition=" + String.valueOf(this.oomCondition) + ", userSessionId=" + this.userSessionId + ", keepAliveTimeSeconds=" + this.keepAliveTimeSeconds + ", clientInfo=" + String.valueOf(this.clientInfo) + ", willMessage=" + String.valueOf(this.willMessage) + ", ctx=" + String.valueOf(this.ctx) + ")";
        }
    }
}

