/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data;

import java.io.Serializable;
import org.apache.paimon.data.BinaryArray;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.serializer.InternalArraySerializer;
import org.apache.paimon.data.serializer.InternalMapSerializer;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.data.variant.Variant;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeChecks;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.TimestampType;

public interface BinaryWriter {
    public void reset();

    public void setNullAt(int var1);

    public void writeBoolean(int var1, boolean var2);

    public void writeByte(int var1, byte var2);

    public void writeShort(int var1, short var2);

    public void writeInt(int var1, int var2);

    public void writeLong(int var1, long var2);

    public void writeFloat(int var1, float var2);

    public void writeDouble(int var1, double var2);

    public void writeString(int var1, BinaryString var2);

    public void writeBinary(int var1, byte[] var2);

    public void writeDecimal(int var1, Decimal var2, int var3);

    public void writeTimestamp(int var1, Timestamp var2, int var3);

    public void writeVariant(int var1, Variant var2);

    public void writeArray(int var1, InternalArray var2, InternalArraySerializer var3);

    public void writeMap(int var1, InternalMap var2, InternalMapSerializer var3);

    public void writeRow(int var1, InternalRow var2, InternalRowSerializer var3);

    public void complete();

    @Deprecated
    public static void write(BinaryWriter writer, int pos, Object o, DataType type, Serializer<?> serializer) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: {
                writer.writeBoolean(pos, (Boolean)o);
                break;
            }
            case TINYINT: {
                writer.writeByte(pos, (Byte)o);
                break;
            }
            case SMALLINT: {
                writer.writeShort(pos, (Short)o);
                break;
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: {
                writer.writeInt(pos, (Integer)o);
                break;
            }
            case BIGINT: {
                writer.writeLong(pos, (Long)o);
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                TimestampType timestampType = (TimestampType)type;
                writer.writeTimestamp(pos, (Timestamp)o, timestampType.getPrecision());
                break;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                LocalZonedTimestampType lzTs = (LocalZonedTimestampType)type;
                writer.writeTimestamp(pos, (Timestamp)o, lzTs.getPrecision());
                break;
            }
            case FLOAT: {
                writer.writeFloat(pos, ((Float)o).floatValue());
                break;
            }
            case DOUBLE: {
                writer.writeDouble(pos, (Double)o);
                break;
            }
            case CHAR: 
            case VARCHAR: {
                writer.writeString(pos, (BinaryString)o);
                break;
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)type;
                writer.writeDecimal(pos, (Decimal)o, decimalType.getPrecision());
                break;
            }
            case ARRAY: {
                writer.writeArray(pos, (InternalArray)o, (InternalArraySerializer)serializer);
                break;
            }
            case MAP: 
            case MULTISET: {
                writer.writeMap(pos, (InternalMap)o, (InternalMapSerializer)serializer);
                break;
            }
            case ROW: {
                writer.writeRow(pos, (InternalRow)o, (InternalRowSerializer)serializer);
                break;
            }
            case BINARY: 
            case VARBINARY: {
                writer.writeBinary(pos, (byte[])o);
                break;
            }
            case VARIANT: {
                writer.writeVariant(pos, (Variant)o);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not support type: " + type);
            }
        }
    }

    public static ValueSetter createValueSetter(DataType elementType) {
        return BinaryWriter.createValueSetter(elementType, null);
    }

    public static ValueSetter createValueSetter(DataType elementType, Serializer<?> serializer) {
        switch (elementType.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                return (writer, pos, value) -> writer.writeString(pos, (BinaryString)value);
            }
            case BOOLEAN: {
                return (writer, pos, value) -> writer.writeBoolean(pos, (Boolean)value);
            }
            case BINARY: 
            case VARBINARY: {
                return (writer, pos, value) -> writer.writeBinary(pos, (byte[])value);
            }
            case DECIMAL: {
                int decimalPrecision = DataTypeChecks.getPrecision(elementType);
                return (writer, pos, value) -> writer.writeDecimal(pos, (Decimal)value, decimalPrecision);
            }
            case TINYINT: {
                return (writer, pos, value) -> writer.writeByte(pos, (Byte)value);
            }
            case SMALLINT: {
                return (writer, pos, value) -> writer.writeShort(pos, (Short)value);
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: {
                return (writer, pos, value) -> writer.writeInt(pos, (Integer)value);
            }
            case BIGINT: {
                return (writer, pos, value) -> writer.writeLong(pos, (Long)value);
            }
            case FLOAT: {
                return (writer, pos, value) -> writer.writeFloat(pos, ((Float)value).floatValue());
            }
            case DOUBLE: {
                return (writer, pos, value) -> writer.writeDouble(pos, (Double)value);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                int timestampPrecision = DataTypeChecks.getPrecision(elementType);
                return (writer, pos, value) -> writer.writeTimestamp(pos, (Timestamp)value, timestampPrecision);
            }
            case ARRAY: {
                Serializer<Object> arraySerializer = serializer == null ? InternalSerializers.create(elementType) : serializer;
                return (writer, pos, value) -> writer.writeArray(pos, (InternalArray)value, (InternalArraySerializer)arraySerializer);
            }
            case MAP: 
            case MULTISET: {
                Serializer<Object> mapSerializer = serializer == null ? InternalSerializers.create(elementType) : serializer;
                return (writer, pos, value) -> writer.writeMap(pos, (InternalMap)value, (InternalMapSerializer)mapSerializer);
            }
            case ROW: {
                Serializer<Object> rowSerializer = serializer == null ? InternalSerializers.create(elementType) : serializer;
                return (writer, pos, value) -> writer.writeRow(pos, (InternalRow)value, (InternalRowSerializer)rowSerializer);
            }
            case VARIANT: {
                return (writer, pos, value) -> writer.writeVariant(pos, (Variant)value);
            }
        }
        String msg = String.format("type %s not support in %s", elementType.getTypeRoot().toString(), BinaryArray.class.getName());
        throw new IllegalArgumentException(msg);
    }

    public static interface ValueSetter
    extends Serializable {
        public void setValue(BinaryWriter var1, int var2, Object var3);
    }
}

