/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.columnar.heap;

import java.util.Arrays;
import org.apache.paimon.data.columnar.heap.AbstractHeapVector;
import org.apache.paimon.data.columnar.heap.HeapIntVector;
import org.apache.paimon.data.columnar.writable.WritableBooleanVector;

public class HeapBooleanVector
extends AbstractHeapVector
implements WritableBooleanVector {
    private static final long serialVersionUID = 4131239076731313596L;
    public boolean[] vector;

    public HeapBooleanVector(int len) {
        super(len);
        this.vector = new boolean[len];
    }

    @Override
    public HeapIntVector reserveDictionaryIds(int capacity) {
        throw new RuntimeException("HeapBooleanVector has no dictionary.");
    }

    @Override
    public HeapIntVector getDictionaryIds() {
        throw new RuntimeException("HeapBooleanVector has no dictionary.");
    }

    @Override
    void reserveForHeapVector(int newCapacity) {
        if (this.vector.length < newCapacity) {
            this.vector = Arrays.copyOf(this.vector, newCapacity);
        }
    }

    @Override
    public boolean getBoolean(int i) {
        return this.vector[i];
    }

    @Override
    public void setBoolean(int i, boolean value) {
        this.vector[i] = value;
    }

    @Override
    public void setBooleans(int rowId, int count, boolean value) {
        for (int i = 0; i < count; ++i) {
            this.vector[i + rowId] = value;
        }
    }

    @Override
    public void setBooleans(int rowId, int count, byte src, int srcIndex) {
        assert (count + srcIndex <= 8);
        for (int i = 0; i < count; ++i) {
            this.vector[i + rowId] = (byte)(src >>> i + srcIndex & 1) == 1;
        }
    }

    @Override
    public void setBooleans(int rowId, byte src) {
        this.setBooleans(rowId, 8, src, 0);
    }

    @Override
    public void fill(boolean value) {
        Arrays.fill(this.vector, value);
    }

    @Override
    public void reset() {
        super.reset();
        if (this.vector.length != this.capacity) {
            this.vector = new boolean[this.capacity];
        } else {
            Arrays.fill(this.vector, false);
        }
    }
}

