/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import java.io.IOException;
import org.apache.paimon.data.columnar.BooleanColumnVector;
import org.apache.paimon.data.columnar.BytesColumnVector;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.DoubleColumnVector;
import org.apache.paimon.data.columnar.FloatColumnVector;
import org.apache.paimon.data.columnar.IntColumnVector;
import org.apache.paimon.data.columnar.LongColumnVector;
import org.apache.paimon.data.columnar.writable.WritableColumnVector;
import org.apache.paimon.data.columnar.writable.WritableIntVector;
import org.apache.paimon.format.parquet.reader.ParquetDictionary;
import org.apache.paimon.format.parquet.reader.ParquetReadState;
import org.apache.paimon.format.parquet.reader.ParquetVectorUpdater;
import org.apache.paimon.format.parquet.reader.ParquetVectorUpdaterFactory;
import org.apache.paimon.format.parquet.reader.VectorizedDeltaBinaryPackedReader;
import org.apache.paimon.format.parquet.reader.VectorizedDeltaByteArrayReader;
import org.apache.paimon.format.parquet.reader.VectorizedDeltaLengthByteArrayReader;
import org.apache.paimon.format.parquet.reader.VectorizedPlainValuesReader;
import org.apache.paimon.format.parquet.reader.VectorizedRleValuesReader;
import org.apache.paimon.format.parquet.reader.VectorizedValuesReader;
import org.apache.paimon.shade.org.apache.parquet.CorruptDeltaByteArrays;
import org.apache.paimon.shade.org.apache.parquet.VersionParser;
import org.apache.paimon.shade.org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.paimon.shade.org.apache.parquet.bytes.BytesInput;
import org.apache.paimon.shade.org.apache.parquet.bytes.BytesUtils;
import org.apache.paimon.shade.org.apache.parquet.column.ColumnDescriptor;
import org.apache.paimon.shade.org.apache.parquet.column.Dictionary;
import org.apache.paimon.shade.org.apache.parquet.column.Encoding;
import org.apache.paimon.shade.org.apache.parquet.column.page.DataPage;
import org.apache.paimon.shade.org.apache.parquet.column.page.DataPageV1;
import org.apache.paimon.shade.org.apache.parquet.column.page.DataPageV2;
import org.apache.paimon.shade.org.apache.parquet.column.page.DictionaryPage;
import org.apache.paimon.shade.org.apache.parquet.column.page.PageReadStore;
import org.apache.paimon.shade.org.apache.parquet.column.page.PageReader;
import org.apache.paimon.shade.org.apache.parquet.column.values.RequiresPreviousReader;
import org.apache.paimon.shade.org.apache.parquet.column.values.ValuesReader;
import org.apache.paimon.shade.org.apache.parquet.schema.PrimitiveType;
import org.apache.paimon.types.DataType;

public class VectorizedColumnReader {
    private final Dictionary dictionary;
    private boolean isCurrentPageDictionaryEncoded;
    private ValuesReader dataColumn;
    private VectorizedRleValuesReader defColumn;
    private VectorizedRleValuesReader repColumn;
    private final ParquetReadState readState;
    private long pageFirstRowIndex;
    private final PageReader pageReader;
    private final ColumnDescriptor descriptor;
    private final VersionParser.ParsedVersion writerVersion;

    public VectorizedColumnReader(ColumnDescriptor descriptor, boolean isRequired, PageReadStore pageReadStore, VersionParser.ParsedVersion writerVersion) throws IOException {
        this.descriptor = descriptor;
        this.pageReader = pageReadStore.getPageReader(descriptor);
        this.readState = new ParquetReadState(descriptor, isRequired, pageReadStore.getRowIndexes().orElse(null));
        DictionaryPage dictionaryPage = this.pageReader.readDictionaryPage();
        if (dictionaryPage != null) {
            try {
                this.dictionary = dictionaryPage.getEncoding().initDictionary(descriptor, dictionaryPage);
                this.isCurrentPageDictionaryEncoded = true;
            }
            catch (IOException e) {
                throw new IOException("could not decode the dictionary for " + descriptor, e);
            }
        } else {
            this.dictionary = null;
            this.isCurrentPageDictionaryEncoded = false;
        }
        if (this.pageReader.getTotalValueCount() == 0L) {
            throw new IOException("totalValueCount == 0");
        }
        this.writerVersion = writerVersion;
    }

    private boolean isLazyDecodingSupported(PrimitiveType.PrimitiveTypeName typeName, ColumnVector columnVector) {
        boolean isSupported = false;
        switch (typeName) {
            case INT32: {
                isSupported = columnVector instanceof IntColumnVector;
                break;
            }
            case INT64: {
                isSupported = columnVector instanceof LongColumnVector;
                break;
            }
            case FLOAT: {
                isSupported = columnVector instanceof FloatColumnVector;
                break;
            }
            case DOUBLE: {
                isSupported = columnVector instanceof DoubleColumnVector;
                break;
            }
            case BOOLEAN: {
                isSupported = columnVector instanceof BooleanColumnVector;
                break;
            }
            case BINARY: {
                isSupported = columnVector instanceof BytesColumnVector;
            }
        }
        return isSupported;
    }

    void readBatch(int total, DataType type, WritableColumnVector column, WritableIntVector repetitionLevels, WritableIntVector definitionLevels) throws IOException {
        WritableIntVector dictionaryIds = null;
        ParquetVectorUpdater updater = ParquetVectorUpdaterFactory.getUpdater(this.descriptor, type);
        if (this.dictionary != null) {
            dictionaryIds = column.reserveDictionaryIds(total);
        }
        this.readState.resetForNewBatch(total);
        while (this.readState.rowsToReadInBatch > 0 || !this.readState.lastListCompleted) {
            if (this.readState.valuesToReadInPage == 0) {
                int pageValueCount = this.readPage();
                if (pageValueCount < 0) break;
                this.readState.resetForNewPage(pageValueCount, this.pageFirstRowIndex);
            }
            PrimitiveType.PrimitiveTypeName typeName = this.descriptor.getPrimitiveType().getPrimitiveTypeName();
            if (this.isCurrentPageDictionaryEncoded) {
                int startOffset = this.readState.valueOffset;
                long startRowId = this.readState.rowId;
                if (this.readState.maxRepetitionLevel == 0) {
                    this.defColumn.readIntegers(this.readState, dictionaryIds, column, definitionLevels, (VectorizedValuesReader)((Object)this.dataColumn));
                } else {
                    this.repColumn.readIntegersRepeated(this.readState, repetitionLevels, this.defColumn, definitionLevels, dictionaryIds, column, (VectorizedValuesReader)((Object)this.dataColumn));
                }
                if (column.hasDictionary() || startRowId == this.pageFirstRowIndex && this.isLazyDecodingSupported(typeName, column)) {
                    column.setDictionary(new ParquetDictionary(this.dictionary));
                    continue;
                }
                updater.decodeDictionaryIds(this.readState.valueOffset - startOffset, startOffset, column, dictionaryIds, this.dictionary);
                continue;
            }
            if (column.hasDictionary() && this.readState.valueOffset != 0) {
                updater.decodeDictionaryIds(this.readState.valueOffset, 0, column, dictionaryIds, this.dictionary);
            }
            column.setDictionary(null);
            VectorizedValuesReader valuesReader = (VectorizedValuesReader)((Object)this.dataColumn);
            if (this.readState.maxRepetitionLevel == 0) {
                this.defColumn.readBatch(this.readState, column, definitionLevels, valuesReader, updater);
                continue;
            }
            this.repColumn.readBatchRepeated(this.readState, repetitionLevels, this.defColumn, definitionLevels, column, valuesReader, updater);
        }
    }

    private int readPage() {
        DataPage page = this.pageReader.readPage();
        if (page == null) {
            return -1;
        }
        this.pageFirstRowIndex = page.getFirstRowIndex().orElse(0L);
        return page.accept(new DataPage.Visitor<Integer>(){

            @Override
            public Integer visit(DataPageV1 dataPageV1) {
                try {
                    return VectorizedColumnReader.this.readPageV1(dataPageV1);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Integer visit(DataPageV2 dataPageV2) {
                try {
                    return VectorizedColumnReader.this.readPageV2(dataPageV2);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void initDataReader(int pageValueCount, Encoding dataEncoding, ByteBufferInputStream in) throws IOException {
        ValuesReader previousReader = this.dataColumn;
        if (dataEncoding.usesDictionary()) {
            this.dataColumn = null;
            if (this.dictionary == null) {
                throw new IOException("could not read page in col " + this.descriptor + " as the dictionary was missing for encoding " + (Object)((Object)dataEncoding));
            }
            Encoding plainDict = Encoding.PLAIN_DICTIONARY;
            if (dataEncoding != plainDict && dataEncoding != Encoding.RLE_DICTIONARY) {
                throw new UnsupportedOperationException("error: _LEGACY_ERROR_TEMP_3189, encoding: " + (Object)((Object)dataEncoding));
            }
            this.dataColumn = new VectorizedRleValuesReader();
            this.isCurrentPageDictionaryEncoded = true;
        } else {
            this.dataColumn = this.getValuesReader(dataEncoding);
            this.isCurrentPageDictionaryEncoded = false;
        }
        try {
            this.dataColumn.initFromPage(pageValueCount, in);
        }
        catch (IOException e) {
            throw new IOException("could not read page in col " + this.descriptor, e);
        }
        if (CorruptDeltaByteArrays.requiresSequentialReads(this.writerVersion, dataEncoding) && previousReader instanceof RequiresPreviousReader) {
            ((RequiresPreviousReader)((Object)this.dataColumn)).setPreviousReader(previousReader);
        }
    }

    private ValuesReader getValuesReader(Encoding encoding) {
        switch (encoding) {
            case PLAIN: {
                return new VectorizedPlainValuesReader();
            }
            case DELTA_BYTE_ARRAY: {
                return new VectorizedDeltaByteArrayReader();
            }
            case DELTA_LENGTH_BYTE_ARRAY: {
                return new VectorizedDeltaLengthByteArrayReader();
            }
            case DELTA_BINARY_PACKED: {
                return new VectorizedDeltaBinaryPackedReader();
            }
            case RLE: {
                PrimitiveType.PrimitiveTypeName typeName = this.descriptor.getPrimitiveType().getPrimitiveTypeName();
                if (typeName == PrimitiveType.PrimitiveTypeName.BOOLEAN) {
                    return new VectorizedRleValuesReader(1);
                }
                throw new RuntimeException("error: _LEGACY_ERROR_TEMP_3190, typeName: " + typeName.toString());
            }
        }
        throw new RuntimeException("error: _LEGACY_ERROR_TEMP_3189, encoding: " + (Object)((Object)encoding));
    }

    private int readPageV1(DataPageV1 page) throws IOException {
        if (page.getDlEncoding() != Encoding.RLE && this.descriptor.getMaxDefinitionLevel() != 0) {
            throw new RuntimeException("error: _LEGACY_ERROR_TEMP_3189, encoding " + page.getDlEncoding().toString());
        }
        int pageValueCount = page.getValueCount();
        int rlBitWidth = BytesUtils.getWidthFromMaxInt(this.descriptor.getMaxRepetitionLevel());
        this.repColumn = new VectorizedRleValuesReader(rlBitWidth);
        int dlBitWidth = BytesUtils.getWidthFromMaxInt(this.descriptor.getMaxDefinitionLevel());
        this.defColumn = new VectorizedRleValuesReader(dlBitWidth);
        try {
            BytesInput bytes = page.getBytes();
            ByteBufferInputStream in = bytes.toInputStream();
            this.repColumn.initFromPage(pageValueCount, in);
            this.defColumn.initFromPage(pageValueCount, in);
            this.initDataReader(pageValueCount, page.getValueEncoding(), in);
            return pageValueCount;
        }
        catch (IOException e) {
            throw new IOException("could not read page " + page + " in col " + this.descriptor, e);
        }
    }

    private int readPageV2(DataPageV2 page) throws IOException {
        int pageValueCount = page.getValueCount();
        int rlBitWidth = BytesUtils.getWidthFromMaxInt(this.descriptor.getMaxRepetitionLevel());
        this.repColumn = new VectorizedRleValuesReader(rlBitWidth, false);
        this.repColumn.initFromPage(pageValueCount, page.getRepetitionLevels().toInputStream());
        int dlBitWidth = BytesUtils.getWidthFromMaxInt(this.descriptor.getMaxDefinitionLevel());
        this.defColumn = new VectorizedRleValuesReader(dlBitWidth, false);
        this.defColumn.initFromPage(pageValueCount, page.getDefinitionLevels().toInputStream());
        try {
            this.initDataReader(pageValueCount, page.getDataEncoding(), page.getData().toInputStream());
            return pageValueCount;
        }
        catch (IOException e) {
            throw new IOException("could not read page " + page + " in col " + this.descriptor, e);
        }
    }
}

