/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.orc.impl.mask;

import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.paimon.shade.org.apache.orc.DataMask;

public class ListIdentity
implements DataMask {
    private final DataMask child;

    ListIdentity(DataMask[] child) {
        this.child = child[0];
    }

    @Override
    public void maskData(ColumnVector original, ColumnVector masked, int start, int length) {
        ListColumnVector source2 = (ListColumnVector)original;
        ListColumnVector target = (ListColumnVector)masked;
        target.noNulls = source2.noNulls;
        target.isRepeating = source2.isRepeating;
        if (source2.isRepeating) {
            if (!source2.noNulls && source2.isNull[0]) {
                target.isNull[0] = true;
            } else {
                target.lengths[0] = source2.lengths[0];
                this.child.maskData(source2.child, target.child, (int)source2.offsets[0], (int)source2.lengths[0]);
            }
        } else if (source2.noNulls) {
            for (int r = start; r < start + length; ++r) {
                target.offsets[r] = source2.offsets[r];
                target.lengths[r] = source2.lengths[r];
                this.child.maskData(source2.child, target.child, (int)target.offsets[r], (int)target.lengths[r]);
            }
        } else {
            for (int r = start; r < start + length; ++r) {
                target.isNull[r] = source2.isNull[r];
                if (source2.isNull[r]) continue;
                target.offsets[r] = source2.offsets[r];
                target.lengths[r] = source2.lengths[r];
                this.child.maskData(source2.child, target.child, (int)target.offsets[r], (int)target.lengths[r]);
            }
        }
    }
}

