/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.predicate.CompoundPredicate;
import org.apache.paimon.predicate.Equal;
import org.apache.paimon.predicate.InPredicateVisitor;
import org.apache.paimon.predicate.LeafPredicate;
import org.apache.paimon.predicate.LeafPredicateExtractor;
import org.apache.paimon.predicate.Or;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ReadOnceTableScan;
import org.apache.paimon.table.source.SingletonSplit;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.tag.Tag;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.ProjectedRow;
import org.apache.paimon.utils.SerializationUtils;
import org.apache.paimon.utils.TagManager;

public class TagsTable
implements ReadonlyTable {
    private static final long serialVersionUID = 1L;
    public static final String TAGS = "tags";
    private static final String TAG_NAME = "tag_name";
    public static final RowType TABLE_TYPE = new RowType(Arrays.asList(new DataField(0, "tag_name", SerializationUtils.newStringType(false)), new DataField(1, "snapshot_id", new BigIntType(false)), new DataField(2, "schema_id", new BigIntType(false)), new DataField(3, "commit_time", new TimestampType(false, 3)), new DataField(4, "record_count", new BigIntType(true)), new DataField(5, "create_time", new TimestampType(true, 3)), new DataField(6, "time_retained", SerializationUtils.newStringType(true))));
    private final FileIO fileIO;
    private final Path location;
    private final String branch;
    private final FileStoreTable dataTable;

    public TagsTable(FileStoreTable dataTable) {
        this.fileIO = dataTable.fileIO();
        this.location = dataTable.location();
        this.branch = CoreOptions.branch(dataTable.schema().options());
        this.dataTable = dataTable;
    }

    @Override
    public String name() {
        return this.location.getName() + "$" + TAGS;
    }

    @Override
    public RowType rowType() {
        return TABLE_TYPE;
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.singletonList(TAG_NAME);
    }

    @Override
    public FileIO fileIO() {
        return this.dataTable.fileIO();
    }

    @Override
    public InnerTableScan newScan() {
        return new TagsScan();
    }

    @Override
    public InnerTableRead newRead() {
        return new TagsRead(this.fileIO);
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new TagsTable((FileStoreTable)this.dataTable.copy((Map)dynamicOptions));
    }

    private class TagsRead
    implements InnerTableRead {
        private final FileIO fileIO;
        private RowType readType;

        public TagsRead(FileIO fileIO) {
            this.fileIO = fileIO;
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public InnerTableRead withReadType(RowType readType) {
            this.readType = readType;
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) {
            if (!(split instanceof TagsSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            Path location = ((TagsSplit)split).location;
            Predicate predicate = ((TagsSplit)split).tagPredicate;
            TagManager tagManager = new TagManager(this.fileIO, location, TagsTable.this.branch);
            TreeMap<Object, Object> nameToSnapshot = new TreeMap<Object, Object>();
            TreeMap predicateMap = new TreeMap();
            if (predicate != null) {
                Object compoundPredicate;
                if (predicate instanceof LeafPredicate && ((LeafPredicate)predicate).function() instanceof Equal && ((LeafPredicate)predicate).literals().get(0) instanceof BinaryString && predicate.visit(LeafPredicateExtractor.INSTANCE).get(TagsTable.TAG_NAME) != null) {
                    String equalValue = ((LeafPredicate)predicate).literals().get(0).toString();
                    tagManager.get(equalValue).ifPresent(tag -> predicateMap.put(equalValue, tag));
                }
                if (predicate instanceof CompoundPredicate && ((CompoundPredicate)(compoundPredicate = (CompoundPredicate)predicate)).function() instanceof Or) {
                    ArrayList arrayList = new ArrayList();
                    InPredicateVisitor.extractInElements(predicate, TagsTable.TAG_NAME).ifPresent(e -> e.stream().map(Object::toString).forEach(tagNames::add));
                    arrayList.forEach(name -> tagManager.get((String)name).ifPresent(value -> predicateMap.put(name, value)));
                }
            }
            if (!predicateMap.isEmpty()) {
                nameToSnapshot.putAll(predicateMap);
            } else {
                for (Pair pair : tagManager.tagObjects()) {
                    nameToSnapshot.put(pair.getValue(), pair.getKey());
                }
            }
            Iterator rows = Iterators.transform(nameToSnapshot.entrySet().iterator(), this::toRow);
            if (this.readType != null) {
                rows = Iterators.transform(rows, row -> ProjectedRow.from(this.readType, TABLE_TYPE).replaceRow((InternalRow)row));
            }
            return new IteratorRecordReader<InternalRow>(rows);
        }

        private InternalRow toRow(Map.Entry<String, Tag> snapshot) {
            Tag tag = snapshot.getValue();
            return GenericRow.of(BinaryString.fromString(snapshot.getKey()), tag.id(), tag.schemaId(), Timestamp.fromLocalDateTime(DateTimeUtils.toLocalDateTime(tag.timeMillis())), tag.totalRecordCount(), Optional.ofNullable(tag.getTagCreateTime()).map(Timestamp::fromLocalDateTime).orElse(null), Optional.ofNullable(tag.getTagTimeRetained()).map(Object::toString).map(BinaryString::fromString).orElse(null));
        }
    }

    private static class TagsSplit
    extends SingletonSplit {
        private static final long serialVersionUID = 1L;
        private final Path location;
        @Nullable
        private final Predicate tagPredicate;

        private TagsSplit(Path location, @Nullable Predicate tagPredicate) {
            this.location = location;
            this.tagPredicate = tagPredicate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TagsSplit that = (TagsSplit)o;
            return Objects.equals(this.location, that.location) && Objects.equals(this.tagPredicate, that.tagPredicate);
        }

        public int hashCode() {
            return Objects.hash(this.location);
        }
    }

    private class TagsScan
    extends ReadOnceTableScan {
        @Nullable
        private Predicate tagPredicate;

        private TagsScan() {
        }

        @Override
        public InnerTableScan withFilter(Predicate predicate) {
            if (predicate == null) {
                return this;
            }
            this.tagPredicate = predicate;
            return this;
        }

        @Override
        public TableScan.Plan innerPlan() {
            return () -> Collections.singletonList(new TagsSplit(TagsTable.this.location, this.tagPredicate));
        }
    }
}

