/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.nio.ByteOrder;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.memory.MemorySegment;

public class SortUtil {
    private static final int BYTE_ARRAY_BASE_OFFSET = MemorySegment.UNSAFE.arrayBaseOffset(byte[].class);
    private static final boolean LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    private static final int LONG_BYTES = 8;

    public static void minNormalizedKey(MemorySegment target, int offset, int numBytes) {
        for (int i = 0; i < numBytes; ++i) {
            target.put(offset + i, (byte)0);
        }
    }

    public static void maxNormalizedKey(MemorySegment target, int offset, int numBytes) {
        for (int i = 0; i < numBytes; ++i) {
            target.put(offset + i, (byte)-1);
        }
    }

    public static void putShortNormalizedKey(short value, MemorySegment target, int offset, int numBytes) {
        if (numBytes == 2) {
            int highByte = value >>> 8 & 0xFF;
            target.put(offset, (byte)(highByte += 128));
            target.put(offset + 1, (byte)(value & 0xFF));
        } else if (numBytes > 0) {
            if (numBytes == 1) {
                int highByte = value >>> 8 & 0xFF;
                target.put(offset, (byte)(highByte += 128));
            } else {
                int highByte = value >>> 8 & 0xFF;
                target.put(offset, (byte)(highByte += 128));
                target.put(offset + 1, (byte)(value & 0xFF));
                for (int i = 2; i < numBytes; ++i) {
                    target.put(offset + i, (byte)0);
                }
            }
        }
    }

    public static void putByteNormalizedKey(byte value, MemorySegment target, int offset, int numBytes) {
        if (numBytes == 1) {
            int highByte = value & 0xFF;
            target.put(offset, (byte)(highByte += 128));
        } else if (numBytes > 0) {
            int highByte = value & 0xFF;
            target.put(offset, (byte)(highByte += 128));
            for (int i = 1; i < numBytes; ++i) {
                target.put(offset + i, (byte)0);
            }
        }
    }

    public static void putBooleanNormalizedKey(boolean value, MemorySegment target, int offset, int numBytes) {
        if (numBytes > 0) {
            target.put(offset, (byte)(value ? 1 : 0));
            ++offset;
            while (numBytes > 1) {
                target.put(offset++, (byte)0);
                --numBytes;
            }
        }
    }

    public static void putStringNormalizedKey(BinaryString value, MemorySegment target, int offset, int numBytes) {
        int i;
        int limit = offset + numBytes;
        int end = value.getSizeInBytes();
        for (i = 0; i < end && offset < limit; ++i) {
            target.put(offset++, value.byteAt(i));
        }
        for (i = offset; i < limit; ++i) {
            target.put(i, (byte)0);
        }
    }

    public static void putDecimalNormalizedKey(Decimal record, MemorySegment target, int offset, int len) {
        assert (record.isCompact());
        SortUtil.putLongNormalizedKey(record.toUnscaledLong(), target, offset, len);
    }

    public static void putIntNormalizedKey(int value, MemorySegment target, int offset, int numBytes) {
        SortUtil.putUnsignedIntegerNormalizedKey(value - Integer.MIN_VALUE, target, offset, numBytes);
    }

    public static void putLongNormalizedKey(long value, MemorySegment target, int offset, int numBytes) {
        SortUtil.putUnsignedLongNormalizedKey(value - Long.MIN_VALUE, target, offset, numBytes);
    }

    public static void putFloatNormalizedKey(float value, MemorySegment target, int offset, int numBytes) {
        int iValue = Float.floatToIntBits(value);
        iValue ^= iValue >> 31 | Integer.MIN_VALUE;
        SortUtil.putUnsignedIntegerNormalizedKey(iValue, target, offset, numBytes);
    }

    public static void putDoubleNormalizedKey(double value, MemorySegment target, int offset, int numBytes) {
        long lValue = Double.doubleToLongBits(value);
        lValue ^= lValue >> 63 | Long.MIN_VALUE;
        SortUtil.putUnsignedLongNormalizedKey(lValue, target, offset, numBytes);
    }

    public static void putBinaryNormalizedKey(byte[] value, MemorySegment target, int offset, int numBytes) {
        int i;
        int limit = offset + numBytes;
        int end = value.length;
        for (i = 0; i < end && offset < limit; ++i) {
            target.put(offset++, value[i]);
        }
        for (i = offset; i < limit; ++i) {
            target.put(i, (byte)0);
        }
    }

    public static void putTimestampNormalizedKey(Timestamp value, MemorySegment target, int offset, int numBytes) {
        assert (value.getNanoOfMillisecond() == 0);
        SortUtil.putLongNormalizedKey(value.getMillisecond(), target, offset, numBytes);
    }

    public static void putUnsignedIntegerNormalizedKey(int value, MemorySegment target, int offset, int numBytes) {
        block5: {
            block4: {
                if (numBytes != 4) break block4;
                target.putIntBigEndian(offset, value);
                break block5;
            }
            if (numBytes <= 0) break block5;
            if (numBytes < 4) {
                int i = 0;
                while (numBytes > 0) {
                    target.put(offset + i, (byte)(value >>> (3 - i << 3)));
                    --numBytes;
                    ++i;
                }
            } else {
                target.putIntBigEndian(offset, value);
                for (int i = 4; i < numBytes; ++i) {
                    target.put(offset + i, (byte)0);
                }
            }
        }
    }

    public static void putUnsignedLongNormalizedKey(long value, MemorySegment target, int offset, int numBytes) {
        block5: {
            block4: {
                if (numBytes != 8) break block4;
                target.putLongBigEndian(offset, value);
                break block5;
            }
            if (numBytes <= 0) break block5;
            if (numBytes < 8) {
                int i = 0;
                while (numBytes > 0) {
                    target.put(offset + i, (byte)(value >>> (7 - i << 3)));
                    --numBytes;
                    ++i;
                }
            } else {
                target.putLongBigEndian(offset, value);
                for (int i = 8; i < numBytes; ++i) {
                    target.put(offset + i, (byte)0);
                }
            }
        }
    }

    public static int compareBinary(byte[] a, byte[] b) {
        return SortUtil.compareBinary(a, 0, a.length, b, 0, b.length);
    }

    public static int compareBinary(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
        int i;
        if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
            return 0;
        }
        int minLength = Math.min(length1, length2);
        int minWords = minLength / 8;
        int offset1Adj = offset1 + BYTE_ARRAY_BASE_OFFSET;
        int offset2Adj = offset2 + BYTE_ARRAY_BASE_OFFSET;
        for (i = 0; i < minWords * 8; i += 8) {
            int y;
            long rw;
            long lw = MemorySegment.UNSAFE.getLong(buffer1, (long)offset1Adj + (long)i);
            long diff = lw ^ (rw = MemorySegment.UNSAFE.getLong(buffer2, (long)offset2Adj + (long)i));
            if (diff == 0L) continue;
            if (!LITTLE_ENDIAN) {
                return SortUtil.lessThanUnsigned(lw, rw) ? -1 : 1;
            }
            int n = 0;
            int x = (int)diff;
            if (x == 0) {
                x = (int)(diff >>> 32);
                n = 32;
            }
            if ((y = x << 16) == 0) {
                n += 16;
            } else {
                x = y;
            }
            y = x << 8;
            if (y == 0) {
                n += 8;
            }
            return (int)((lw >>> n & 0xFFL) - (rw >>> n & 0xFFL));
        }
        for (i = minWords * 8; i < minLength; ++i) {
            int result = SortUtil.unsignedByteToInt(buffer1[offset1 + i]) - SortUtil.unsignedByteToInt(buffer2[offset2 + i]);
            if (result == 0) continue;
            return result;
        }
        return length1 - length2;
    }

    private static int unsignedByteToInt(byte value) {
        return value & 0xFF;
    }

    private static boolean lessThanUnsigned(long x1, long x2) {
        return x1 + Long.MIN_VALUE < x2 + Long.MIN_VALUE;
    }
}

