/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.comm;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.comm.RequestHandler;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.utils.LogUtils;
import com.aliyun.oss.event.ProgressInputStream;
import com.aliyun.oss.event.ProgressListener;
import com.aliyun.oss.event.ProgressPublisher;
import com.aliyun.oss.model.WebServiceRequest;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Map;

public class RequestProgressHanlder
implements RequestHandler {
    @Override
    public void handle(RequestMessage request) throws OSSException, ClientException {
        InputStream content;
        WebServiceRequest originalRequest = request.getOriginalRequest();
        ProgressListener listener = originalRequest.getProgressListener();
        Map<String, String> headers = request.getHeaders();
        String s2 = headers.get("Content-Length");
        if (s2 != null) {
            try {
                long contentLength = Long.parseLong(s2);
                ProgressPublisher.publishRequestContentLength(listener, contentLength);
            }
            catch (NumberFormatException e) {
                LogUtils.logException("Cannot parse the Content-Length header of the request: ", e);
            }
        }
        if ((content = request.getContent()) == null) {
            return;
        }
        if (!content.markSupported()) {
            content = new BufferedInputStream(content);
        }
        request.setContent(listener == ProgressListener.NOOP ? content : ProgressInputStream.inputStreamForRequest(content, originalRequest));
    }
}

