/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.shaded.org.apache.commons.configuration.tree.xpath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.fluss.shaded.org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.fluss.shaded.org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.fluss.shaded.org.apache.commons.configuration.tree.NodeAddData;
import org.apache.fluss.shaded.org.apache.commons.configuration.tree.xpath.ConfigurationNodePointerFactory;
import org.apache.fluss.shaded.org.apache.commons.jxpath.JXPathContext;
import org.apache.fluss.shaded.org.apache.commons.jxpath.ri.JXPathContextReferenceImpl;
import org.apache.fluss.shaded.org.apache.commons.jxpath.ri.model.NodePointerFactory;
import org.apache.fluss.shaded.org.apache.commons.lang.StringUtils;

public class XPathExpressionEngine
implements ExpressionEngine {
    static final String PATH_DELIMITER = "/";
    static final String ATTR_DELIMITER = "@";
    private static final String NODE_PATH_DELIMITERS = "/@";

    public List query(ConfigurationNode root, String key) {
        if (StringUtils.isEmpty(key)) {
            ArrayList<ConfigurationNode> result = new ArrayList<ConfigurationNode>(1);
            result.add(root);
            return result;
        }
        JXPathContext context = this.createContext(root, key);
        List result = context.selectNodes(key);
        return result != null ? result : Collections.EMPTY_LIST;
    }

    public String nodeKey(ConfigurationNode node, String parentKey) {
        if (parentKey == null) {
            return "";
        }
        if (node.getName() == null) {
            return parentKey;
        }
        StringBuffer buf = new StringBuffer(parentKey.length() + node.getName().length() + PATH_DELIMITER.length());
        if (parentKey.length() > 0) {
            buf.append(parentKey);
            buf.append(PATH_DELIMITER);
        }
        if (node.isAttribute()) {
            buf.append(ATTR_DELIMITER);
        }
        buf.append(node.getName());
        return buf.toString();
    }

    public NodeAddData prepareAdd(ConfigurationNode root, String key) {
        int index;
        if (key == null) {
            throw new IllegalArgumentException("prepareAdd: key must not be null!");
        }
        for (index = key.length() - 1; index >= 0 && !Character.isWhitespace(key.charAt(index)); --index) {
        }
        if (index < 0) {
            throw new IllegalArgumentException("prepareAdd: Passed in key must contain a whitespace!");
        }
        List nodes = this.query(root, key.substring(0, index).trim());
        if (nodes.size() != 1) {
            throw new IllegalArgumentException("prepareAdd: key must select exactly one target node!");
        }
        NodeAddData data = new NodeAddData();
        data.setParent((ConfigurationNode)nodes.get(0));
        this.initNodeAddData(data, key.substring(index).trim());
        return data;
    }

    protected JXPathContext createContext(ConfigurationNode root, String key) {
        JXPathContext context = JXPathContext.newContext((Object)root);
        context.setLenient(true);
        return context;
    }

    protected void initNodeAddData(NodeAddData data, String path) {
        String lastComponent = null;
        boolean attr = false;
        boolean first = true;
        StringTokenizer tok = new StringTokenizer(path, NODE_PATH_DELIMITERS, true);
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (PATH_DELIMITER.equals(token)) {
                if (attr) {
                    this.invalidPath(path, " contains an attribute delimiter at an unallowed position.");
                }
                if (lastComponent == null) {
                    this.invalidPath(path, " contains a '/' at an unallowed position.");
                }
                data.addPathNode(lastComponent);
                lastComponent = null;
            } else if (ATTR_DELIMITER.equals(token)) {
                if (attr) {
                    this.invalidPath(path, " contains multiple attribute delimiters.");
                }
                if (lastComponent == null && !first) {
                    this.invalidPath(path, " contains an attribute delimiter at an unallowed position.");
                }
                if (lastComponent != null) {
                    data.addPathNode(lastComponent);
                }
                attr = true;
                lastComponent = null;
            } else {
                lastComponent = token;
            }
            first = false;
        }
        if (lastComponent == null) {
            this.invalidPath(path, "contains no components.");
        }
        data.setNewNodeName(lastComponent);
        data.setAttribute(attr);
    }

    private void invalidPath(String path, String msg) {
        throw new IllegalArgumentException("Invalid node path: \"" + path + "\" " + msg);
    }

    static {
        JXPathContextReferenceImpl.addNodePointerFactory((NodePointerFactory)new ConfigurationNodePointerFactory());
    }
}

