/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.fs.s3;

import org.apache.fluss.fs.hdfs.HadoopFileSystem;
import org.apache.fluss.fs.s3.token.S3DelegationTokenProvider;
import org.apache.fluss.fs.token.ObtainedSecurityToken;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

public class S3FileSystem
extends HadoopFileSystem {
    private final String scheme;
    private final Configuration conf;
    private volatile S3DelegationTokenProvider s3DelegationTokenProvider;

    public S3FileSystem(String scheme, FileSystem hadoopS3FileSystem, Configuration conf) {
        super(hadoopS3FileSystem);
        this.scheme = scheme;
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObtainedSecurityToken obtainSecurityToken() {
        if (this.s3DelegationTokenProvider == null) {
            S3FileSystem s3FileSystem = this;
            synchronized (s3FileSystem) {
                if (this.s3DelegationTokenProvider == null) {
                    this.s3DelegationTokenProvider = new S3DelegationTokenProvider(this.scheme, this.conf);
                }
            }
        }
        return this.s3DelegationTokenProvider.obtainSecurityToken();
    }
}

