/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class NetgroupCache {
    private static ConcurrentHashMap<String, Set<String>> userToNetgroupsMap = new ConcurrentHashMap();

    public static void getNetgroups(String user, List<String> groups2) {
        Set<String> userGroups = userToNetgroupsMap.get(user);
        if (userGroups != null) {
            groups2.addAll(userGroups);
        }
    }

    public static List<String> getNetgroupNames() {
        return new LinkedList<String>(NetgroupCache.getGroups());
    }

    private static Set<String> getGroups() {
        HashSet<String> allGroups = new HashSet<String>();
        for (Set<String> userGroups : userToNetgroupsMap.values()) {
            allGroups.addAll(userGroups);
        }
        return allGroups;
    }

    public static boolean isCached(String group) {
        return NetgroupCache.getGroups().contains(group);
    }

    public static void clear() {
        userToNetgroupsMap.clear();
    }

    public static void add(String group, List<String> users) {
        for (String user : users) {
            Set<String> currentSet;
            Set<String> userGroups = userToNetgroupsMap.get(user);
            if (userGroups == null && (currentSet = userToNetgroupsMap.putIfAbsent(user, userGroups = Collections.newSetFromMap(new ConcurrentHashMap()))) != null) {
                userGroups = currentSet;
            }
            userGroups.add(group);
        }
    }
}

