
# Geaflow Project Roles and Responsibilities

- [Role Overview](#role-overview)
  - [Users](#users)
  - [Contributors](#contributors)
  - [Committers](#committers)
- [The Apache Way](#the-apache-way)

This project follows the [Apache Software Foundation (ASF) Governance Ladder](https://theapacheway.com/ladder/). Below are the main roles, how to move between them, and their responsibilities.

## Role Overview

| Role         | Level   | Key Requirements                 | Main Responsibilities             |
| ------------ | ------- | -------------------------------- | --------------------------------- |
| Users        | Entry   | Use GeaFlow                      | Report issues, provide feedback   |
| Contributors | Active  | Submit PRs/issues                | Code contributions, documentation |
| Committers   | Trusted | Consistent quality contributions | Review code, merge PRs, mentor    |

### Users
**Who:** Anyone who uses GeaFlow.

**Responsibilities:**
- Use the software and report bugs or issues.
- Ask questions and share feedback.
- Help others by sharing your experience.

### Contributors
**Who:** Anyone who contributes code, documentation, tests, or suggestions.

**How to become:** Start by submitting pull requests, reporting issues, or helping in discussions.

**Responsibilities:**
- Submit code, docs, or other improvements.
- Review and discuss pull requests and issues.
- Follow the contribution guidelines and coding standards.

### Committers
**Who:** Contributors who have shown consistent, high-quality contributions and are invited by the PMC.

**How to become:** After making valuable contributions, the PMC may vote to grant you committer rights.

**Responsibilities:**
- Review, approve, and merge pull requests.
- Maintain code quality and documentation.
- Help and mentor new contributors.
- Follow ASF and project policies.



## The Apache Way

GeaFlow follows the [Apache Way](https://www.apache.org/foundation/how-it-works.html):
- **Community over Code:** A healthy, welcoming community is most important.
- **Meritocracy:** People gain more responsibility by making valuable contributions.
- **Openness:** All decisions and discussions happen in public.
- **Consensus:** The community works together to reach agreement.

For more details, see the [ASF Governance](https://www.apache.org/foundation/governance/) and [How It Works](https://www.apache.org/foundation/how-it-works.html).
