/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements. See the NOTICE file distributed with this
work for additional information regarding copyright ownership. The ASF
licenses this file to You under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
License for the specific language governing permissions and limitations
under the License.
*/

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.2.0
// - protoc             v3.21.1
// source: pd_pulse.proto

package pulse

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// HgPdPulseClient is the client API for HgPdPulse service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type HgPdPulseClient interface {
	Pulse(ctx context.Context, opts ...grpc.CallOption) (HgPdPulse_PulseClient, error)
}

type hgPdPulseClient struct {
	cc grpc.ClientConnInterface
}

func NewHgPdPulseClient(cc grpc.ClientConnInterface) HgPdPulseClient {
	return &hgPdPulseClient{cc}
}

func (c *hgPdPulseClient) Pulse(ctx context.Context, opts ...grpc.CallOption) (HgPdPulse_PulseClient, error) {
	stream, err := c.cc.NewStream(ctx, &HgPdPulse_ServiceDesc.Streams[0], "/HgPdPulse/Pulse", opts...)
	if err != nil {
		return nil, err
	}
	x := &hgPdPulsePulseClient{stream}
	return x, nil
}

type HgPdPulse_PulseClient interface {
	Send(*PulseRequest) error
	Recv() (*PulseResponse, error)
	grpc.ClientStream
}

type hgPdPulsePulseClient struct {
	grpc.ClientStream
}

func (x *hgPdPulsePulseClient) Send(m *PulseRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *hgPdPulsePulseClient) Recv() (*PulseResponse, error) {
	m := new(PulseResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// HgPdPulseServer is the server API for HgPdPulse service.
// All implementations must embed UnimplementedHgPdPulseServer
// for forward compatibility
type HgPdPulseServer interface {
	Pulse(HgPdPulse_PulseServer) error
	mustEmbedUnimplementedHgPdPulseServer()
}

// UnimplementedHgPdPulseServer must be embedded to have forward compatible implementations.
type UnimplementedHgPdPulseServer struct {
}

func (UnimplementedHgPdPulseServer) Pulse(HgPdPulse_PulseServer) error {
	return status.Errorf(codes.Unimplemented, "method Pulse not implemented")
}
func (UnimplementedHgPdPulseServer) mustEmbedUnimplementedHgPdPulseServer() {}

// UnsafeHgPdPulseServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to HgPdPulseServer will
// result in compilation errors.
type UnsafeHgPdPulseServer interface {
	mustEmbedUnimplementedHgPdPulseServer()
}

func RegisterHgPdPulseServer(s grpc.ServiceRegistrar, srv HgPdPulseServer) {
	s.RegisterService(&HgPdPulse_ServiceDesc, srv)
}

func _HgPdPulse_Pulse_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(HgPdPulseServer).Pulse(&hgPdPulsePulseServer{stream})
}

type HgPdPulse_PulseServer interface {
	Send(*PulseResponse) error
	Recv() (*PulseRequest, error)
	grpc.ServerStream
}

type hgPdPulsePulseServer struct {
	grpc.ServerStream
}

func (x *hgPdPulsePulseServer) Send(m *PulseResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *hgPdPulsePulseServer) Recv() (*PulseRequest, error) {
	m := new(PulseRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// HgPdPulse_ServiceDesc is the grpc.ServiceDesc for HgPdPulse service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var HgPdPulse_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "HgPdPulse",
	HandlerType: (*HgPdPulseServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Pulse",
			Handler:       _HgPdPulse_Pulse_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "pd_pulse.proto",
}
