/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.conf;

import org.apache.hadoop.hive.metastore.conf.Validator;

public class RangeValidator
implements Validator {
    private final Validator.TYPE type;
    private final Object lower;
    private final Object upper;

    public RangeValidator(Object lower, Object upper) {
        this.lower = lower;
        this.upper = upper;
        this.type = Validator.TYPE.valueOf(lower, upper);
    }

    @Override
    public void validate(String value) {
        if (value == null || !this.type.inRange(value.trim(), this.lower, this.upper)) {
            throw new IllegalArgumentException("Invalid value  " + value + ", which should be in between " + this.lower + " and " + this.upper);
        }
    }
}

