/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc;

import java.util.Arrays;
import org.apache.calcite.adapter.jdbc.JdbcRules;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rex.RexNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.jdbc.HiveJdbcConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCRexCallValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCFilterPushDownRule
extends RelOptRule {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCFilterPushDownRule.class);
    public static final JDBCFilterPushDownRule INSTANCE = new JDBCFilterPushDownRule();

    public JDBCFilterPushDownRule() {
        super(JDBCFilterPushDownRule.operand(HiveFilter.class, (RelOptRuleOperand)JDBCFilterPushDownRule.operand(HiveJdbcConverter.class, (RelOptRuleOperandChildren)JDBCFilterPushDownRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
    }

    public boolean matches(RelOptRuleCall call) {
        HiveFilter filter = (HiveFilter)call.rel(0);
        HiveJdbcConverter converter = (HiveJdbcConverter)call.rel(1);
        RexNode cond = filter.getCondition();
        return JDBCRexCallValidator.isValidJdbcOperation(cond, converter.getJdbcDialect());
    }

    public void onMatch(RelOptRuleCall call) {
        LOG.debug("JDBCFilterPushDown has been called");
        HiveFilter filter = (HiveFilter)call.rel(0);
        HiveJdbcConverter converter = (HiveJdbcConverter)call.rel(1);
        Filter newHiveFilter = filter.copy(filter.getTraitSet(), converter.getInput(), filter.getCondition());
        JdbcRules.JdbcFilter newJdbcFilter = (JdbcRules.JdbcFilter)new JdbcRules.JdbcFilterRule(converter.getJdbcConvention()).convert((RelNode)newHiveFilter);
        if (newJdbcFilter != null) {
            RelNode converterRes = converter.copy(converter.getTraitSet(), Arrays.asList(newJdbcFilter));
            call.transformTo(converterRes);
        }
    }
}

