/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.serializer.direct;

import java.util.Arrays;
import java.util.Map;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.serializer.direct.struct.HugeType;
import org.apache.hugegraph.serializer.direct.util.BytesBuffer;
import org.apache.hugegraph.serializer.direct.util.GraphSchema;
import org.apache.hugegraph.serializer.direct.util.Id;
import org.apache.hugegraph.serializer.direct.util.IdGenerator;
import org.apache.hugegraph.structure.GraphElement;
import org.apache.hugegraph.structure.graph.Edge;
import org.apache.hugegraph.structure.schema.PropertyKey;

public class HBaseSerializer {
    private final int edgeLogicPartitions;
    private final int vertexLogicPartitions;
    private final HugeClient client;
    private final GraphSchema graphSchema;

    public HBaseSerializer(HugeClient client, int vertexPartitions, int edgePartitions) {
        this.client = client;
        this.graphSchema = new GraphSchema(client);
        this.edgeLogicPartitions = edgePartitions;
        this.vertexLogicPartitions = vertexPartitions;
    }

    public byte[] getKeyBytes(GraphElement e) {
        byte[] array = null;
        if (e.type() == "vertex" && e.id() != null) {
            BytesBuffer buffer = BytesBuffer.allocate(3 + e.id().toString().length());
            buffer.writeShort(this.getPartition(HugeType.VERTEX, IdGenerator.of(e.id())));
            buffer.writeId(IdGenerator.of(e.id()));
            array = buffer.bytes();
        } else if (e.type() == "edge") {
            BytesBuffer buffer = BytesBuffer.allocate(128);
            Edge edge = (Edge)e;
            buffer.writeShort(this.getPartition(HugeType.EDGE, IdGenerator.of(edge.sourceId())));
            buffer.writeId(IdGenerator.of(edge.sourceId()));
            buffer.write(HugeType.EDGE_OUT.code());
            buffer.writeId(IdGenerator.of(this.graphSchema.getEdgeLabel(e.label()).id()));
            buffer.writeStringWithEnding("");
            buffer.writeId(IdGenerator.of(edge.targetId()));
            array = buffer.bytes();
        }
        return array;
    }

    public byte[] getValueBytes(GraphElement e) {
        byte[] array = null;
        if (e.type() == "vertex") {
            int propsCount = e.properties().size();
            BytesBuffer buffer = BytesBuffer.allocate(8 + 16 * propsCount);
            buffer.writeId(IdGenerator.of(this.graphSchema.getVertexLabel(e.label()).id()));
            buffer.writeVInt(propsCount);
            for (Map.Entry<String, Object> entry : e.properties().entrySet()) {
                PropertyKey propertyKey = this.graphSchema.getPropertyKey(entry.getKey());
                buffer.writeVInt(propertyKey.id().intValue());
                buffer.writeProperty(propertyKey.dataType(), entry.getValue());
            }
            array = buffer.bytes();
        } else if (e.type() == "edge") {
            int propsCount = e.properties().size();
            BytesBuffer buffer = BytesBuffer.allocate(4 + 16 * propsCount);
            buffer.writeVInt(propsCount);
            for (Map.Entry<String, Object> entry : e.properties().entrySet()) {
                PropertyKey propertyKey = this.graphSchema.getPropertyKey(entry.getKey());
                buffer.writeVInt(propertyKey.id().intValue());
                buffer.writeProperty(propertyKey.dataType(), entry.getValue());
            }
            array = buffer.bytes();
        }
        return array;
    }

    public short getPartition(HugeType type, Id id) {
        int hashcode = Arrays.hashCode(id.asBytes());
        short partition = 1;
        if (type.isEdge()) {
            partition = (short)(hashcode % this.edgeLogicPartitions);
        } else if (type.isVertex()) {
            partition = (short)(hashcode % this.vertexLogicPartitions);
        }
        return partition > 0 ? partition : (short)(-partition);
    }

    public int getEdgeLogicPartitions() {
        return this.edgeLogicPartitions;
    }

    public int getVertexLogicPartitions() {
        return this.vertexLogicPartitions;
    }

    public void close() {
        this.client.close();
    }
}

