/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.variables;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.constant.HugeType;

public class VariablesAPI
extends API {
    private static final String PATH = "graphspaces/%s/graphs/%s/%s";
    private static String batchPath = "";

    public VariablesAPI(RestClient client, String graphSpace, String graph) {
        super(client);
        this.path(PATH, graphSpace, graph, this.type());
        batchPath = String.join((CharSequence)"/", this.path(), "batch");
    }

    @Override
    protected String type() {
        return HugeType.VARIABLES.string();
    }

    public Map<String, Object> get(String key) {
        RestResult result = this.client.get(this.path(), key);
        return (Map)result.readObject(Map.class);
    }

    public Map<String, Object> set(String key, Object value) {
        value = ImmutableMap.of((Object)"data", (Object)value);
        RestResult result = this.client.put(this.path(), key, value);
        return (Map)result.readObject(Map.class);
    }

    public void remove(String key) {
        this.client.delete(this.path(), key);
    }

    public Map<String, Object> all() {
        RestResult result = this.client.get(this.path());
        return (Map)result.readObject(Map.class);
    }
}

