/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.client;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.Map;
import okhttp3.Response;
import org.apache.hugegraph.exception.ServerException;
import org.apache.hugegraph.rest.AbstractRestClient;
import org.apache.hugegraph.rest.ClientException;
import org.apache.hugegraph.rest.RestClientConfig;
import org.apache.hugegraph.rest.RestHeaders;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.serializer.PathDeserializer;
import org.apache.hugegraph.structure.graph.Path;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.VersionUtil;

public class RestClient
extends AbstractRestClient {
    private static final int SECOND = 1000;
    private String version;
    private boolean supportGs;
    private VersionUtil.Version apiVersion = null;

    public RestClient(String url, String username, String password, int timeout) {
        super(url, username, password, timeout * 1000);
    }

    @Deprecated
    public RestClient(String url, String username, String password, int timeout, int maxConns, int maxConnsPerRoute, String trustStoreFile, String trustStorePassword) {
        super(url, username, password, timeout * 1000, maxConns, maxConnsPerRoute, trustStoreFile, trustStorePassword);
    }

    public RestClient(String url, String token, int timeout) {
        this(url, RestClientConfig.builder().token(token).timeout(Integer.valueOf(timeout * 1000)).build());
    }

    public RestClient(String url, RestClientConfig config) {
        super(url, config);
    }

    public RestClient(String url, String token, int timeout, int maxConns, int maxConnsPerRoute, String trustStoreFile, String trustStorePassword) {
        super(url, token, timeout * 1000, maxConns, maxConnsPerRoute, trustStoreFile, trustStorePassword);
    }

    private static String removeDefaultGsPrefix(String path) {
        String DEFAULT_GS_PATH_PREFIX = "graphspaces/DEFAULT/";
        String EMPTY = "";
        return path.replaceFirst("graphspaces/DEFAULT/", "");
    }

    public void apiVersion(VersionUtil.Version version) {
        E.checkNotNull((Object)version, (String)"api version");
        this.apiVersion = version;
    }

    public VersionUtil.Version apiVersion() {
        return this.apiVersion;
    }

    public void checkApiVersion(String minVersion, String message) {
        if (this.apiVersionLt(minVersion)) {
            throw new ClientException("HugeGraphServer API version must be >= %s to support %s, but current HugeGraphServer API version is: %s", new Object[]{minVersion, message, this.apiVersion.get()});
        }
    }

    public boolean apiVersionLt(String minVersion) {
        String apiVersion = this.apiVersion == null ? null : this.apiVersion.get();
        return apiVersion != null && !VersionUtil.gte((String)apiVersion, (String)minVersion);
    }

    public RestResult post(String path, Object object) {
        return super.post(this.supportGs ? path : RestClient.removeDefaultGsPrefix(path), object);
    }

    public RestResult get(String path, String id) {
        return super.get(this.supportGs ? path : RestClient.removeDefaultGsPrefix(path), id);
    }

    public RestResult getVersions(String path) {
        return super.get(path);
    }

    public RestResult delete(String path, Map<String, Object> params) {
        return super.delete(this.supportGs ? path : RestClient.removeDefaultGsPrefix(path), params);
    }

    public RestResult delete(String path, String id) {
        return super.delete(this.supportGs ? path : RestClient.removeDefaultGsPrefix(path), id);
    }

    public RestResult post(String path, Object object, RestHeaders headers) {
        return super.post(this.supportGs ? path : RestClient.removeDefaultGsPrefix(path), object, headers);
    }

    public RestResult post(String path, Object object, Map<String, Object> params) {
        return super.post(this.supportGs ? path : RestClient.removeDefaultGsPrefix(path), object, params);
    }

    public RestResult post(String path, Object object, RestHeaders headers, Map<String, Object> params) {
        return super.post(this.supportGs ? path : RestClient.removeDefaultGsPrefix(path), object, headers, params);
    }

    public RestResult put(String path, String id, Object object) {
        return super.put(this.supportGs ? path : RestClient.removeDefaultGsPrefix(path), id, object);
    }

    public RestResult put(String path, String id, Object object, RestHeaders headers) {
        return super.put(this.supportGs ? path : RestClient.removeDefaultGsPrefix(path), id, object, headers);
    }

    public RestResult put(String path, String id, Object object, Map<String, Object> params) {
        return super.put(this.supportGs ? path : RestClient.removeDefaultGsPrefix(path), id, object, params);
    }

    public RestResult put(String path, String id, Object object, RestHeaders headers, Map<String, Object> params) {
        return super.put(this.supportGs ? path : RestClient.removeDefaultGsPrefix(path), id, object, headers, params);
    }

    public RestResult get(String path) {
        return super.get(this.supportGs ? path : RestClient.removeDefaultGsPrefix(path));
    }

    public RestResult get(String path, Map<String, Object> params) {
        return super.get(this.supportGs ? path : RestClient.removeDefaultGsPrefix(path), params);
    }

    protected void checkStatus(Response response, int ... statuses) {
        boolean match = false;
        for (int status : statuses) {
            if (status != response.code()) continue;
            match = true;
            break;
        }
        if (!match) {
            throw ServerException.fromResponse(response);
        }
    }

    public boolean isSupportGs() {
        return this.supportGs;
    }

    public void setSupportGs(boolean supportGs) {
        this.supportGs = supportGs;
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Path.class, (JsonDeserializer)new PathDeserializer());
        RestResult.registerModule((Module)module);
    }
}

