/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.driver;

import com.google.common.base.Strings;
import java.io.Closeable;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.driver.AuthManager;
import org.apache.hugegraph.driver.ComputerManager;
import org.apache.hugegraph.driver.CypherManager;
import org.apache.hugegraph.driver.GraphManager;
import org.apache.hugegraph.driver.GraphSpaceManager;
import org.apache.hugegraph.driver.GraphsManager;
import org.apache.hugegraph.driver.GremlinManager;
import org.apache.hugegraph.driver.HStoreManager;
import org.apache.hugegraph.driver.HugeClientBuilder;
import org.apache.hugegraph.driver.JobManager;
import org.apache.hugegraph.driver.MetricsManager;
import org.apache.hugegraph.driver.PDManager;
import org.apache.hugegraph.driver.SchemaManager;
import org.apache.hugegraph.driver.SchemaTemplateManager;
import org.apache.hugegraph.driver.ServiceManager;
import org.apache.hugegraph.driver.TaskManager;
import org.apache.hugegraph.driver.TraverserManager;
import org.apache.hugegraph.driver.VariablesManager;
import org.apache.hugegraph.driver.VermeerManager;
import org.apache.hugegraph.driver.VersionManager;
import org.apache.hugegraph.driver.WhiteIpListManager;
import org.apache.hugegraph.rest.ClientException;
import org.apache.hugegraph.rest.RestClientConfig;
import org.apache.hugegraph.util.VersionUtil;
import org.apache.hugegraph.version.ClientVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HugeClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(RestClient.class);
    protected String graphSpaceName;
    protected String graphName;
    private final boolean borrowedClient;
    private final RestClient client;
    private VersionManager version;
    private GraphsManager graphs;
    private SchemaManager schema;
    private GraphManager graph;
    private GremlinManager gremlin;
    private CypherManager cypher;
    private TraverserManager traverser;
    private VariablesManager variable;
    private JobManager job;
    private TaskManager task;
    private ComputerManager computer;
    private AuthManager auth;
    private MetricsManager metrics;
    private GraphSpaceManager graphSpace;
    private ServiceManager serviceManager;
    private SchemaTemplateManager schemaTemplageManager;
    private PDManager pdManager;
    private HStoreManager hStoreManager;
    private WhiteIpListManager whiteIpListManager;
    private VermeerManager vermeerManager;

    public HugeClient(HugeClientBuilder builder) {
        this.borrowedClient = false;
        this.graphSpaceName = builder.graphSpace();
        this.graphName = builder.graph();
        try {
            RestClientConfig config = RestClientConfig.builder().token(builder.token()).user(builder.username()).password(builder.password()).timeout(Integer.valueOf(builder.timeout())).connectTimeout(builder.connectTimeout()).readTimeout(builder.readTimeout()).maxConns(Integer.valueOf(builder.maxConns())).maxConnsPerRoute(Integer.valueOf(builder.maxConnsPerRoute())).trustStoreFile(builder.trustStoreFile()).trustStorePassword(builder.trustStorePassword()).builderCallback(builder.httpBuilderConsumer()).build();
            this.client = new RestClient(builder.url(), config);
        }
        catch (Exception e) {
            LOG.warn("Failed to create RestClient instance", (Throwable)e);
            throw new ClientException("Failed to connect url '%s'", new Object[]{builder.url()});
        }
        try {
            this.initManagers(this.client, builder.graphSpace(), builder.graph());
        }
        catch (Throwable e) {
            this.client.close();
            throw e;
        }
    }

    public HugeClient(HugeClient client, String graphSpace, String graph) {
        this.borrowedClient = true;
        this.client = client.client;
        this.initManagers(this.client, graphSpace, graph);
    }

    public static HugeClientBuilder builder(String url, String graphSpace, String graph) {
        return new HugeClientBuilder(url, graphSpace, graph);
    }

    public static HugeClientBuilder builder(String url, String graph) {
        return new HugeClientBuilder(url, "DEFAULT", graph);
    }

    public HugeClient assignGraph(String graphSpace, String graph) {
        this.graphSpaceName = graphSpace;
        this.graphName = graph;
        this.initManagers(this.client, this.graphSpaceName, this.graphName);
        return this;
    }

    @Override
    public void close() {
        if (!this.borrowedClient) {
            this.client.close();
        }
    }

    public void initManagers(RestClient client, String graphSpace, String graph) {
        assert (client != null);
        this.version = new VersionManager(client);
        this.checkServerApiVersion();
        this.graphs = new GraphsManager(client, graphSpace);
        this.auth = new AuthManager(client, graphSpace, graph);
        this.metrics = new MetricsManager(client);
        this.graphSpace = new GraphSpaceManager(client);
        this.schemaTemplageManager = new SchemaTemplateManager(client, graphSpace);
        this.serviceManager = new ServiceManager(client, graphSpace);
        this.pdManager = new PDManager(client);
        this.hStoreManager = new HStoreManager(client);
        this.whiteIpListManager = new WhiteIpListManager(client);
        this.vermeerManager = new VermeerManager(client);
        if (!Strings.isNullOrEmpty((String)graph)) {
            this.schema = new SchemaManager(client, graphSpace, graph);
            this.graph = new GraphManager(client, graphSpace, graph);
            this.gremlin = new GremlinManager(client, graphSpace, graph, this.graph);
            this.cypher = new CypherManager(client, graphSpace, graph, this.graph);
            this.traverser = new TraverserManager(client, this.graph);
            this.variable = new VariablesManager(client, graphSpace, graph);
            this.job = new JobManager(client, graphSpace, graph);
            this.task = new TaskManager(client, graphSpace, graph);
        }
    }

    private void checkServerApiVersion() {
        VersionUtil.Version apiVersion = VersionUtil.Version.of((String)this.version.getApiVersion());
        VersionUtil.check((VersionUtil.Version)apiVersion, (String)"0.38", (String)"0.81", (String)"hugegraph-api in server");
        this.client.apiVersion(apiVersion);
        boolean supportGs = VersionUtil.gte((String)this.version.getCoreVersion(), (String)"1.7.0");
        this.client.setSupportGs(supportGs);
    }

    public GraphsManager graphs() {
        return this.graphs;
    }

    public SchemaManager schema() {
        return this.schema;
    }

    public GraphManager graph() {
        return this.graph;
    }

    public GremlinManager gremlin() {
        return this.gremlin;
    }

    public CypherManager cypher() {
        return this.cypher;
    }

    public TraverserManager traverser() {
        return this.traverser;
    }

    public VariablesManager variables() {
        return this.variable;
    }

    public JobManager job() {
        return this.job;
    }

    public ComputerManager computer() {
        return this.computer;
    }

    public TaskManager task() {
        return this.task;
    }

    public AuthManager auth() {
        return this.auth;
    }

    public MetricsManager metrics() {
        return this.metrics;
    }

    public GraphSpaceManager graphSpace() {
        return this.graphSpace;
    }

    public WhiteIpListManager whiteIpListManager() {
        return this.whiteIpListManager;
    }

    public VermeerManager vermeer() {
        return this.vermeerManager;
    }

    public SchemaTemplateManager schemaTemplateManager() {
        return this.schemaTemplageManager;
    }

    public ServiceManager serviceManager() {
        return this.serviceManager;
    }

    public PDManager pdManager() {
        return this.pdManager;
    }

    public HStoreManager hStoreManager() {
        return this.hStoreManager;
    }

    public VersionManager versionManager() {
        return this.version;
    }

    public String getAuthContext() {
        return this.client.getAuthContext();
    }

    public void setAuthContext(String auth) {
        this.client.setAuthContext(auth);
    }

    public void resetAuthContext() {
        this.client.resetAuthContext();
    }

    public String getGraphSpaceName() {
        return this.graphSpaceName;
    }

    public String getGraphName() {
        return this.graphName;
    }

    static {
        ClientVersion.check();
    }
}

