/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.mapping;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hugegraph.loader.constant.Checkable;
import org.apache.hugegraph.loader.constant.ElemType;
import org.apache.hugegraph.loader.source.InputSource;
import org.apache.hugegraph.structure.graph.UpdateStrategy;
import org.apache.hugegraph.util.E;

@JsonPropertyOrder(value={"label", "skip"})
public abstract class ElementMapping
implements Checkable {
    @JsonProperty(value="label")
    private String label;
    @JsonProperty(value="skip")
    private boolean skip = false;
    @JsonProperty(value="field_mapping")
    private Map<String, String> mappingFields = new HashMap<String, String>();
    @JsonProperty(value="value_mapping")
    private Map<String, Map<String, Object>> mappingValues = new HashMap<String, Map<String, Object>>();
    @JsonProperty(value="selected")
    private Set<String> selectedFields = new HashSet<String>();
    @JsonProperty(value="ignored")
    private Set<String> ignoredFields = new HashSet<String>();
    @JsonProperty(value="null_values")
    private Set<Object> nullValues = ImmutableSet.of((Object)"");
    @JsonProperty(value="update_strategies")
    private Map<String, UpdateStrategy> updateStrategies = new HashMap<String, UpdateStrategy>();

    public abstract ElemType type();

    @Override
    public void check() throws IllegalArgumentException {
        E.checkArgument((this.label != null && !this.label.isEmpty() ? 1 : 0) != 0, (String)"The label can't be null or empty", (Object[])new Object[0]);
        E.checkArgument((this.selectedFields.isEmpty() || this.ignoredFields.isEmpty() ? 1 : 0) != 0, (String)"Not allowed to specify selected(%s) and ignored(%s) fields at the same time, at least one of them must be empty", (Object[])new Object[]{this.selectedFields, this.ignoredFields});
        this.mappingFields.values().forEach(value -> E.checkArgument((value != null ? 1 : 0) != 0, (String)"The value in field_mapping can't be null", (Object[])new Object[0]));
        this.mappingValues.values().forEach(m -> m.values().forEach(value -> E.checkArgument((value != null ? 1 : 0) != 0, (String)"The value in value_mapping can't be null", (Object[])new Object[0])));
    }

    public void checkFieldsValid(InputSource source) {
        if (source.header() == null) {
            return;
        }
        List<String> header = Arrays.asList(source.header());
        if (!this.selectedFields.isEmpty()) {
            E.checkArgument((boolean)header.containsAll(this.selectedFields), (String)"The all keys %s of selected must be existed in header %s", (Object[])new Object[]{this.selectedFields, header});
        }
        if (!this.ignoredFields.isEmpty()) {
            E.checkArgument((boolean)header.containsAll(this.ignoredFields), (String)"The all keys %s of ignored must be existed in header %s", (Object[])new Object[]{this.ignoredFields, header});
        }
        if (!this.mappingFields.isEmpty()) {
            E.checkArgument((boolean)header.containsAll(this.mappingFields.keySet()), (String)"The all keys %s of field_mapping must be existed in header", (Object[])new Object[]{this.mappingFields.keySet(), header});
        }
        if (!this.mappingValues.isEmpty()) {
            E.checkArgument((boolean)header.containsAll(this.mappingValues.keySet()), (String)"The all keys %s of value_mapping must be existed in header", (Object[])new Object[]{this.mappingValues.keySet(), header});
        }
    }

    public String label() {
        return this.label;
    }

    public void label(String label) {
        this.label = label;
    }

    public boolean skip() {
        return this.skip;
    }

    public void skip(boolean skip) {
        this.skip = skip;
    }

    public Map<String, String> mappingFields() {
        return this.mappingFields;
    }

    public void mappingFields(Map<String, String> mappingFields) {
        this.mappingFields = mappingFields;
    }

    public String mappingField(String fieldName, boolean caseSensitive) {
        if (this.mappingFields.isEmpty()) {
            return fieldName;
        }
        if (caseSensitive) {
            String mappingName = this.mappingFields.get(fieldName);
            return mappingName != null ? mappingName : fieldName;
        }
        for (Map.Entry<String, String> entry : this.mappingFields.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(fieldName)) continue;
            return entry.getValue();
        }
        return fieldName;
    }

    public Map<String, Map<String, Object>> mappingValues() {
        return this.mappingValues;
    }

    public void mappingValues(Map<String, Map<String, Object>> mappingValues) {
        this.mappingValues = mappingValues;
    }

    public Object mappingValue(String fieldName, String rawValue, boolean caseSensitive) {
        Object mappingValue;
        block3: {
            block2: {
                Object value;
                if (this.mappingValues.isEmpty()) {
                    return rawValue;
                }
                mappingValue = rawValue;
                if (!caseSensitive) break block2;
                Map<String, Object> values = this.mappingValues.get(fieldName);
                if (values == null || (value = values.get(rawValue)) == null) break block3;
                mappingValue = value;
                break block3;
            }
            for (Map.Entry<String, Map<String, Object>> entry : this.mappingValues.entrySet()) {
                Object value;
                Map<String, Object> values;
                if (!entry.getKey().toLowerCase().equals(fieldName.toLowerCase()) || (values = entry.getValue()) == null || (value = values.get(rawValue)) == null) continue;
                mappingValue = value;
                break;
            }
        }
        return mappingValue;
    }

    public Set<String> selectedFields() {
        return this.selectedFields;
    }

    public void selectedFields(Set<String> selectedFields) {
        this.selectedFields = selectedFields;
    }

    public Set<String> ignoredFields() {
        return this.ignoredFields;
    }

    public void ignoredFields(Set<String> ignoredFields) {
        this.ignoredFields = ignoredFields;
    }

    public Set<Object> nullValues() {
        return this.nullValues;
    }

    public void nullValues(Set<Object> nullValues) {
        this.nullValues = nullValues;
    }

    public Map<String, UpdateStrategy> updateStrategies() {
        return this.updateStrategies;
    }

    public void updateStrategies(Map<String, UpdateStrategy> updateStrategies) {
        this.updateStrategies = updateStrategies;
    }
}

