/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hugegraph.loader.builder.ElementBuilder;
import org.apache.hugegraph.loader.constant.ElemType;
import org.apache.hugegraph.loader.executor.LoadContext;
import org.apache.hugegraph.loader.mapping.ElementMapping;
import org.apache.hugegraph.loader.mapping.InputStruct;
import org.apache.hugegraph.structure.graph.Vertex;
import org.apache.hugegraph.structure.schema.SchemaLabel;
import org.apache.hugegraph.structure.schema.VertexLabel;

public class NopVertexBuilder
extends ElementBuilder<Vertex> {
    public NopVertexBuilder(LoadContext context, InputStruct struct) {
        super(context, struct);
    }

    @Override
    public ElementMapping mapping() {
        ElementMapping mapping = new ElementMapping(){

            @Override
            public ElemType type() {
                return ElemType.VERTEX;
            }
        };
        mapping.label("graph-vertex");
        return mapping;
    }

    @Override
    public List<Vertex> build(String[] names, Object[] values) {
        ArrayList<Vertex> result = new ArrayList<Vertex>();
        for (Object value : values) {
            if (!(value instanceof Vertex)) continue;
            Vertex vertex = (Vertex)value;
            VertexLabel label = this.getVertexLabel(vertex.label());
            if (label.idStrategy().isPrimaryKey()) {
                vertex.id(null);
            }
            result.add(vertex);
        }
        return result;
    }

    @Override
    protected SchemaLabel schemaLabel() {
        return null;
    }

    @Override
    protected Collection<String> nonNullableKeys() {
        return null;
    }

    @Override
    protected boolean isIdField(String fieldName) {
        return false;
    }
}

