/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure.traverser;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.hugegraph.api.traverser.TraversersAPI;
import org.apache.hugegraph.structure.constant.Direction;
import org.apache.hugegraph.util.E;

public class SameNeighborsBatchRequest {
    @JsonProperty(value="vertex_list")
    private List<List<Object>> vertexList = new ArrayList<List<Object>>();
    @JsonProperty(value="direction")
    private String direction = null;
    @JsonProperty(value="label")
    private String label = null;
    @JsonProperty(value="max_degree")
    public long maxDegree = 10000L;
    @JsonProperty(value="limit")
    public long limit = 10000000L;

    private SameNeighborsBatchRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return String.format("SameNeighborsBatchRequest{vertex_list=%s,direction=%s,label=%s,max_degree=%d,limit=%d", this.vertexList, this.direction, this.label, this.maxDegree, this.limit);
    }

    public static class Builder {
        private final SameNeighborsBatchRequest request = new SameNeighborsBatchRequest();

        private Builder() {
        }

        public Builder vertex(Object vertexId, Object otherId) {
            ArrayList<Object> vertexPair = new ArrayList<Object>();
            vertexPair.add(vertexId);
            vertexPair.add(otherId);
            this.request.vertexList.add(vertexPair);
            return this;
        }

        public Builder direction(Direction direction) {
            this.request.direction = direction.toString();
            return this;
        }

        public Builder label(String label) {
            this.request.label = label;
            return this;
        }

        public Builder maxDegree(long maxDegree) {
            TraversersAPI.checkDegree(maxDegree);
            this.request.maxDegree = maxDegree;
            return this;
        }

        public Builder limit(long limit) {
            TraversersAPI.checkLimit(limit);
            this.request.limit = limit;
            return this;
        }

        public SameNeighborsBatchRequest build() {
            E.checkArgument((this.request.vertexList != null && !this.request.vertexList.isEmpty() ? 1 : 0) != 0, (String)"The vertex_list can't be null or empty", (Object[])new Object[0]);
            TraversersAPI.checkDegree(this.request.maxDegree);
            TraversersAPI.checkLimit(this.request.limit);
            return this.request;
        }
    }
}

