/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core;

import jakarta.annotation.Nonnull;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.config.PolarisConfigurationStore;
import org.apache.polaris.core.config.RealmConfig;
import org.apache.polaris.core.config.RealmConfigImpl;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.persistence.BasePersistence;

public class PolarisCallContext
implements CallContext {
    private final BasePersistence metaStore;
    private final PolarisDiagnostics diagServices;
    private final PolarisConfigurationStore configurationStore;
    private final RealmContext realmContext;
    private final RealmConfig realmConfig;

    public PolarisCallContext(@Nonnull RealmContext realmContext, @Nonnull BasePersistence metaStore, @Nonnull PolarisDiagnostics diagServices, @Nonnull PolarisConfigurationStore configurationStore) {
        this.realmContext = realmContext;
        this.metaStore = metaStore;
        this.diagServices = diagServices;
        this.configurationStore = configurationStore;
        this.realmConfig = new RealmConfigImpl(this.configurationStore, this.realmContext);
    }

    public PolarisCallContext(@Nonnull RealmContext realmContext, @Nonnull BasePersistence metaStore, @Nonnull PolarisDiagnostics diagServices) {
        this(realmContext, metaStore, diagServices, new PolarisConfigurationStore(){});
    }

    public BasePersistence getMetaStore() {
        return this.metaStore;
    }

    public PolarisDiagnostics getDiagServices() {
        return this.diagServices;
    }

    @Override
    public RealmContext getRealmContext() {
        return this.realmContext;
    }

    @Override
    public RealmConfig getRealmConfig() {
        return this.realmConfig;
    }

    @Override
    public PolarisCallContext getPolarisCallContext() {
        return this;
    }

    @Override
    public PolarisCallContext copy() {
        String realmId = this.realmContext.getRealmIdentifier();
        RealmContext realmContext = () -> realmId;
        return new PolarisCallContext(realmContext, this.metaStore, this.diagServices, this.configurationStore);
    }
}

