/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DatabaseInsightsMode;
import software.amazon.awssdk.services.rds.model.LogTypeListCopier;
import software.amazon.awssdk.services.rds.model.ProcessorFeature;
import software.amazon.awssdk.services.rds.model.ProcessorFeatureListCopier;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.ReplicaMode;
import software.amazon.awssdk.services.rds.model.StringListCopier;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDbInstanceReadReplicaRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, CreateDbInstanceReadReplicaRequest> {
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBInstanceIdentifier").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::dbInstanceIdentifier)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::dbInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build()}).build();
    private static final SdkField<String> SOURCE_DB_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceDBInstanceIdentifier").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::sourceDBInstanceIdentifier)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::sourceDBInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDBInstanceIdentifier").build()}).build();
    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBInstanceClass").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::dbInstanceClass)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::dbInstanceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::availabilityZone)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::port)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MultiAZ").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::multiAZ)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::multiAZ)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()}).build();
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoMinorVersionUpgrade").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::autoMinorVersionUpgrade)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build()}).build();
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Iops").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::iops)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()}).build();
    private static final SdkField<Integer> STORAGE_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StorageThroughput").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::storageThroughput)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::storageThroughput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageThroughput").build()}).build();
    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptionGroupName").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::optionGroupName)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::optionGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()}).build();
    private static final SdkField<String> DB_PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBParameterGroupName").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::dbParameterGroupName)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::dbParameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroupName").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PubliclyAccessible").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::publiclyAccessible)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::tags)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBSubnetGroupName").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::dbSubnetGroupName)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::dbSubnetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupName").build()}).build();
    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSecurityGroupIds").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::vpcSecurityGroupIds)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::vpcSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(), ListTrait.builder().memberLocationName("VpcSecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageType").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::storageType)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTagsToSnapshot").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::copyTagsToSnapshot)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::copyTagsToSnapshot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build()}).build();
    private static final SdkField<Integer> MONITORING_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MonitoringInterval").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::monitoringInterval)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::monitoringInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringInterval").build()}).build();
    private static final SdkField<String> MONITORING_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitoringRoleArn").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::monitoringRoleArn)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::monitoringRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringRoleArn").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::kmsKeyId)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> PRE_SIGNED_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreSignedUrl").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::preSignedUrl)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::preSignedUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreSignedUrl").build()}).build();
    private static final SdkField<Boolean> ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableIAMDatabaseAuthentication").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::enableIAMDatabaseAuthentication)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::enableIAMDatabaseAuthentication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIAMDatabaseAuthentication").build()}).build();
    private static final SdkField<String> DATABASE_INSIGHTS_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseInsightsMode").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::databaseInsightsModeAsString)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::databaseInsightsMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseInsightsMode").build()}).build();
    private static final SdkField<Boolean> ENABLE_PERFORMANCE_INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnablePerformanceInsights").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::enablePerformanceInsights)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::enablePerformanceInsights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePerformanceInsights").build()}).build();
    private static final SdkField<String> PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PerformanceInsightsKMSKeyId").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::performanceInsightsKMSKeyId)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::performanceInsightsKMSKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsKMSKeyId").build()}).build();
    private static final SdkField<Integer> PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PerformanceInsightsRetentionPeriod").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::performanceInsightsRetentionPeriod)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::performanceInsightsRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsRetentionPeriod").build()}).build();
    private static final SdkField<List<String>> ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnableCloudwatchLogsExports").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::enableCloudwatchLogsExports)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::enableCloudwatchLogsExports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCloudwatchLogsExports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ProcessorFeature>> PROCESSOR_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProcessorFeatures").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::processorFeatures)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::processorFeatures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorFeatures").build(), ListTrait.builder().memberLocationName("ProcessorFeature").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProcessorFeature::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorFeature").build()}).build()).build()}).build();
    private static final SdkField<Boolean> USE_DEFAULT_PROCESSOR_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseDefaultProcessorFeatures").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::useDefaultProcessorFeatures)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::useDefaultProcessorFeatures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseDefaultProcessorFeatures").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeletionProtection").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::deletionProtection)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::deletionProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::domain)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<String> DOMAIN_IAM_ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainIAMRoleName").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::domainIAMRoleName)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::domainIAMRoleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainIAMRoleName").build()}).build();
    private static final SdkField<String> DOMAIN_FQDN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainFqdn").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::domainFqdn)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::domainFqdn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainFqdn").build()}).build();
    private static final SdkField<String> DOMAIN_OU_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainOu").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::domainOu)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::domainOu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainOu").build()}).build();
    private static final SdkField<String> DOMAIN_AUTH_SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainAuthSecretArn").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::domainAuthSecretArn)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::domainAuthSecretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainAuthSecretArn").build()}).build();
    private static final SdkField<List<String>> DOMAIN_DNS_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DomainDnsIps").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::domainDnsIps)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::domainDnsIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainDnsIps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REPLICA_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicaMode").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::replicaModeAsString)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::replicaMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaMode").build()}).build();
    private static final SdkField<Boolean> ENABLE_CUSTOMER_OWNED_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableCustomerOwnedIp").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::enableCustomerOwnedIp)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::enableCustomerOwnedIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCustomerOwnedIp").build()}).build();
    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkType").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::networkType)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::networkType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()}).build();
    private static final SdkField<Integer> MAX_ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxAllocatedStorage").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::maxAllocatedStorage)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::maxAllocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAllocatedStorage").build()}).build();
    private static final SdkField<String> BACKUP_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupTarget").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::backupTarget)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::backupTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupTarget").build()}).build();
    private static final SdkField<String> CUSTOM_IAM_INSTANCE_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomIamInstanceProfile").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::customIamInstanceProfile)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::customIamInstanceProfile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomIamInstanceProfile").build()}).build();
    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocatedStorage").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::allocatedStorage)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::allocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()}).build();
    private static final SdkField<String> SOURCE_DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceDBClusterIdentifier").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::sourceDBClusterIdentifier)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::sourceDBClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDBClusterIdentifier").build()}).build();
    private static final SdkField<Boolean> DEDICATED_LOG_VOLUME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DedicatedLogVolume").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::dedicatedLogVolume)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::dedicatedLogVolume)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedLogVolume").build()}).build();
    private static final SdkField<Boolean> UPGRADE_STORAGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UpgradeStorageConfig").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::upgradeStorageConfig)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::upgradeStorageConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeStorageConfig").build()}).build();
    private static final SdkField<String> CA_CERTIFICATE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CACertificateIdentifier").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::caCertificateIdentifier)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::caCertificateIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CACertificateIdentifier").build()}).build();
    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceRegion").getter(CreateDbInstanceReadReplicaRequest.getter(CreateDbInstanceReadReplicaRequest::sourceRegion)).setter(CreateDbInstanceReadReplicaRequest.setter(Builder::sourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_IDENTIFIER_FIELD, SOURCE_DB_INSTANCE_IDENTIFIER_FIELD, DB_INSTANCE_CLASS_FIELD, AVAILABILITY_ZONE_FIELD, PORT_FIELD, MULTI_AZ_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, IOPS_FIELD, STORAGE_THROUGHPUT_FIELD, OPTION_GROUP_NAME_FIELD, DB_PARAMETER_GROUP_NAME_FIELD, PUBLICLY_ACCESSIBLE_FIELD, TAGS_FIELD, DB_SUBNET_GROUP_NAME_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, STORAGE_TYPE_FIELD, COPY_TAGS_TO_SNAPSHOT_FIELD, MONITORING_INTERVAL_FIELD, MONITORING_ROLE_ARN_FIELD, KMS_KEY_ID_FIELD, PRE_SIGNED_URL_FIELD, ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD, DATABASE_INSIGHTS_MODE_FIELD, ENABLE_PERFORMANCE_INSIGHTS_FIELD, PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD, PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD, ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD, PROCESSOR_FEATURES_FIELD, USE_DEFAULT_PROCESSOR_FEATURES_FIELD, DELETION_PROTECTION_FIELD, DOMAIN_FIELD, DOMAIN_IAM_ROLE_NAME_FIELD, DOMAIN_FQDN_FIELD, DOMAIN_OU_FIELD, DOMAIN_AUTH_SECRET_ARN_FIELD, DOMAIN_DNS_IPS_FIELD, REPLICA_MODE_FIELD, ENABLE_CUSTOMER_OWNED_IP_FIELD, NETWORK_TYPE_FIELD, MAX_ALLOCATED_STORAGE_FIELD, BACKUP_TARGET_FIELD, CUSTOM_IAM_INSTANCE_PROFILE_FIELD, ALLOCATED_STORAGE_FIELD, SOURCE_DB_CLUSTER_IDENTIFIER_FIELD, DEDICATED_LOG_VOLUME_FIELD, UPGRADE_STORAGE_CONFIG_FIELD, CA_CERTIFICATE_IDENTIFIER_FIELD, SOURCE_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDbInstanceReadReplicaRequest.memberNameToFieldInitializer();
    private final String dbInstanceIdentifier;
    private final String sourceDBInstanceIdentifier;
    private final String dbInstanceClass;
    private final String availabilityZone;
    private final Integer port;
    private final Boolean multiAZ;
    private final Boolean autoMinorVersionUpgrade;
    private final Integer iops;
    private final Integer storageThroughput;
    private final String optionGroupName;
    private final String dbParameterGroupName;
    private final Boolean publiclyAccessible;
    private final List<Tag> tags;
    private final String dbSubnetGroupName;
    private final List<String> vpcSecurityGroupIds;
    private final String storageType;
    private final Boolean copyTagsToSnapshot;
    private final Integer monitoringInterval;
    private final String monitoringRoleArn;
    private final String kmsKeyId;
    private final String preSignedUrl;
    private final Boolean enableIAMDatabaseAuthentication;
    private final String databaseInsightsMode;
    private final Boolean enablePerformanceInsights;
    private final String performanceInsightsKMSKeyId;
    private final Integer performanceInsightsRetentionPeriod;
    private final List<String> enableCloudwatchLogsExports;
    private final List<ProcessorFeature> processorFeatures;
    private final Boolean useDefaultProcessorFeatures;
    private final Boolean deletionProtection;
    private final String domain;
    private final String domainIAMRoleName;
    private final String domainFqdn;
    private final String domainOu;
    private final String domainAuthSecretArn;
    private final List<String> domainDnsIps;
    private final String replicaMode;
    private final Boolean enableCustomerOwnedIp;
    private final String networkType;
    private final Integer maxAllocatedStorage;
    private final String backupTarget;
    private final String customIamInstanceProfile;
    private final Integer allocatedStorage;
    private final String sourceDBClusterIdentifier;
    private final Boolean dedicatedLogVolume;
    private final Boolean upgradeStorageConfig;
    private final String caCertificateIdentifier;
    private final String sourceRegion;

    private CreateDbInstanceReadReplicaRequest(BuilderImpl builder) {
        super(builder);
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.sourceDBInstanceIdentifier = builder.sourceDBInstanceIdentifier;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.availabilityZone = builder.availabilityZone;
        this.port = builder.port;
        this.multiAZ = builder.multiAZ;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.iops = builder.iops;
        this.storageThroughput = builder.storageThroughput;
        this.optionGroupName = builder.optionGroupName;
        this.dbParameterGroupName = builder.dbParameterGroupName;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.tags = builder.tags;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.storageType = builder.storageType;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.monitoringInterval = builder.monitoringInterval;
        this.monitoringRoleArn = builder.monitoringRoleArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.preSignedUrl = builder.preSignedUrl;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
        this.databaseInsightsMode = builder.databaseInsightsMode;
        this.enablePerformanceInsights = builder.enablePerformanceInsights;
        this.performanceInsightsKMSKeyId = builder.performanceInsightsKMSKeyId;
        this.performanceInsightsRetentionPeriod = builder.performanceInsightsRetentionPeriod;
        this.enableCloudwatchLogsExports = builder.enableCloudwatchLogsExports;
        this.processorFeatures = builder.processorFeatures;
        this.useDefaultProcessorFeatures = builder.useDefaultProcessorFeatures;
        this.deletionProtection = builder.deletionProtection;
        this.domain = builder.domain;
        this.domainIAMRoleName = builder.domainIAMRoleName;
        this.domainFqdn = builder.domainFqdn;
        this.domainOu = builder.domainOu;
        this.domainAuthSecretArn = builder.domainAuthSecretArn;
        this.domainDnsIps = builder.domainDnsIps;
        this.replicaMode = builder.replicaMode;
        this.enableCustomerOwnedIp = builder.enableCustomerOwnedIp;
        this.networkType = builder.networkType;
        this.maxAllocatedStorage = builder.maxAllocatedStorage;
        this.backupTarget = builder.backupTarget;
        this.customIamInstanceProfile = builder.customIamInstanceProfile;
        this.allocatedStorage = builder.allocatedStorage;
        this.sourceDBClusterIdentifier = builder.sourceDBClusterIdentifier;
        this.dedicatedLogVolume = builder.dedicatedLogVolume;
        this.upgradeStorageConfig = builder.upgradeStorageConfig;
        this.caCertificateIdentifier = builder.caCertificateIdentifier;
        this.sourceRegion = builder.sourceRegion;
    }

    public final String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public final String sourceDBInstanceIdentifier() {
        return this.sourceDBInstanceIdentifier;
    }

    public final String dbInstanceClass() {
        return this.dbInstanceClass;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final Integer port() {
        return this.port;
    }

    public final Boolean multiAZ() {
        return this.multiAZ;
    }

    public final Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public final Integer iops() {
        return this.iops;
    }

    public final Integer storageThroughput() {
        return this.storageThroughput;
    }

    public final String optionGroupName() {
        return this.optionGroupName;
    }

    public final String dbParameterGroupName() {
        return this.dbParameterGroupName;
    }

    public final Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String dbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }

    public final boolean hasVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds != null && !(this.vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public final String storageType() {
        return this.storageType;
    }

    public final Boolean copyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public final Integer monitoringInterval() {
        return this.monitoringInterval;
    }

    public final String monitoringRoleArn() {
        return this.monitoringRoleArn;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String preSignedUrl() {
        return this.preSignedUrl;
    }

    public final Boolean enableIAMDatabaseAuthentication() {
        return this.enableIAMDatabaseAuthentication;
    }

    public final DatabaseInsightsMode databaseInsightsMode() {
        return DatabaseInsightsMode.fromValue(this.databaseInsightsMode);
    }

    public final String databaseInsightsModeAsString() {
        return this.databaseInsightsMode;
    }

    public final Boolean enablePerformanceInsights() {
        return this.enablePerformanceInsights;
    }

    public final String performanceInsightsKMSKeyId() {
        return this.performanceInsightsKMSKeyId;
    }

    public final Integer performanceInsightsRetentionPeriod() {
        return this.performanceInsightsRetentionPeriod;
    }

    public final boolean hasEnableCloudwatchLogsExports() {
        return this.enableCloudwatchLogsExports != null && !(this.enableCloudwatchLogsExports instanceof SdkAutoConstructList);
    }

    public final List<String> enableCloudwatchLogsExports() {
        return this.enableCloudwatchLogsExports;
    }

    public final boolean hasProcessorFeatures() {
        return this.processorFeatures != null && !(this.processorFeatures instanceof SdkAutoConstructList);
    }

    public final List<ProcessorFeature> processorFeatures() {
        return this.processorFeatures;
    }

    public final Boolean useDefaultProcessorFeatures() {
        return this.useDefaultProcessorFeatures;
    }

    public final Boolean deletionProtection() {
        return this.deletionProtection;
    }

    public final String domain() {
        return this.domain;
    }

    public final String domainIAMRoleName() {
        return this.domainIAMRoleName;
    }

    public final String domainFqdn() {
        return this.domainFqdn;
    }

    public final String domainOu() {
        return this.domainOu;
    }

    public final String domainAuthSecretArn() {
        return this.domainAuthSecretArn;
    }

    public final boolean hasDomainDnsIps() {
        return this.domainDnsIps != null && !(this.domainDnsIps instanceof SdkAutoConstructList);
    }

    public final List<String> domainDnsIps() {
        return this.domainDnsIps;
    }

    public final ReplicaMode replicaMode() {
        return ReplicaMode.fromValue(this.replicaMode);
    }

    public final String replicaModeAsString() {
        return this.replicaMode;
    }

    public final Boolean enableCustomerOwnedIp() {
        return this.enableCustomerOwnedIp;
    }

    public final String networkType() {
        return this.networkType;
    }

    public final Integer maxAllocatedStorage() {
        return this.maxAllocatedStorage;
    }

    public final String backupTarget() {
        return this.backupTarget;
    }

    public final String customIamInstanceProfile() {
        return this.customIamInstanceProfile;
    }

    public final Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public final String sourceDBClusterIdentifier() {
        return this.sourceDBClusterIdentifier;
    }

    public final Boolean dedicatedLogVolume() {
        return this.dedicatedLogVolume;
    }

    public final Boolean upgradeStorageConfig() {
        return this.upgradeStorageConfig;
    }

    public final String caCertificateIdentifier() {
        return this.caCertificateIdentifier;
    }

    public final String sourceRegion() {
        return this.sourceRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDBInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.preSignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseInsightsModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePerformanceInsights());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceInsightsKMSKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceInsightsRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnableCloudwatchLogsExports() ? this.enableCloudwatchLogsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProcessorFeatures() ? this.processorFeatures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.useDefaultProcessorFeatures());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIAMRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainFqdn());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainOu());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainAuthSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainDnsIps() ? this.domainDnsIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableCustomerOwnedIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkType());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAllocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.customIamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDBClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dedicatedLogVolume());
        hashCode = 31 * hashCode + Objects.hashCode(this.upgradeStorageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.caCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDbInstanceReadReplicaRequest)) {
            return false;
        }
        CreateDbInstanceReadReplicaRequest other = (CreateDbInstanceReadReplicaRequest)((Object)obj);
        return Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier()) && Objects.equals(this.sourceDBInstanceIdentifier(), other.sourceDBInstanceIdentifier()) && Objects.equals(this.dbInstanceClass(), other.dbInstanceClass()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.multiAZ(), other.multiAZ()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.storageThroughput(), other.storageThroughput()) && Objects.equals(this.optionGroupName(), other.optionGroupName()) && Objects.equals(this.dbParameterGroupName(), other.dbParameterGroupName()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.dbSubnetGroupName(), other.dbSubnetGroupName()) && this.hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds() && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && Objects.equals(this.storageType(), other.storageType()) && Objects.equals(this.copyTagsToSnapshot(), other.copyTagsToSnapshot()) && Objects.equals(this.monitoringInterval(), other.monitoringInterval()) && Objects.equals(this.monitoringRoleArn(), other.monitoringRoleArn()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.preSignedUrl(), other.preSignedUrl()) && Objects.equals(this.enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication()) && Objects.equals(this.databaseInsightsModeAsString(), other.databaseInsightsModeAsString()) && Objects.equals(this.enablePerformanceInsights(), other.enablePerformanceInsights()) && Objects.equals(this.performanceInsightsKMSKeyId(), other.performanceInsightsKMSKeyId()) && Objects.equals(this.performanceInsightsRetentionPeriod(), other.performanceInsightsRetentionPeriod()) && this.hasEnableCloudwatchLogsExports() == other.hasEnableCloudwatchLogsExports() && Objects.equals(this.enableCloudwatchLogsExports(), other.enableCloudwatchLogsExports()) && this.hasProcessorFeatures() == other.hasProcessorFeatures() && Objects.equals(this.processorFeatures(), other.processorFeatures()) && Objects.equals(this.useDefaultProcessorFeatures(), other.useDefaultProcessorFeatures()) && Objects.equals(this.deletionProtection(), other.deletionProtection()) && Objects.equals(this.domain(), other.domain()) && Objects.equals(this.domainIAMRoleName(), other.domainIAMRoleName()) && Objects.equals(this.domainFqdn(), other.domainFqdn()) && Objects.equals(this.domainOu(), other.domainOu()) && Objects.equals(this.domainAuthSecretArn(), other.domainAuthSecretArn()) && this.hasDomainDnsIps() == other.hasDomainDnsIps() && Objects.equals(this.domainDnsIps(), other.domainDnsIps()) && Objects.equals(this.replicaModeAsString(), other.replicaModeAsString()) && Objects.equals(this.enableCustomerOwnedIp(), other.enableCustomerOwnedIp()) && Objects.equals(this.networkType(), other.networkType()) && Objects.equals(this.maxAllocatedStorage(), other.maxAllocatedStorage()) && Objects.equals(this.backupTarget(), other.backupTarget()) && Objects.equals(this.customIamInstanceProfile(), other.customIamInstanceProfile()) && Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && Objects.equals(this.sourceDBClusterIdentifier(), other.sourceDBClusterIdentifier()) && Objects.equals(this.dedicatedLogVolume(), other.dedicatedLogVolume()) && Objects.equals(this.upgradeStorageConfig(), other.upgradeStorageConfig()) && Objects.equals(this.caCertificateIdentifier(), other.caCertificateIdentifier()) && Objects.equals(this.sourceRegion(), other.sourceRegion());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDbInstanceReadReplicaRequest").add("DBInstanceIdentifier", (Object)this.dbInstanceIdentifier()).add("SourceDBInstanceIdentifier", (Object)this.sourceDBInstanceIdentifier()).add("DBInstanceClass", (Object)this.dbInstanceClass()).add("AvailabilityZone", (Object)this.availabilityZone()).add("Port", (Object)this.port()).add("MultiAZ", (Object)this.multiAZ()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("Iops", (Object)this.iops()).add("StorageThroughput", (Object)this.storageThroughput()).add("OptionGroupName", (Object)this.optionGroupName()).add("DBParameterGroupName", (Object)this.dbParameterGroupName()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("Tags", this.hasTags() ? this.tags() : null).add("DBSubnetGroupName", (Object)this.dbSubnetGroupName()).add("VpcSecurityGroupIds", this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null).add("StorageType", (Object)this.storageType()).add("CopyTagsToSnapshot", (Object)this.copyTagsToSnapshot()).add("MonitoringInterval", (Object)this.monitoringInterval()).add("MonitoringRoleArn", (Object)this.monitoringRoleArn()).add("KmsKeyId", (Object)this.kmsKeyId()).add("PreSignedUrl", (Object)(this.preSignedUrl() == null ? null : "*** Sensitive Data Redacted ***")).add("EnableIAMDatabaseAuthentication", (Object)this.enableIAMDatabaseAuthentication()).add("DatabaseInsightsMode", (Object)this.databaseInsightsModeAsString()).add("EnablePerformanceInsights", (Object)this.enablePerformanceInsights()).add("PerformanceInsightsKMSKeyId", (Object)this.performanceInsightsKMSKeyId()).add("PerformanceInsightsRetentionPeriod", (Object)this.performanceInsightsRetentionPeriod()).add("EnableCloudwatchLogsExports", this.hasEnableCloudwatchLogsExports() ? this.enableCloudwatchLogsExports() : null).add("ProcessorFeatures", this.hasProcessorFeatures() ? this.processorFeatures() : null).add("UseDefaultProcessorFeatures", (Object)this.useDefaultProcessorFeatures()).add("DeletionProtection", (Object)this.deletionProtection()).add("Domain", (Object)this.domain()).add("DomainIAMRoleName", (Object)this.domainIAMRoleName()).add("DomainFqdn", (Object)this.domainFqdn()).add("DomainOu", (Object)this.domainOu()).add("DomainAuthSecretArn", (Object)this.domainAuthSecretArn()).add("DomainDnsIps", this.hasDomainDnsIps() ? this.domainDnsIps() : null).add("ReplicaMode", (Object)this.replicaModeAsString()).add("EnableCustomerOwnedIp", (Object)this.enableCustomerOwnedIp()).add("NetworkType", (Object)this.networkType()).add("MaxAllocatedStorage", (Object)this.maxAllocatedStorage()).add("BackupTarget", (Object)this.backupTarget()).add("CustomIamInstanceProfile", (Object)this.customIamInstanceProfile()).add("AllocatedStorage", (Object)this.allocatedStorage()).add("SourceDBClusterIdentifier", (Object)this.sourceDBClusterIdentifier()).add("DedicatedLogVolume", (Object)this.dedicatedLogVolume()).add("UpgradeStorageConfig", (Object)this.upgradeStorageConfig()).add("CACertificateIdentifier", (Object)this.caCertificateIdentifier()).add("SourceRegion", (Object)this.sourceRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "SourceDBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.sourceDBInstanceIdentifier()));
            }
            case "DBInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceClass()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "MultiAZ": {
                return Optional.ofNullable(clazz.cast(this.multiAZ()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "StorageThroughput": {
                return Optional.ofNullable(clazz.cast(this.storageThroughput()));
            }
            case "OptionGroupName": {
                return Optional.ofNullable(clazz.cast(this.optionGroupName()));
            }
            case "DBParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbParameterGroupName()));
            }
            case "PubliclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "DBSubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbSubnetGroupName()));
            }
            case "VpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
            case "CopyTagsToSnapshot": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToSnapshot()));
            }
            case "MonitoringInterval": {
                return Optional.ofNullable(clazz.cast(this.monitoringInterval()));
            }
            case "MonitoringRoleArn": {
                return Optional.ofNullable(clazz.cast(this.monitoringRoleArn()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "PreSignedUrl": {
                return Optional.ofNullable(clazz.cast(this.preSignedUrl()));
            }
            case "EnableIAMDatabaseAuthentication": {
                return Optional.ofNullable(clazz.cast(this.enableIAMDatabaseAuthentication()));
            }
            case "DatabaseInsightsMode": {
                return Optional.ofNullable(clazz.cast(this.databaseInsightsModeAsString()));
            }
            case "EnablePerformanceInsights": {
                return Optional.ofNullable(clazz.cast(this.enablePerformanceInsights()));
            }
            case "PerformanceInsightsKMSKeyId": {
                return Optional.ofNullable(clazz.cast(this.performanceInsightsKMSKeyId()));
            }
            case "PerformanceInsightsRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.performanceInsightsRetentionPeriod()));
            }
            case "EnableCloudwatchLogsExports": {
                return Optional.ofNullable(clazz.cast(this.enableCloudwatchLogsExports()));
            }
            case "ProcessorFeatures": {
                return Optional.ofNullable(clazz.cast(this.processorFeatures()));
            }
            case "UseDefaultProcessorFeatures": {
                return Optional.ofNullable(clazz.cast(this.useDefaultProcessorFeatures()));
            }
            case "DeletionProtection": {
                return Optional.ofNullable(clazz.cast(this.deletionProtection()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "DomainIAMRoleName": {
                return Optional.ofNullable(clazz.cast(this.domainIAMRoleName()));
            }
            case "DomainFqdn": {
                return Optional.ofNullable(clazz.cast(this.domainFqdn()));
            }
            case "DomainOu": {
                return Optional.ofNullable(clazz.cast(this.domainOu()));
            }
            case "DomainAuthSecretArn": {
                return Optional.ofNullable(clazz.cast(this.domainAuthSecretArn()));
            }
            case "DomainDnsIps": {
                return Optional.ofNullable(clazz.cast(this.domainDnsIps()));
            }
            case "ReplicaMode": {
                return Optional.ofNullable(clazz.cast(this.replicaModeAsString()));
            }
            case "EnableCustomerOwnedIp": {
                return Optional.ofNullable(clazz.cast(this.enableCustomerOwnedIp()));
            }
            case "NetworkType": {
                return Optional.ofNullable(clazz.cast(this.networkType()));
            }
            case "MaxAllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.maxAllocatedStorage()));
            }
            case "BackupTarget": {
                return Optional.ofNullable(clazz.cast(this.backupTarget()));
            }
            case "CustomIamInstanceProfile": {
                return Optional.ofNullable(clazz.cast(this.customIamInstanceProfile()));
            }
            case "AllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
            case "SourceDBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.sourceDBClusterIdentifier()));
            }
            case "DedicatedLogVolume": {
                return Optional.ofNullable(clazz.cast(this.dedicatedLogVolume()));
            }
            case "UpgradeStorageConfig": {
                return Optional.ofNullable(clazz.cast(this.upgradeStorageConfig()));
            }
            case "CACertificateIdentifier": {
                return Optional.ofNullable(clazz.cast(this.caCertificateIdentifier()));
            }
            case "SourceRegion": {
                return Optional.ofNullable(clazz.cast(this.sourceRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DBInstanceIdentifier", DB_INSTANCE_IDENTIFIER_FIELD);
        map.put("SourceDBInstanceIdentifier", SOURCE_DB_INSTANCE_IDENTIFIER_FIELD);
        map.put("DBInstanceClass", DB_INSTANCE_CLASS_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("MultiAZ", MULTI_AZ_FIELD);
        map.put("AutoMinorVersionUpgrade", AUTO_MINOR_VERSION_UPGRADE_FIELD);
        map.put("Iops", IOPS_FIELD);
        map.put("StorageThroughput", STORAGE_THROUGHPUT_FIELD);
        map.put("OptionGroupName", OPTION_GROUP_NAME_FIELD);
        map.put("DBParameterGroupName", DB_PARAMETER_GROUP_NAME_FIELD);
        map.put("PubliclyAccessible", PUBLICLY_ACCESSIBLE_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("DBSubnetGroupName", DB_SUBNET_GROUP_NAME_FIELD);
        map.put("VpcSecurityGroupIds", VPC_SECURITY_GROUP_IDS_FIELD);
        map.put("StorageType", STORAGE_TYPE_FIELD);
        map.put("CopyTagsToSnapshot", COPY_TAGS_TO_SNAPSHOT_FIELD);
        map.put("MonitoringInterval", MONITORING_INTERVAL_FIELD);
        map.put("MonitoringRoleArn", MONITORING_ROLE_ARN_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("PreSignedUrl", PRE_SIGNED_URL_FIELD);
        map.put("EnableIAMDatabaseAuthentication", ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD);
        map.put("DatabaseInsightsMode", DATABASE_INSIGHTS_MODE_FIELD);
        map.put("EnablePerformanceInsights", ENABLE_PERFORMANCE_INSIGHTS_FIELD);
        map.put("PerformanceInsightsKMSKeyId", PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD);
        map.put("PerformanceInsightsRetentionPeriod", PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD);
        map.put("EnableCloudwatchLogsExports", ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD);
        map.put("ProcessorFeatures", PROCESSOR_FEATURES_FIELD);
        map.put("UseDefaultProcessorFeatures", USE_DEFAULT_PROCESSOR_FEATURES_FIELD);
        map.put("DeletionProtection", DELETION_PROTECTION_FIELD);
        map.put("Domain", DOMAIN_FIELD);
        map.put("DomainIAMRoleName", DOMAIN_IAM_ROLE_NAME_FIELD);
        map.put("DomainFqdn", DOMAIN_FQDN_FIELD);
        map.put("DomainOu", DOMAIN_OU_FIELD);
        map.put("DomainAuthSecretArn", DOMAIN_AUTH_SECRET_ARN_FIELD);
        map.put("DomainDnsIps", DOMAIN_DNS_IPS_FIELD);
        map.put("ReplicaMode", REPLICA_MODE_FIELD);
        map.put("EnableCustomerOwnedIp", ENABLE_CUSTOMER_OWNED_IP_FIELD);
        map.put("NetworkType", NETWORK_TYPE_FIELD);
        map.put("MaxAllocatedStorage", MAX_ALLOCATED_STORAGE_FIELD);
        map.put("BackupTarget", BACKUP_TARGET_FIELD);
        map.put("CustomIamInstanceProfile", CUSTOM_IAM_INSTANCE_PROFILE_FIELD);
        map.put("AllocatedStorage", ALLOCATED_STORAGE_FIELD);
        map.put("SourceDBClusterIdentifier", SOURCE_DB_CLUSTER_IDENTIFIER_FIELD);
        map.put("DedicatedLogVolume", DEDICATED_LOG_VOLUME_FIELD);
        map.put("UpgradeStorageConfig", UPGRADE_STORAGE_CONFIG_FIELD);
        map.put("CACertificateIdentifier", CA_CERTIFICATE_IDENTIFIER_FIELD);
        map.put("SourceRegion", SOURCE_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDbInstanceReadReplicaRequest, T> g) {
        return obj -> g.apply((CreateDbInstanceReadReplicaRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbInstanceIdentifier;
        private String sourceDBInstanceIdentifier;
        private String dbInstanceClass;
        private String availabilityZone;
        private Integer port;
        private Boolean multiAZ;
        private Boolean autoMinorVersionUpgrade;
        private Integer iops;
        private Integer storageThroughput;
        private String optionGroupName;
        private String dbParameterGroupName;
        private Boolean publiclyAccessible;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String dbSubnetGroupName;
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String storageType;
        private Boolean copyTagsToSnapshot;
        private Integer monitoringInterval;
        private String monitoringRoleArn;
        private String kmsKeyId;
        private String preSignedUrl;
        private Boolean enableIAMDatabaseAuthentication;
        private String databaseInsightsMode;
        private Boolean enablePerformanceInsights;
        private String performanceInsightsKMSKeyId;
        private Integer performanceInsightsRetentionPeriod;
        private List<String> enableCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();
        private List<ProcessorFeature> processorFeatures = DefaultSdkAutoConstructList.getInstance();
        private Boolean useDefaultProcessorFeatures;
        private Boolean deletionProtection;
        private String domain;
        private String domainIAMRoleName;
        private String domainFqdn;
        private String domainOu;
        private String domainAuthSecretArn;
        private List<String> domainDnsIps = DefaultSdkAutoConstructList.getInstance();
        private String replicaMode;
        private Boolean enableCustomerOwnedIp;
        private String networkType;
        private Integer maxAllocatedStorage;
        private String backupTarget;
        private String customIamInstanceProfile;
        private Integer allocatedStorage;
        private String sourceDBClusterIdentifier;
        private Boolean dedicatedLogVolume;
        private Boolean upgradeStorageConfig;
        private String caCertificateIdentifier;
        private String sourceRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDbInstanceReadReplicaRequest model) {
            super(model);
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.sourceDBInstanceIdentifier(model.sourceDBInstanceIdentifier);
            this.dbInstanceClass(model.dbInstanceClass);
            this.availabilityZone(model.availabilityZone);
            this.port(model.port);
            this.multiAZ(model.multiAZ);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.iops(model.iops);
            this.storageThroughput(model.storageThroughput);
            this.optionGroupName(model.optionGroupName);
            this.dbParameterGroupName(model.dbParameterGroupName);
            this.publiclyAccessible(model.publiclyAccessible);
            this.tags(model.tags);
            this.dbSubnetGroupName(model.dbSubnetGroupName);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.storageType(model.storageType);
            this.copyTagsToSnapshot(model.copyTagsToSnapshot);
            this.monitoringInterval(model.monitoringInterval);
            this.monitoringRoleArn(model.monitoringRoleArn);
            this.kmsKeyId(model.kmsKeyId);
            this.preSignedUrl(model.preSignedUrl);
            this.enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
            this.databaseInsightsMode(model.databaseInsightsMode);
            this.enablePerformanceInsights(model.enablePerformanceInsights);
            this.performanceInsightsKMSKeyId(model.performanceInsightsKMSKeyId);
            this.performanceInsightsRetentionPeriod(model.performanceInsightsRetentionPeriod);
            this.enableCloudwatchLogsExports(model.enableCloudwatchLogsExports);
            this.processorFeatures(model.processorFeatures);
            this.useDefaultProcessorFeatures(model.useDefaultProcessorFeatures);
            this.deletionProtection(model.deletionProtection);
            this.domain(model.domain);
            this.domainIAMRoleName(model.domainIAMRoleName);
            this.domainFqdn(model.domainFqdn);
            this.domainOu(model.domainOu);
            this.domainAuthSecretArn(model.domainAuthSecretArn);
            this.domainDnsIps(model.domainDnsIps);
            this.replicaMode(model.replicaMode);
            this.enableCustomerOwnedIp(model.enableCustomerOwnedIp);
            this.networkType(model.networkType);
            this.maxAllocatedStorage(model.maxAllocatedStorage);
            this.backupTarget(model.backupTarget);
            this.customIamInstanceProfile(model.customIamInstanceProfile);
            this.allocatedStorage(model.allocatedStorage);
            this.sourceDBClusterIdentifier(model.sourceDBClusterIdentifier);
            this.dedicatedLogVolume(model.dedicatedLogVolume);
            this.upgradeStorageConfig(model.upgradeStorageConfig);
            this.caCertificateIdentifier(model.caCertificateIdentifier);
            this.sourceRegion(model.sourceRegion);
        }

        public final String getDbInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final String getSourceDBInstanceIdentifier() {
            return this.sourceDBInstanceIdentifier;
        }

        public final void setSourceDBInstanceIdentifier(String sourceDBInstanceIdentifier) {
            this.sourceDBInstanceIdentifier = sourceDBInstanceIdentifier;
        }

        @Override
        public final Builder sourceDBInstanceIdentifier(String sourceDBInstanceIdentifier) {
            this.sourceDBInstanceIdentifier = sourceDBInstanceIdentifier;
            return this;
        }

        public final String getDbInstanceClass() {
            return this.dbInstanceClass;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final Boolean getMultiAZ() {
            return this.multiAZ;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final Integer getIops() {
            return this.iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final Integer getStorageThroughput() {
            return this.storageThroughput;
        }

        public final void setStorageThroughput(Integer storageThroughput) {
            this.storageThroughput = storageThroughput;
        }

        @Override
        public final Builder storageThroughput(Integer storageThroughput) {
            this.storageThroughput = storageThroughput;
            return this;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final String getDbParameterGroupName() {
            return this.dbParameterGroupName;
        }

        public final void setDbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
        }

        @Override
        public final Builder dbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDbSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        public final void setDbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (this.vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return this.copyTagsToSnapshot;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final Integer getMonitoringInterval() {
            return this.monitoringInterval;
        }

        public final void setMonitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
        }

        @Override
        public final Builder monitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        public final String getMonitoringRoleArn() {
            return this.monitoringRoleArn;
        }

        public final void setMonitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
        }

        @Override
        public final Builder monitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getPreSignedUrl() {
            return this.preSignedUrl;
        }

        public final void setPreSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
        }

        @Override
        public final Builder preSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
            return this;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return this.enableIAMDatabaseAuthentication;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final String getDatabaseInsightsMode() {
            return this.databaseInsightsMode;
        }

        public final void setDatabaseInsightsMode(String databaseInsightsMode) {
            this.databaseInsightsMode = databaseInsightsMode;
        }

        @Override
        public final Builder databaseInsightsMode(String databaseInsightsMode) {
            this.databaseInsightsMode = databaseInsightsMode;
            return this;
        }

        @Override
        public final Builder databaseInsightsMode(DatabaseInsightsMode databaseInsightsMode) {
            this.databaseInsightsMode(databaseInsightsMode == null ? null : databaseInsightsMode.toString());
            return this;
        }

        public final Boolean getEnablePerformanceInsights() {
            return this.enablePerformanceInsights;
        }

        public final void setEnablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
        }

        @Override
        public final Builder enablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        public final String getPerformanceInsightsKMSKeyId() {
            return this.performanceInsightsKMSKeyId;
        }

        public final void setPerformanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
        }

        @Override
        public final Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
            return this;
        }

        public final Integer getPerformanceInsightsRetentionPeriod() {
            return this.performanceInsightsRetentionPeriod;
        }

        public final void setPerformanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
        }

        @Override
        public final Builder performanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
            return this;
        }

        public final Collection<String> getEnableCloudwatchLogsExports() {
            if (this.enableCloudwatchLogsExports instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enableCloudwatchLogsExports;
        }

        public final void setEnableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
        }

        @Override
        public final Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enableCloudwatchLogsExports(String ... enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports(Arrays.asList(enableCloudwatchLogsExports));
            return this;
        }

        public final List<ProcessorFeature.Builder> getProcessorFeatures() {
            List<ProcessorFeature.Builder> result = ProcessorFeatureListCopier.copyToBuilder(this.processorFeatures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProcessorFeatures(Collection<ProcessorFeature.BuilderImpl> processorFeatures) {
            this.processorFeatures = ProcessorFeatureListCopier.copyFromBuilder(processorFeatures);
        }

        @Override
        public final Builder processorFeatures(Collection<ProcessorFeature> processorFeatures) {
            this.processorFeatures = ProcessorFeatureListCopier.copy(processorFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processorFeatures(ProcessorFeature ... processorFeatures) {
            this.processorFeatures(Arrays.asList(processorFeatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processorFeatures(Consumer<ProcessorFeature.Builder> ... processorFeatures) {
            this.processorFeatures(Stream.of(processorFeatures).map(c -> (ProcessorFeature)((ProcessorFeature.Builder)ProcessorFeature.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getUseDefaultProcessorFeatures() {
            return this.useDefaultProcessorFeatures;
        }

        public final void setUseDefaultProcessorFeatures(Boolean useDefaultProcessorFeatures) {
            this.useDefaultProcessorFeatures = useDefaultProcessorFeatures;
        }

        @Override
        public final Builder useDefaultProcessorFeatures(Boolean useDefaultProcessorFeatures) {
            this.useDefaultProcessorFeatures = useDefaultProcessorFeatures;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getDomainIAMRoleName() {
            return this.domainIAMRoleName;
        }

        public final void setDomainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
        }

        @Override
        public final Builder domainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
            return this;
        }

        public final String getDomainFqdn() {
            return this.domainFqdn;
        }

        public final void setDomainFqdn(String domainFqdn) {
            this.domainFqdn = domainFqdn;
        }

        @Override
        public final Builder domainFqdn(String domainFqdn) {
            this.domainFqdn = domainFqdn;
            return this;
        }

        public final String getDomainOu() {
            return this.domainOu;
        }

        public final void setDomainOu(String domainOu) {
            this.domainOu = domainOu;
        }

        @Override
        public final Builder domainOu(String domainOu) {
            this.domainOu = domainOu;
            return this;
        }

        public final String getDomainAuthSecretArn() {
            return this.domainAuthSecretArn;
        }

        public final void setDomainAuthSecretArn(String domainAuthSecretArn) {
            this.domainAuthSecretArn = domainAuthSecretArn;
        }

        @Override
        public final Builder domainAuthSecretArn(String domainAuthSecretArn) {
            this.domainAuthSecretArn = domainAuthSecretArn;
            return this;
        }

        public final Collection<String> getDomainDnsIps() {
            if (this.domainDnsIps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.domainDnsIps;
        }

        public final void setDomainDnsIps(Collection<String> domainDnsIps) {
            this.domainDnsIps = StringListCopier.copy(domainDnsIps);
        }

        @Override
        public final Builder domainDnsIps(Collection<String> domainDnsIps) {
            this.domainDnsIps = StringListCopier.copy(domainDnsIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainDnsIps(String ... domainDnsIps) {
            this.domainDnsIps(Arrays.asList(domainDnsIps));
            return this;
        }

        public final String getReplicaMode() {
            return this.replicaMode;
        }

        public final void setReplicaMode(String replicaMode) {
            this.replicaMode = replicaMode;
        }

        @Override
        public final Builder replicaMode(String replicaMode) {
            this.replicaMode = replicaMode;
            return this;
        }

        @Override
        public final Builder replicaMode(ReplicaMode replicaMode) {
            this.replicaMode(replicaMode == null ? null : replicaMode.toString());
            return this;
        }

        public final Boolean getEnableCustomerOwnedIp() {
            return this.enableCustomerOwnedIp;
        }

        public final void setEnableCustomerOwnedIp(Boolean enableCustomerOwnedIp) {
            this.enableCustomerOwnedIp = enableCustomerOwnedIp;
        }

        @Override
        public final Builder enableCustomerOwnedIp(Boolean enableCustomerOwnedIp) {
            this.enableCustomerOwnedIp = enableCustomerOwnedIp;
            return this;
        }

        public final String getNetworkType() {
            return this.networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        public final Integer getMaxAllocatedStorage() {
            return this.maxAllocatedStorage;
        }

        public final void setMaxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
        }

        @Override
        public final Builder maxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
            return this;
        }

        public final String getBackupTarget() {
            return this.backupTarget;
        }

        public final void setBackupTarget(String backupTarget) {
            this.backupTarget = backupTarget;
        }

        @Override
        public final Builder backupTarget(String backupTarget) {
            this.backupTarget = backupTarget;
            return this;
        }

        public final String getCustomIamInstanceProfile() {
            return this.customIamInstanceProfile;
        }

        public final void setCustomIamInstanceProfile(String customIamInstanceProfile) {
            this.customIamInstanceProfile = customIamInstanceProfile;
        }

        @Override
        public final Builder customIamInstanceProfile(String customIamInstanceProfile) {
            this.customIamInstanceProfile = customIamInstanceProfile;
            return this;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final String getSourceDBClusterIdentifier() {
            return this.sourceDBClusterIdentifier;
        }

        public final void setSourceDBClusterIdentifier(String sourceDBClusterIdentifier) {
            this.sourceDBClusterIdentifier = sourceDBClusterIdentifier;
        }

        @Override
        public final Builder sourceDBClusterIdentifier(String sourceDBClusterIdentifier) {
            this.sourceDBClusterIdentifier = sourceDBClusterIdentifier;
            return this;
        }

        public final Boolean getDedicatedLogVolume() {
            return this.dedicatedLogVolume;
        }

        public final void setDedicatedLogVolume(Boolean dedicatedLogVolume) {
            this.dedicatedLogVolume = dedicatedLogVolume;
        }

        @Override
        public final Builder dedicatedLogVolume(Boolean dedicatedLogVolume) {
            this.dedicatedLogVolume = dedicatedLogVolume;
            return this;
        }

        public final Boolean getUpgradeStorageConfig() {
            return this.upgradeStorageConfig;
        }

        public final void setUpgradeStorageConfig(Boolean upgradeStorageConfig) {
            this.upgradeStorageConfig = upgradeStorageConfig;
        }

        @Override
        public final Builder upgradeStorageConfig(Boolean upgradeStorageConfig) {
            this.upgradeStorageConfig = upgradeStorageConfig;
            return this;
        }

        public final String getCaCertificateIdentifier() {
            return this.caCertificateIdentifier;
        }

        public final void setCaCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
        }

        @Override
        public final Builder caCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDbInstanceReadReplicaRequest build() {
            return new CreateDbInstanceReadReplicaRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDbInstanceReadReplicaRequest> {
        public Builder dbInstanceIdentifier(String var1);

        public Builder sourceDBInstanceIdentifier(String var1);

        public Builder dbInstanceClass(String var1);

        public Builder availabilityZone(String var1);

        public Builder port(Integer var1);

        public Builder multiAZ(Boolean var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder iops(Integer var1);

        public Builder storageThroughput(Integer var1);

        public Builder optionGroupName(String var1);

        public Builder dbParameterGroupName(String var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder dbSubnetGroupName(String var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder storageType(String var1);

        public Builder copyTagsToSnapshot(Boolean var1);

        public Builder monitoringInterval(Integer var1);

        public Builder monitoringRoleArn(String var1);

        public Builder kmsKeyId(String var1);

        public Builder preSignedUrl(String var1);

        public Builder enableIAMDatabaseAuthentication(Boolean var1);

        public Builder databaseInsightsMode(String var1);

        public Builder databaseInsightsMode(DatabaseInsightsMode var1);

        public Builder enablePerformanceInsights(Boolean var1);

        public Builder performanceInsightsKMSKeyId(String var1);

        public Builder performanceInsightsRetentionPeriod(Integer var1);

        public Builder enableCloudwatchLogsExports(Collection<String> var1);

        public Builder enableCloudwatchLogsExports(String ... var1);

        public Builder processorFeatures(Collection<ProcessorFeature> var1);

        public Builder processorFeatures(ProcessorFeature ... var1);

        public Builder processorFeatures(Consumer<ProcessorFeature.Builder> ... var1);

        public Builder useDefaultProcessorFeatures(Boolean var1);

        public Builder deletionProtection(Boolean var1);

        public Builder domain(String var1);

        public Builder domainIAMRoleName(String var1);

        public Builder domainFqdn(String var1);

        public Builder domainOu(String var1);

        public Builder domainAuthSecretArn(String var1);

        public Builder domainDnsIps(Collection<String> var1);

        public Builder domainDnsIps(String ... var1);

        public Builder replicaMode(String var1);

        public Builder replicaMode(ReplicaMode var1);

        public Builder enableCustomerOwnedIp(Boolean var1);

        public Builder networkType(String var1);

        public Builder maxAllocatedStorage(Integer var1);

        public Builder backupTarget(String var1);

        public Builder customIamInstanceProfile(String var1);

        public Builder allocatedStorage(Integer var1);

        public Builder sourceDBClusterIdentifier(String var1);

        public Builder dedicatedLogVolume(Boolean var1);

        public Builder upgradeStorageConfig(Boolean var1);

        public Builder caCertificateIdentifier(String var1);

        public Builder sourceRegion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

