/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.persistence;

import io.moquette.persistence.PropertyDataType;
import io.moquette.persistence.SerdesUtils;
import io.netty.handler.codec.mqtt.MqttProperties;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.BasicDataType;

final class PropertiesDataType
extends BasicDataType<MqttProperties.MqttProperty[]> {
    private final PropertyDataType propertyDataType = new PropertyDataType();

    PropertiesDataType() {
    }

    public int getMemory(MqttProperties.MqttProperty[] obj) {
        return 4 + Arrays.stream(obj).mapToInt(this.propertyDataType::getMemory).sum();
    }

    public void write(WriteBuffer buff, MqttProperties.MqttProperty[] obj) {
        buff.putInt(obj.length);
        for (MqttProperties.MqttProperty property : obj) {
            this.propertyDataType.write(buff, property);
        }
    }

    public MqttProperties.MqttProperty[] read(ByteBuffer buff) {
        return SerdesUtils.readProperties(buff, buffer -> this.propertyDataType.read(buff));
    }

    public MqttProperties.MqttProperty[][] createStorage(int size) {
        return new MqttProperties.MqttProperty[size][];
    }
}

