/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Assignments;
import org.apache.iotdb.db.queryengine.plan.relational.planner.PlanNodeSearcher;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AssignUniqueId;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.CorrelatedJoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.EnforceSingleRowNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.FilterNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.JoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.MarkDistinctNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.Cardinality;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.QueryCardinalityUtil;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Cast;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FunctionCall;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SimpleCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StringLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WhenClause;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeSignatureTranslator;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;
import org.apache.tsfile.read.common.type.BooleanType;
import org.apache.tsfile.read.common.type.LongType;
import org.apache.tsfile.read.common.type.Type;

public class TransformCorrelatedScalarSubquery
implements Rule<CorrelatedJoinNode> {
    private static final Pattern<CorrelatedJoinNode> PATTERN = Patterns.correlatedJoin().with(Pattern.nonEmpty(Patterns.CorrelatedJoin.correlation())).with(Patterns.CorrelatedJoin.filter().equalTo(BooleanLiteral.TRUE_LITERAL));
    private final Metadata metadata;

    public TransformCorrelatedScalarSubquery(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public Pattern<CorrelatedJoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(CorrelatedJoinNode correlatedJoinNode, Captures captures, Rule.Context context) {
        Preconditions.checkArgument((correlatedJoinNode.getJoinType() == JoinNode.JoinType.INNER || correlatedJoinNode.getJoinType() == JoinNode.JoinType.LEFT ? 1 : 0) != 0, (String)"unexpected correlated join type: %s", (Object)((Object)correlatedJoinNode.getJoinType()));
        PlanNode subquery = context.getLookup().resolve(correlatedJoinNode.getSubquery());
        if (!PlanNodeSearcher.searchFrom(subquery, context.getLookup()).where(EnforceSingleRowNode.class::isInstance).recurseOnlyWhen(ProjectNode.class::isInstance).matches()) {
            return Rule.Result.empty();
        }
        PlanNode rewrittenSubquery = PlanNodeSearcher.searchFrom(subquery, context.getLookup()).where(EnforceSingleRowNode.class::isInstance).recurseOnlyWhen(ProjectNode.class::isInstance).removeFirst();
        Cardinality subqueryCardinality = QueryCardinalityUtil.extractCardinality(rewrittenSubquery, context.getLookup());
        boolean producesAtMostOneRow = subqueryCardinality.isAtMostScalar();
        if (producesAtMostOneRow) {
            boolean producesSingleRow = subqueryCardinality.isScalar();
            return Rule.Result.ofPlanNode(new CorrelatedJoinNode(context.getIdAllocator().genPlanNodeId(), correlatedJoinNode.getInput(), rewrittenSubquery, correlatedJoinNode.getCorrelation(), producesSingleRow ? JoinNode.JoinType.INNER : JoinNode.JoinType.LEFT, correlatedJoinNode.getFilter(), correlatedJoinNode.getOriginSubquery()));
        }
        Symbol unique = context.getSymbolAllocator().newSymbol("unique", (Type)LongType.INT64);
        CorrelatedJoinNode rewrittenCorrelatedJoinNode = new CorrelatedJoinNode(context.getIdAllocator().genPlanNodeId(), new AssignUniqueId(context.getIdAllocator().genPlanNodeId(), correlatedJoinNode.getInput(), unique), rewrittenSubquery, correlatedJoinNode.getCorrelation(), JoinNode.JoinType.LEFT, correlatedJoinNode.getFilter(), correlatedJoinNode.getOriginSubquery());
        Symbol isDistinct = context.getSymbolAllocator().newSymbol("is_distinct", (Type)BooleanType.BOOLEAN);
        MarkDistinctNode markDistinctNode = new MarkDistinctNode(context.getIdAllocator().genPlanNodeId(), rewrittenCorrelatedJoinNode, isDistinct, rewrittenCorrelatedJoinNode.getInput().getOutputSymbols(), Optional.empty());
        FilterNode filterNode = new FilterNode(context.getIdAllocator().genPlanNodeId(), markDistinctNode, new SimpleCaseExpression(isDistinct.toSymbolReference(), (List<WhenClause>)ImmutableList.of((Object)new WhenClause(BooleanLiteral.TRUE_LITERAL, BooleanLiteral.TRUE_LITERAL)), new Cast(new FunctionCall(QualifiedName.of("fail"), (List<Expression>)ImmutableList.of((Object)new StringLiteral("Scalar sub-query has returned multiple rows."))), TypeSignatureTranslator.toSqlType((Type)BooleanType.BOOLEAN))));
        return Rule.Result.ofPlanNode(new ProjectNode(context.getIdAllocator().genPlanNodeId(), filterNode, Assignments.identity(correlatedJoinNode.getOutputSymbols())));
    }
}

