/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

class GzipChannel
implements WritableByteChannel {
    static final short GZIP_MAGIC = -29921;
    static final int CM_DEFLATE = 8;
    private static final byte[] GZIP_HEADER_ = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0};
    private static final ByteBuffer GZIP_HEADER = ByteBuffer.wrap(GZIP_HEADER_);
    private boolean headerWritten = false;
    private boolean finished = false;
    private boolean dataWritten = false;
    private long outputPosition;
    private final WritableByteChannel channel;
    private final Deflater deflater = new Deflater(9, true);
    private final ByteBuffer buffer;
    private final CRC32 crc = new CRC32();

    public GzipChannel(WritableByteChannel channel) throws IOException {
        this(channel, ByteBuffer.allocate(8192));
    }

    public GzipChannel(WritableByteChannel channel, ByteBuffer buffer) throws IOException, IllegalArgumentException {
        this.channel = channel;
        this.buffer = buffer;
        if (!buffer.hasArray()) {
            throw new IllegalArgumentException("ByteBuffer must be array-backed and writable");
        }
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    private void checkStatus(boolean finish) throws IOException {
        if (finish && !this.dataWritten || !finish && !this.headerWritten) {
            this.writeHeader();
            this.dataWritten = true;
            this.finished = false;
        }
    }

    private void writeHeader() throws IOException {
        this.outputPosition += (long)this.channel.write(GZIP_HEADER);
        GZIP_HEADER.rewind();
        this.headerWritten = true;
    }

    public int finish() throws IOException {
        int clen;
        if (this.finished) {
            return 0;
        }
        this.checkStatus(true);
        this.deflater.finish();
        int cwritten = 0;
        while ((clen = this.deflater.deflate(this.buffer.array(), this.buffer.arrayOffset() + this.buffer.position(), this.buffer.remaining(), 3)) > 0) {
            cwritten += clen;
            this.buffer.position(this.buffer.position() + clen);
            this.buffer.flip();
            this.outputPosition += (long)this.channel.write(this.buffer);
            this.buffer.compact();
        }
        this.buffer.putInt((int)this.crc.getValue());
        this.buffer.putInt((int)this.deflater.getBytesRead());
        this.buffer.flip();
        this.outputPosition += (long)this.channel.write(this.buffer);
        this.buffer.compact();
        this.deflater.reset();
        this.crc.reset();
        this.finished = true;
        this.headerWritten = false;
        return cwritten;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        if (!this.finished) {
            this.finish();
        }
        this.channel.close();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        byte[] srcBytes;
        int off = src.position();
        int len = src.remaining();
        if (len == 0) {
            return 0;
        }
        if (src.hasArray()) {
            srcBytes = src.array();
            src.position(len);
            src.limit(len);
        } else {
            off = 0;
            srcBytes = new byte[len];
            src.get(srcBytes);
        }
        this.crc.update(srcBytes, off, len);
        this.deflater.setInput(srcBytes, off, len);
        this.checkStatus(false);
        while (!this.deflater.needsInput()) {
            int clen = this.deflater.deflate(this.buffer.array(), this.buffer.arrayOffset() + this.buffer.position(), this.buffer.remaining(), 0);
            if (clen <= 0) continue;
            this.buffer.position(this.buffer.position() + clen);
            this.buffer.flip();
            this.outputPosition += (long)this.channel.write(this.buffer);
            this.buffer.compact();
        }
        return len;
    }

    public long outputPosition() {
        return this.outputPosition;
    }
}

