/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import org.apache.juneau.BinaryFormat;
import org.apache.juneau.MediaType;
import org.apache.juneau.UriContext;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.serializer.OutputStreamSerializer;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.svl.VarResolverSession;

public class OutputStreamSerializerSession
extends SerializerSession {
    private final OutputStreamSerializer ctx;

    public static Builder create(OutputStreamSerializer ctx) {
        return new Builder((OutputStreamSerializer)AssertionUtils.assertArgNotNull((String)"ctx", (Object)ctx));
    }

    protected OutputStreamSerializerSession(Builder builder) {
        super(builder);
        this.ctx = builder.ctx;
    }

    @Override
    public final boolean isWriterSerializer() {
        return false;
    }

    public final byte[] serialize(Object o) throws SerializeException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.serialize(o, baos);
            baos.flush();
        }
        catch (IOException e) {
            throw new SerializeException(e);
        }
        return baos.toByteArray();
    }

    @Override
    public final String serializeToString(Object o) throws SerializeException {
        byte[] b = this.serialize(o);
        return switch (this.getBinaryFormat()) {
            case BinaryFormat.SPACED_HEX -> StringUtils.toSpacedHex((byte[])b);
            case BinaryFormat.HEX -> StringUtils.toHex((byte[])b);
            case BinaryFormat.BASE64 -> StringUtils.base64Encode((byte[])b);
            default -> null;
        };
    }

    @Override
    protected SerializerPipe createPipe(Object output) {
        return new SerializerPipe(output);
    }

    protected final BinaryFormat getBinaryFormat() {
        return this.ctx.getBinaryFormat();
    }

    public static class Builder
    extends SerializerSession.Builder {
        private OutputStreamSerializer ctx;

        protected Builder(OutputStreamSerializer ctx) {
            super((Serializer)AssertionUtils.assertArgNotNull((String)"ctx", (Object)ctx));
            this.ctx = ctx;
        }

        @Override
        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            super.apply((Class)type, (Consumer)apply);
            return this;
        }

        @Override
        public OutputStreamSerializerSession build() {
            return new OutputStreamSerializerSession(this);
        }

        @Override
        public Builder debug(Boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder javaMethod(Method value) {
            super.javaMethod(value);
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder mediaTypeDefault(MediaType value) {
            super.mediaTypeDefault(value);
            return this;
        }

        @Override
        public Builder properties(Map<String, Object> value) {
            super.properties((Map)value);
            return this;
        }

        @Override
        public Builder property(String key, Object value) {
            super.property(key, value);
            return this;
        }

        @Override
        public Builder resolver(VarResolverSession value) {
            super.resolver(value);
            return this;
        }

        @Override
        public Builder schema(HttpPartSchema value) {
            super.schema(value);
            return this;
        }

        @Override
        public Builder schemaDefault(HttpPartSchema value) {
            super.schemaDefault(value);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder timeZoneDefault(TimeZone value) {
            super.timeZoneDefault(value);
            return this;
        }

        @Override
        public Builder unmodifiable() {
            super.unmodifiable();
            return this;
        }

        @Override
        public Builder uriContext(UriContext value) {
            super.uriContext(value);
            return this;
        }
    }
}

