/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.knox.gateway.shell.CredentialCollectionException;
import org.apache.knox.gateway.shell.Credentials;
import org.apache.knox.gateway.shell.KnoxDataSource;
import org.apache.knox.gateway.shell.KnoxSession;
import org.apache.knox.gateway.shell.jdbc.JDBCUtils;
import org.apache.knox.gateway.shell.table.KnoxShellTable;

public class KnoxLine {
    private String user;
    private String pass;
    private KnoxDataSource datasource;
    private Connection conn;

    public void execute(String[] args) throws ClassNotFoundException, SQLException, CredentialCollectionException {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.out.println("Closing any open connections ...");
                KnoxLine.this.closeConnection();
            }
        });
        this.executeShell();
    }

    private void executeShell() {
        System.out.println(" _                    _ _            ");
        System.out.println("| | ___ __   _____  _| (_)_ __   ___ ");
        System.out.println("| |/ / '_ \\ / _ \\ \\/ / | | '_ \\ / _ \\");
        System.out.println("|   <| | | | (_) >  <| | | | | |  __/");
        System.out.println("|_|\\_\\_| |_|\\___/_/\\_\\_|_|_| |_|\\\\__|");
        System.out.println("powered by Apache Knox");
        System.out.println("");
        System.out.println("");
        while (true) {
            String sql;
            if ((sql = System.console().readLine("knoxline> ", new Object[0])) == null || sql.isEmpty()) {
                continue;
            }
            if (sql.startsWith(":ds") || sql.startsWith(":datasource")) {
                try {
                    this.processDataSourceCommand(sql);
                }
                catch (SQLException | CredentialCollectionException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (this.datasource != null) {
                System.out.println(sql);
                try {
                    this.establishConnection();
                    Statement statement = this.conn.createStatement();
                    Throwable throwable = null;
                    try {
                        if (!statement.execute(sql)) continue;
                        ResultSet resultSet = statement.getResultSet();
                        Throwable throwable2 = null;
                        try {
                            KnoxShellTable table = KnoxShellTable.builder().jdbc().resultSet(resultSet);
                            System.out.println(table.toString());
                            System.out.println("\nRows: " + table.getRows().size() + "\n");
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (resultSet == null) continue;
                            if (throwable2 != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            resultSet.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (statement == null) continue;
                        if (throwable != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    System.out.println("SQL Exception encountered... " + e.getMessage());
                }
                continue;
            }
            System.out.println("No datasource selected. Use :ds select {datasource-name}");
        }
    }

    private void establishConnection() throws SQLException {
        if (this.conn == null || this.conn.isClosed()) {
            System.out.println("Connecting...");
            this.conn = JDBCUtils.createConnection(this.datasource.getConnectStr(), this.user, this.pass);
        }
    }

    void processDataSourceCommand(String sql) throws CredentialCollectionException, SQLException {
        String[] args = sql.split(" ");
        if (args.length == 1 || args[1].equals("list")) {
            this.listDataSources();
        } else if (args[1].equals("select")) {
            this.selectDataSource(args[2]);
        } else if (args[1].equals("add")) {
            if (args.length == 6) {
                this.addDataSource(args[2], args[3], args[4], args[5]);
            } else {
                System.out.println("Invalid number of arguments for :ds add. Useage: :ds add {ds-name} {connectStr} {driver} {authnType: none|basic}");
            }
        } else if (args[1].contentEquals("remove")) {
            if (args.length == 3) {
                this.removeDataSource(args[2]);
            } else {
                System.out.println("Invalid number of arguments for :ds remove. Useage: :ds remove {ds-name}");
            }
        }
    }

    private void listDataSources() {
        Map<String, KnoxDataSource> sources = this.getDataSources();
        if (sources != null) {
            sources.forEach((name, ds) -> System.out.println("Name : " + name + " : " + ds.getConnectStr()));
        } else {
            System.out.println("No datasources configured. Use :ds add {ds-name} {connectStr} {driver} {authnType: none|basic}");
        }
    }

    private Map<String, KnoxDataSource> getDataSources() {
        HashMap<String, KnoxDataSource> datasources = new HashMap();
        try {
            datasources = KnoxSession.loadDataSources();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return datasources;
    }

    private KnoxDataSource addDataSource(String name, String connectStr, String driver, String authnType) {
        Map<String, KnoxDataSource> datasources = this.getDataSources();
        KnoxDataSource ds = new KnoxDataSource(name, connectStr, driver, authnType);
        datasources.put(name, ds);
        KnoxSession.persistDataSources(datasources);
        return ds;
    }

    private void removeDataSource(String name) {
        Map<String, KnoxDataSource> datasources = this.getDataSources();
        datasources.remove(name);
        KnoxSession.persistDataSources(datasources);
    }

    private void selectDataSource(String name) throws CredentialCollectionException {
        Map<String, KnoxDataSource> sources = this.getDataSources();
        this.datasource = sources.get(name);
        if (this.datasource == null) {
            System.out.println("Invalid datasource name provided. See output from: :ds list");
            return;
        }
        this.user = null;
        this.pass = null;
        if (this.datasource.getAuthnType().contentEquals("basic")) {
            this.collectCredentials();
        }
        this.closeConnection();
        try {
            this.establishConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void closeConnection() {
        try {
            if (this.conn != null && !this.conn.isClosed()) {
                this.conn.close();
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.conn = null;
        }
    }

    private void collectCredentials() throws CredentialCollectionException {
        Credentials credentials = new Credentials();
        credentials.add("ClearInput", "Enter username: ", "user").add("HiddenInput", "Enter password: ", "pass").collect();
        this.user = credentials.get("user").string();
        this.pass = credentials.get("pass").string();
    }
}

