/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.eventbus.impl.codecs;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.apache.kyuubi.shade.io.vertx.core.buffer.Buffer;
import org.apache.kyuubi.shade.io.vertx.core.eventbus.MessageCodec;
import org.apache.kyuubi.shade.io.vertx.core.eventbus.impl.CodecManager;
import org.apache.kyuubi.shade.io.vertx.core.impl.SerializableUtils;

public class SerializableCodec
implements MessageCodec<Object, Object> {
    private final CodecManager codecManager;

    public SerializableCodec(CodecManager codecManager) {
        this.codecManager = codecManager;
    }

    @Override
    public void encodeToWire(Buffer buffer, Object o) {
        byte[] bytes = SerializableUtils.toBytes(o);
        buffer.appendInt(bytes.length);
        buffer.appendBytes(bytes);
    }

    @Override
    public Object decodeFromWire(int pos, Buffer buffer) {
        int length = buffer.getInt(pos);
        byte[] bytes = buffer.getBytes(pos += 4, pos + length);
        return SerializableUtils.fromBytes(bytes, x$0 -> new CheckedClassNameObjectInputStream(x$0));
    }

    @Override
    public Object transform(Object o) {
        return SerializableUtils.fromBytes(SerializableUtils.toBytes(o), ObjectInputStream::new);
    }

    @Override
    public String name() {
        return "serializable";
    }

    @Override
    public byte systemCodecID() {
        return 17;
    }

    private class CheckedClassNameObjectInputStream
    extends ObjectInputStream {
        CheckedClassNameObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String name = desc.getName();
            if (!SerializableCodec.this.codecManager.acceptSerializable(name)) {
                throw new InvalidClassException("Class not allowed: " + name);
            }
            return super.resolveClass(desc);
        }
    }
}

