/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.datagram.impl;

import org.apache.kyuubi.shade.io.vertx.core.AsyncResult;
import org.apache.kyuubi.shade.io.vertx.core.Future;
import org.apache.kyuubi.shade.io.vertx.core.Handler;
import org.apache.kyuubi.shade.io.vertx.core.Promise;
import org.apache.kyuubi.shade.io.vertx.core.buffer.Buffer;
import org.apache.kyuubi.shade.io.vertx.core.datagram.impl.DatagramSocketImpl;
import org.apache.kyuubi.shade.io.vertx.core.streams.WriteStream;

class PacketWriteStreamImpl
implements WriteStream<Buffer>,
Handler<AsyncResult<Void>> {
    private DatagramSocketImpl datagramSocket;
    private Handler<Throwable> exceptionHandler;
    private final int port;
    private final String host;

    PacketWriteStreamImpl(DatagramSocketImpl datagramSocket, int port, String host) {
        this.datagramSocket = datagramSocket;
        this.port = port;
        this.host = host;
    }

    @Override
    public void handle(AsyncResult<Void> event) {
        if (event.failed() && this.exceptionHandler != null) {
            this.exceptionHandler.handle(event.cause());
        }
    }

    @Override
    public PacketWriteStreamImpl exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public Future<Void> write(Buffer data) {
        Promise<Void> promise = Promise.promise();
        this.write(data, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    public void write(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.datagramSocket.send(data, this.port, this.host, ar -> {
            this.handle((AsyncResult<Void>)ar);
            if (handler != null) {
                handler.handle(ar.mapEmpty());
            }
        });
    }

    public PacketWriteStreamImpl setWriteQueueMaxSize(int maxSize) {
        return this;
    }

    @Override
    public boolean writeQueueFull() {
        return false;
    }

    public PacketWriteStreamImpl drainHandler(Handler<Void> handler) {
        return this;
    }

    @Override
    public Future<Void> end() {
        Promise<Void> promide = Promise.promise();
        this.end((Handler<AsyncResult<Void>>)promide);
        return promide.future();
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.datagramSocket.close(handler);
    }
}

