/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.ctl.util;

import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.ctl.CliConfig;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;

public final class Validator$ {
    public static Validator$ MODULE$;

    static {
        new Validator$();
    }

    public void validateZkArguments(CliConfig cliConfig) {
        block1: {
            if (cliConfig.zkOpts().zkQuorum() == null) {
                this.fail("Zookeeper quorum is not specified and no default value to load");
            }
            if (cliConfig.zkOpts().namespace() != null) break block1;
            this.fail("Zookeeper namespace is not specified and no default value to load");
        }
    }

    public void validateHostAndPort(CliConfig cliConfig) {
        InetAddress inetAddress;
        if (cliConfig.zkOpts().host() == null) {
            this.fail("Must specify host for service");
        }
        if (cliConfig.zkOpts().port() == null) {
            this.fail("Must specify port for service");
        }
        try {
            inetAddress = InetAddress.getByName(cliConfig.zkOpts().host());
        }
        catch (Exception exception) {
            this.fail(new StringBuilder(14).append("Unknown host: ").append(cliConfig.zkOpts().host()).toString());
            inetAddress = BoxedUnit.UNIT;
        }
        try {
            if (new StringOps(Predef$.MODULE$.augmentString(cliConfig.zkOpts().port())).toInt() <= 0) {
                this.fail("Specified port should be a positive number");
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.fail(new StringBuilder(46).append("Specified port is not a valid integer number: ").append(cliConfig.zkOpts().port()).toString());
        }
    }

    public void validateFilename(CliConfig cliConfig) {
        block1: {
            String filename = cliConfig.createOpts().filename();
            if (StringUtils.isBlank((CharSequence)filename)) {
                this.fail("Config file is not specified.");
            }
            if (Files.exists(Paths.get(filename, new String[0]), new LinkOption[0])) break block1;
            this.fail(new StringBuilder(29).append("Config file does not exist: ").append(filename).append(".").toString());
        }
    }

    public void validateAdminConfigType(CliConfig cliConfig) {
        block0: {
            if (cliConfig.adminConfigOpts().configType() != null) break block0;
            this.fail("The config type is not specified.");
        }
    }

    private void fail(String msg) {
        throw new KyuubiException(msg, KyuubiException$.MODULE$.$lessinit$greater$default$2());
    }

    private Validator$() {
        MODULE$ = this;
    }
}

