/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.config.internal.Tests$;
import org.apache.kyuubi.shade.org.apache.commons.lang3.SystemUtils;
import org.apache.kyuubi.shade.org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class Utils$
implements Logging {
    public static Utils$ MODULE$;
    private final int MAX_DIR_CREATION_ATTEMPTS;
    private final Regex shortVersionRegex;
    private final boolean isWindows;
    private final int DEFAULT_SHUTDOWN_PRIORITY;
    private final int SERVER_SHUTDOWN_PRIORITY;
    private final int SPARK_CONTEXT_SHUTDOWN_PRIORITY;
    private final int FLINK_ENGINE_SHUTDOWN_PRIORITY;
    private final int TRINO_ENGINE_SHUTDOWN_PRIORITY;
    private final int JDBC_ENGINE_SHUTDOWN_PRIORITY;
    private final String REDACTION_REPLACEMENT_TEXT;
    private final Regex PATTERN_FOR_KEY_VALUE_ARG;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        new Utils$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public Seq<String> strToSeq(String s, String sp2) {
        Predef$.MODULE$.require(s != null);
        return Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s.split(sp2))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$strToSeq$2(x$2))));
    }

    public String strToSeq$default$2() {
        return ",";
    }

    public Map<String, String> getSystemProperties() {
        return package$.MODULE$.props().toMap(Predef$.MODULE$.$conforms());
    }

    public Option<File> getDefaultPropertiesFile(Map<String, String> env) {
        return env.get((Object)"KYUUBI_CONF_DIR").orElse((Function0 & Serializable & scala.Serializable)() -> env.get((Object)"KYUUBI_HOME").map((Function1 & Serializable & scala.Serializable)x$3 -> new StringBuilder(4).append((String)x$3).append(File.separator).append("conf").toString())).map((Function1 & Serializable & scala.Serializable)d -> new File(new StringBuilder(20).append((String)d).append(File.separator).append("kyuubi-defaults.conf").toString())).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.exists())).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)MODULE$.getClass().getClassLoader().getResource("kyuubi-defaults.conf")).map((Function1 & Serializable & scala.Serializable)url -> new File(url.getFile())).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.exists())));
    }

    public Map<String, String> getDefaultPropertiesFile$default$1() {
        return package$.MODULE$.env();
    }

    public Map<String, String> getPropertiesFromFile(Option<File> file) {
        return (Map)file.map((Function1 & Serializable & scala.Serializable)f -> {
            Map map;
            MODULE$.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Loading Kyuubi properties from ").append(f.getAbsolutePath()).toString());
            try (InputStreamReader reader = new InputStreamReader(f.toURI().toURL().openStream(), StandardCharsets.UTF_8);){
                Properties properties = new Properties();
                properties.load(reader);
                map = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(properties.stringPropertyNames()).asScala()).map((Function1 & Serializable & scala.Serializable)k -> new Tuple2(k, (Object)properties.getProperty((String)k).trim()), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            }
            catch (IOException e) {
                throw new KyuubiException(new StringBuilder(43).append("Failed when loading Kyuubi properties from ").append(f.getAbsolutePath()).toString(), e);
            }
            return map;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    private int MAX_DIR_CREATION_ATTEMPTS() {
        return this.MAX_DIR_CREATION_ATTEMPTS;
    }

    public Path createDirectory(String root, String namePrefix) {
        Object object = new Object();
        try {
            ObjectRef error = ObjectRef.create(null);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.MAX_DIR_CREATION_ATTEMPTS()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$6 -> {
                Path candidate = Paths.get(root, new StringBuilder(1).append(namePrefix).append("-").append(UUID.randomUUID()).toString());
                try {
                    Path path = Files.createDirectories(candidate, new FileAttribute[0]);
                    throw new NonLocalReturnControl(object, (Object)path);
                }
                catch (IOException e) {
                    error$1.elem = e;
                    return;
                }
            });
            throw new IOException(new StringBuilder(59).append("Failed to create a temp directory (under ").append(root).append(") after ").append(this.MAX_DIR_CREATION_ATTEMPTS()).append(" attempts!").toString(), (Exception)error.elem);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (Path)ex.value();
        }
    }

    public String createDirectory$default$2() {
        return "kyuubi";
    }

    public Path getAbsolutePathFromWork(String pathStr, Map<String, String> env) {
        Path path;
        Path path2 = Paths.get(pathStr, new String[0]);
        if (path2.isAbsolute()) {
            path = path2;
        } else {
            String string;
            Option option = env.get((Object)"KYUUBI_WORK_DIR_ROOT");
            if (option instanceof Some) {
                String dir;
                Some some = (Some)option;
                string = dir = (String)some.value();
            } else {
                string = System.getProperty("user.dir");
            }
            String workDir = string;
            path = Paths.get(workDir, pathStr);
        }
        return path;
    }

    public Map<String, String> getAbsolutePathFromWork$default$2() {
        return package$.MODULE$.env();
    }

    public boolean deleteDirectoryRecursively(File f2) {
        block2: {
            if (!f2.isDirectory()) break block2;
            File[] fileArray = f2.listFiles();
            if (fileArray != null) {
                File[] fileArray2 = fileArray;
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileArray2)).foreach((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.deleteDirectoryRecursively(f)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        return f2.delete();
    }

    /*
     * WARNING - void declaration
     */
    public Path createTempDir(String root, String namePrefix) {
        void var3_3;
        Path dir = this.createDirectory(root, namePrefix);
        dir.toFile().deleteOnExit();
        return var3_3;
    }

    public String createTempDir$default$1() {
        return System.getProperty("java.io.tmpdir");
    }

    public String createTempDir$default$2() {
        return "kyuubi";
    }

    public String currentUser() {
        return UserGroupInformation.getCurrentUser().getShortUserName();
    }

    private Regex shortVersionRegex() {
        return this.shortVersionRegex;
    }

    public String shortVersion(String version) {
        Option option = this.shortVersionRegex().findFirstMatchIn((CharSequence)version);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException(new StringBuilder(113).append("Tried to parse '").append(version).append("' as a project").append(" version string, but it could not find the major/minor/maintenance version numbers.").toString());
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        Regex.Match m = (Regex.Match)some.value();
        String string = m.group(1);
        return string;
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    public boolean isTesting() {
        return System.getProperty(Tests$.MODULE$.IS_TESTING().key()) != null;
    }

    public int DEFAULT_SHUTDOWN_PRIORITY() {
        return this.DEFAULT_SHUTDOWN_PRIORITY;
    }

    public int SERVER_SHUTDOWN_PRIORITY() {
        return this.SERVER_SHUTDOWN_PRIORITY;
    }

    public int SPARK_CONTEXT_SHUTDOWN_PRIORITY() {
        return this.SPARK_CONTEXT_SHUTDOWN_PRIORITY;
    }

    public int FLINK_ENGINE_SHUTDOWN_PRIORITY() {
        return this.FLINK_ENGINE_SHUTDOWN_PRIORITY;
    }

    public int TRINO_ENGINE_SHUTDOWN_PRIORITY() {
        return this.TRINO_ENGINE_SHUTDOWN_PRIORITY;
    }

    public int JDBC_ENGINE_SHUTDOWN_PRIORITY() {
        return this.JDBC_ENGINE_SHUTDOWN_PRIORITY;
    }

    public void addShutdownHook(Runnable hook, int priority) {
        ShutdownHookManager.get().addShutdownHook(hook, priority);
    }

    public int addShutdownHook$default$2() {
        return this.DEFAULT_SHUTDOWN_PRIORITY();
    }

    /*
     * WARNING - void declaration
     */
    public InetAddress findLocalInetAddress() {
        InetAddress inetAddress;
        Object object = new Object();
        try {
            void var2_2;
            InetAddress address = InetAddress.getLocalHost();
            if (address.isLoopbackAddress()) {
                Seq activeNetworkIFs = ((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(NetworkInterface.getNetworkInterfaces()).asScala()).toSeq();
                Seq reOrderedNetworkIFs = this.isWindows() ? activeNetworkIFs : (Seq)activeNetworkIFs.reverse();
                reOrderedNetworkIFs.foreach((Function1 & Serializable & scala.Serializable)ni -> {
                    Utils$.$anonfun$findLocalInetAddress$1(address, object, ni);
                    return BoxedUnit.UNIT;
                });
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(83).append(address.getHostName()).append(" was resolved to a loopback address: ").append(address.getHostAddress()).append(" but we couldn't find any external IP address!").toString());
            }
            inetAddress = var2_2;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                inetAddress = (InetAddress)ex.value();
            }
            throw ex;
        }
        return inetAddress;
    }

    public String getDateFromTimestamp(long time) {
        return DateFormatUtils.format(time, "yyyyMMdd", TimeZone.getDefault());
    }

    public String stringifyException(Throwable e) {
        StringWriter stm = new StringWriter();
        PrintWriter wrt = new PrintWriter(stm);
        e.printStackTrace(wrt);
        wrt.close();
        return stm.toString();
    }

    public void tryLogNonFatalError(Function0<BoxedUnit> block) {
        try {
            block.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Uncaught exception in thread ").append(Thread.currentThread().getName()).toString(), t);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public String getCodeSourceLocation(Class<?> clazz) {
        return new File(clazz.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
    }

    public void fromCommandLineArgs(String[] args, KyuubiConf conf) {
        Predef$.MODULE$.require(args.length % 2 == 0, (Function0 & Serializable & scala.Serializable)() -> "Illegal size of arguments.");
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).indices().by(2).foreach((Function1 & Serializable & scala.Serializable)i -> Utils$.$anonfun$fromCommandLineArgs$2(args, conf, BoxesRunTime.unboxToInt((Object)i)));
    }

    public String REDACTION_REPLACEMENT_TEXT() {
        return this.REDACTION_REPLACEMENT_TEXT;
    }

    private Regex PATTERN_FOR_KEY_VALUE_ARG() {
        return this.PATTERN_FOR_KEY_VALUE_ARG;
    }

    public String[] redactCommandLineArgs(KyuubiConf conf, String[] commands) {
        Option redactionPattern = (Option)conf.get(KyuubiConf$.MODULE$.SERVER_SECRET_REDACTION_PATTERN());
        BooleanRef nextKV = BooleanRef.create((boolean)false);
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commands)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string = x0$1;
            Option option = MODULE$.PATTERN_FOR_KEY_VALUE_ARG().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                String key = (String)((LinearSeqOptimized)option.get()).apply(0);
                String value = (String)((LinearSeqOptimized)option.get()).apply(1);
                if (nextKV$1.elem) {
                    String newValue;
                    Tuple2 tuple2 = (Tuple2)MODULE$.redact((Option<Regex>)redactionPattern, (Seq)new .colon.colon((Object)new Tuple2((Object)key, (Object)value), (List)Nil$.MODULE$)).head();
                    if (tuple2 == null) throw new MatchError((Object)tuple2);
                    String string2 = newValue = (String)tuple2._2();
                    String newValue2 = string2;
                    nextKV$1.elem = false;
                    return new StringBuilder(1).append(key).append("=").append(newValue2).toString();
                }
            }
            String string3 = string;
            String string4 = "--conf";
            if (string3 == null) {
                if (string4 != null) {
                    return string;
                }
            } else if (!string3.equals(string4)) return string;
            nextKV$1.elem = true;
            return string;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    public <K, V> Seq<Tuple2<K, V>> redact(Option<Regex> regex, Seq<Tuple2<K, V>> kvs) {
        Seq<Tuple2<K, V>> seq;
        Option<Regex> option = regex;
        if (None$.MODULE$.equals(option)) {
            seq = kvs;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Regex r = (Regex)some.value();
            seq = this.redact(r, kvs);
        } else {
            throw new MatchError(option);
        }
        return seq;
    }

    private <K, V> Seq<Tuple2<K, V>> redact(Regex redactionPattern, Seq<Tuple2<K, V>> kvs) {
        return (Seq)kvs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object key = tuple2._1();
                Object value = tuple2._2();
                if (key instanceof String) {
                    String string = (String)key;
                    if (value instanceof String) {
                        String string2 = (String)value;
                        return (Tuple2)redactionPattern.findFirstIn((CharSequence)string).orElse((Function0 & Serializable & scala.Serializable)() -> redactionPattern.findFirstIn((CharSequence)string2)).map((Function1 & Serializable & scala.Serializable)x$9 -> new Tuple2((Object)string, (Object)MODULE$.REDACTION_REPLACEMENT_TEXT())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)string, (Object)string2));
                    }
                }
            }
            if (tuple2 != null) {
                Object key = tuple2._1();
                Object value = tuple2._2();
                if (value instanceof String) {
                    String string = (String)value;
                    return (Tuple2)redactionPattern.findFirstIn((CharSequence)string).map((Function1 & Serializable & scala.Serializable)x$10 -> new Tuple2(key, (Object)MODULE$.REDACTION_REPLACEMENT_TEXT())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2(key, (Object)string));
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Object key = tuple2._1();
            Object value = tuple2._2();
            return new Tuple2(key, value);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public boolean isCommandAvailable(String cmd) {
        return scala.sys.process.package$.MODULE$.stringToProcess(new StringBuilder(6).append("which ").append(cmd).toString()).$bang() == 0;
    }

    public boolean isOnK8s() {
        return Files.exists(Paths.get("/var/run/secrets/kubernetes.io", new String[0]), new LinkOption[0]);
    }

    public static final /* synthetic */ boolean $anonfun$strToSeq$2(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$findLocalInetAddress$2(InetAddress addr) {
        return addr.isLinkLocalAddress() || addr.isLoopbackAddress();
    }

    public static final /* synthetic */ boolean $anonfun$findLocalInetAddress$3(InetAddress x$7) {
        return x$7 instanceof Inet4Address;
    }

    public static final /* synthetic */ void $anonfun$findLocalInetAddress$1(InetAddress address$1, Object nonLocalReturnKey2$1, NetworkInterface ni) {
        Seq addresses = ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(ni.getInetAddresses()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)addr -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$findLocalInetAddress$2(addr))).toSeq();
        if (addresses.nonEmpty()) {
            InetAddress addr2 = (InetAddress)addresses.find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$findLocalInetAddress$3(x$7))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (InetAddress)addresses.head());
            InetAddress strippedAddress = InetAddress.getByAddress(addr2.getAddress());
            MODULE$.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append(address$1.getHostName()).append(" was resolved to a loopback address: ").append(address$1.getHostAddress()).append(", using ").append(strippedAddress.getHostAddress()).toString());
            throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)strippedAddress);
        }
    }

    public static final /* synthetic */ KyuubiConf $anonfun$fromCommandLineArgs$2(String[] args$1, KyuubiConf conf$1, int i) {
        String string = args$1[i];
        String string2 = "--conf";
        Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Unrecognized main arguments prefix ").append(args$1[i]).append(",").append("the argument format is '--conf k=v'.").toString());
        String[] stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args$1[i + 1].split("=", 2))).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        if (stringArray.length != 2) {
            throw new IllegalArgumentException(new StringBuilder(19).append("Illegal argument: ").append(args$1[i + 1]).append(".").toString());
        }
        KyuubiConf kyuubiConf = conf$1.set((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringArray)).head(), (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringArray)).last());
        return kyuubiConf;
    }

    private Utils$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.MAX_DIR_CREATION_ATTEMPTS = 10;
        this.shortVersionRegex = new StringOps(Predef$.MODULE$.augmentString("^(\\d+\\.\\d+\\.\\d+)(.*)?$")).r();
        this.isWindows = SystemUtils.IS_OS_WINDOWS;
        this.DEFAULT_SHUTDOWN_PRIORITY = 100;
        this.SERVER_SHUTDOWN_PRIORITY = 75;
        this.SPARK_CONTEXT_SHUTDOWN_PRIORITY = 50;
        this.FLINK_ENGINE_SHUTDOWN_PRIORITY = 50;
        this.TRINO_ENGINE_SHUTDOWN_PRIORITY = 50;
        this.JDBC_ENGINE_SHUTDOWN_PRIORITY = 50;
        this.REDACTION_REPLACEMENT_TEXT = "*********(redacted)";
        this.PATTERN_FOR_KEY_VALUE_ARG = new StringOps(Predef$.MODULE$.augmentString("(.+?)=(.+)")).r();
    }
}

