/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import java.io.Serializable;
import java.util.List;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.ApplicationInfo;
import org.apache.kyuubi.engine.ApplicationInfo$;
import org.apache.kyuubi.engine.ApplicationOperation;
import org.apache.kyuubi.engine.ApplicationState$;
import org.apache.kyuubi.engine.JpsApplicationOperation;
import org.apache.kyuubi.engine.KubernetesApplicationOperation$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001\u0002\u000b\u0016\u0001yAQ!\f\u0001\u0005\u00029B\u0011\u0002\r\u0001A\u0002\u0003\u0007I\u0011B\u0019\t\u0013y\u0002\u0001\u0019!a\u0001\n\u0013y\u0004\"C#\u0001\u0001\u0004\u0005\t\u0015)\u00033\u0011%Q\u0005\u00011AA\u0002\u0013%1\nC\u0005P\u0001\u0001\u0007\t\u0019!C\u0005!\"I!\u000b\u0001a\u0001\u0002\u0003\u0006K\u0001\u0014\u0005\u0006'\u0002!\t\u0005\u0016\u0005\u0006;\u0002!\tE\u0018\u0005\u0006e\u0002!\te\u001d\u0005\u0006{\u0002!\tE \u0005\b\u0003\u000f\u0001A\u0011BA\u0005\u0011\u001d\ty\u0003\u0001C!\u0003c9q!a\r\u0016\u0011\u0003\t)D\u0002\u0004\u0015+!\u0005\u0011q\u0007\u0005\u0007[=!\t!!\u000f\t\u0013\u0005mrB1A\u0005\u0002\u0005u\u0002\u0002CA'\u001f\u0001\u0006I!a\u0010\t\u000f\u0005=s\u0002\"\u0001\u0002R\tq2*\u001e2fe:,G/Z:BaBd\u0017nY1uS>tw\n]3sCRLwN\u001c\u0006\u0003-]\ta!\u001a8hS:,'B\u0001\r\u001a\u0003\u0019Y\u00170^;cS*\u0011!dG\u0001\u0007CB\f7\r[3\u000b\u0003q\t1a\u001c:h\u0007\u0001\u0019B\u0001A\u0010&SA\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t1\u0011I\\=SK\u001a\u0004\"AJ\u0014\u000e\u0003UI!\u0001K\u000b\u0003)\u0005\u0003\b\u000f\\5dCRLwN\\(qKJ\fG/[8o!\tQ3&D\u0001\u0018\u0013\tasCA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005y\u0003C\u0001\u0014\u0001\u0003AYWOY3s]\u0016$Xm]\"mS\u0016tG/F\u00013!\t\u0019D(D\u00015\u0015\t)d'\u0001\u0004dY&,g\u000e\u001e\u0006\u0003oa\n!b[;cKJtW\r^3t\u0015\tI$(A\u0004gC\n\u0014\u0018n\u0019\u001d\u000b\u0003m\n!![8\n\u0005u\"$\u0001E&vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u\u0003QYWOY3s]\u0016$Xm]\"mS\u0016tGo\u0018\u0013fcR\u0011\u0001i\u0011\t\u0003A\u0005K!AQ\u0011\u0003\tUs\u0017\u000e\u001e\u0005\b\t\u000e\t\t\u00111\u00013\u0003\rAH%M\u0001\u0012WV\u0014WM\u001d8fi\u0016\u001c8\t\\5f]R\u0004\u0003F\u0001\u0003H!\t\u0001\u0003*\u0003\u0002JC\tAao\u001c7bi&dW-\u0001\u0007kaN|\u0005/\u001a:bi&|g.F\u0001M!\t1S*\u0003\u0002O+\t9\"\n]:BaBd\u0017nY1uS>tw\n]3sCRLwN\\\u0001\u0011UB\u001cx\n]3sCRLwN\\0%KF$\"\u0001Q)\t\u000f\u00113\u0011\u0011!a\u0001\u0019\u0006i!\u000e]:Pa\u0016\u0014\u0018\r^5p]\u0002\n!\"\u001b8ji&\fG.\u001b>f)\t\u0001U\u000bC\u0003W\u0011\u0001\u0007q+\u0001\u0003d_:4\u0007C\u0001-\\\u001b\u0005I&B\u0001.\u0018\u0003\u0019\u0019wN\u001c4jO&\u0011A,\u0017\u0002\u000b\u0017f,XOY5D_:4\u0017aC5t'V\u0004\bo\u001c:uK\u0012$\"a\u00182\u0011\u0005\u0001\u0002\u0017BA1\"\u0005\u001d\u0011un\u001c7fC:DQaY\u0005A\u0002\u0011\fab\u00197vgR,'/T1oC\u001e,'\u000fE\u0002!K\u001eL!AZ\u0011\u0003\r=\u0003H/[8o!\tAwN\u0004\u0002j[B\u0011!.I\u0007\u0002W*\u0011A.H\u0001\u0007yI|w\u000e\u001e \n\u00059\f\u0013A\u0002)sK\u0012,g-\u0003\u0002qc\n11\u000b\u001e:j]\u001eT!A\\\u0011\u0002)-LG\u000e\\!qa2L7-\u0019;j_:\u0014\u0015\u0010V1h)\t!8\u0010\u0005\u0002vq:\u0011aE^\u0005\u0003oV\tq\u0001]1dW\u0006<W-\u0003\u0002zu\na1*\u001b7m%\u0016\u001c\bo\u001c8tK*\u0011q/\u0006\u0005\u0006y*\u0001\raZ\u0001\u0004i\u0006<\u0017aF4fi\u0006\u0003\b\u000f\\5dCRLwN\\%oM>\u0014\u0015\u0010V1h)\ry\u0018Q\u0001\t\u0004M\u0005\u0005\u0011bAA\u0002+\ty\u0011\t\u001d9mS\u000e\fG/[8o\u0013:4w\u000eC\u0003}\u0017\u0001\u0007q-\u0001\ngS:$GI]5wKJ\u0004v\u000e\u001a\"z)\u0006<G\u0003BA\u0006\u0003[\u0001\u0002\"!\u0004\u0002\u0014\u0005]\u0011qE\u0007\u0003\u0003\u001fQ1!!\u00055\u0003\r!7\u000f\\\u0005\u0005\u0003+\tyA\u0001\rGS2$XM],bi\u000eDG*[:u\t\u0016dW\r^1cY\u0016\u0004B!!\u0007\u0002$5\u0011\u00111\u0004\u0006\u0005\u0003;\ty\"A\u0003n_\u0012,GNC\u0002\u0002\"Y\n1!\u00199j\u0013\u0011\t)#a\u0007\u0003\u0007A{G\r\u0005\u0003\u0002\u001a\u0005%\u0012\u0002BA\u0016\u00037\u0011q\u0001U8e\u0019&\u001cH\u000fC\u0003}\u0019\u0001\u0007q-\u0001\u0003ti>\u0004H#\u0001!\u0002=-+(-\u001a:oKR,7/\u00119qY&\u001c\u0017\r^5p]>\u0003XM]1uS>t\u0007C\u0001\u0014\u0010'\ryq$\u000b\u000b\u0003\u0003k\tq\u0003T!C\u000b2{6*W+V\u0005&{VKT%R+\u0016{6*R-\u0016\u0005\u0005}\u0002\u0003BA!\u0003\u0017j!!a\u0011\u000b\t\u0005\u0015\u0013qI\u0001\u0005Y\u0006twM\u0003\u0002\u0002J\u0005!!.\u0019<b\u0013\r\u0001\u00181I\u0001\u0019\u0019\u0006\u0013U\tT0L3V+&)S0V\u001d&\u000bV+R0L\u000bf\u0003\u0013A\u0005;p\u0003B\u0004H.[2bi&|gn\u0015;bi\u0016$B!a\u0015\u0002rA!\u0011QKA6\u001d\u0011\t9&a\u001a\u000f\t\u0005e\u0013Q\r\b\u0005\u00037\n\u0019G\u0004\u0003\u0002^\u0005\u0005db\u00016\u0002`%\tA$\u0003\u0002\u001b7%\u0011\u0001$G\u0005\u0003-]I1!!\u001b\u0016\u0003A\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8Ti\u0006$X-\u0003\u0003\u0002n\u0005=$\u0001E!qa2L7-\u0019;j_:\u001cF/\u0019;f\u0015\r\tI'\u0006\u0005\u0007\u0003g\u001a\u0002\u0019A4\u0002\u000bM$\u0018\r^3")
public class KubernetesApplicationOperation
implements ApplicationOperation,
Logging {
    private volatile KubernetesClient kubernetesClient;
    private JpsApplicationOperation jpsOperation;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    public static Enumeration.Value toApplicationState(String string) {
        return KubernetesApplicationOperation$.MODULE$.toApplicationState(string);
    }

    public static String LABEL_KYUUBI_UNIQUE_KEY() {
        return KubernetesApplicationOperation$.MODULE$.LABEL_KYUUBI_UNIQUE_KEY();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private KubernetesClient kubernetesClient() {
        return this.kubernetesClient;
    }

    private void kubernetesClient_$eq(KubernetesClient x$1) {
        this.kubernetesClient = x$1;
    }

    private JpsApplicationOperation jpsOperation() {
        return this.jpsOperation;
    }

    private void jpsOperation_$eq(JpsApplicationOperation x$1) {
        this.jpsOperation = x$1;
    }

    @Override
    public void initialize(KyuubiConf conf) {
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Start Initialize Kubernetes Client.");
        Option contextOpt = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.KUBERNETES_CONTEXT());
        if (contextOpt.isEmpty()) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Skip Initialize Kubernetes Client, because of Context not set.");
            return;
        }
        this.jpsOperation_$eq(new JpsApplicationOperation());
        this.jpsOperation().initialize(conf);
        this.kubernetesClient_$eq(this.liftedTree1$1(contextOpt));
    }

    @Override
    public boolean isSupported(Option<String> clusterManager) {
        return this.kubernetesClient() != null && clusterManager.nonEmpty() && ((String)clusterManager.get()).toLowerCase().startsWith("k8s");
    }

    @Override
    public Tuple2<Object, String> killApplicationByTag(String tag) {
        Tuple2 tuple2;
        if (this.kubernetesClient() != null) {
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Deleting application info from Kubernetes cluster by ").append(tag).append(" tag").toString());
            try {
                FilterWatchListDeletable<Pod, PodList> operation = this.findDriverPodByTag(tag);
                List podList = ((PodList)operation.list()).getItems();
                if (podList.size() == 0) {
                    return this.jpsOperation().killApplicationByTag(tag);
                }
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(operation.delete())), (Object)new StringBuilder(41).append("Operation of deleted appId: ").append(((Pod)podList.get(0)).getMetadata().getName()).append(" is completed").toString());
            }
            catch (Exception e) {
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(46).append("Failed to terminate application with ").append(tag).append(", due to ").append(e.getMessage()).toString());
            }
        } else {
            throw new IllegalStateException("Methods initialize and isSupported must be called ahead");
        }
        return tuple2;
    }

    @Override
    public ApplicationInfo getApplicationInfoByTag(String tag) {
        ApplicationInfo applicationInfo;
        block5: {
            if (this.kubernetesClient() != null) {
                this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Getting application info from Kubernetes cluster by ").append(tag).append(" tag").toString());
                try {
                    FilterWatchListDeletable<Pod, PodList> operation = this.findDriverPodByTag(tag);
                    List podList = ((PodList)operation.list()).getItems();
                    if (podList.size() != 0) {
                        Pod pod = (Pod)podList.get(0);
                        String x$1 = pod.getMetadata().getUid();
                        String x$2 = pod.getMetadata().getName();
                        Enumeration.Value x$3 = KubernetesApplicationOperation$.MODULE$.toApplicationState(pod.getStatus().getPhase());
                        Option x$4 = Option$.MODULE$.apply((Object)pod.getStatus().getReason());
                        Option<String> x$5 = ApplicationInfo$.MODULE$.apply$default$4();
                        ApplicationInfo info = new ApplicationInfo(x$1, x$2, x$3, x$5, (Option<String>)x$4);
                        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Successfully got application info by ").append(tag).append(": ").append(info).toString());
                        applicationInfo = info;
                        break block5;
                    }
                    applicationInfo = this.jpsOperation().getApplicationInfoByTag(tag);
                }
                catch (Exception e) {
                    this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Failed to get application with ").append(tag).append(", due to ").append(e.getMessage()).toString());
                    applicationInfo = new ApplicationInfo(null, null, ApplicationState$.MODULE$.NOT_FOUND(), ApplicationInfo$.MODULE$.apply$default$4(), ApplicationInfo$.MODULE$.apply$default$5());
                }
            } else {
                throw new IllegalStateException("Methods initialize and isSupported must be called ahead");
            }
        }
        return applicationInfo;
    }

    /*
     * WARNING - void declaration
     */
    private FilterWatchListDeletable<Pod, PodList> findDriverPodByTag(String tag) {
        void var2_2;
        block0: {
            FilterWatchListDeletable operation = (FilterWatchListDeletable)this.kubernetesClient().pods().withLabel(KubernetesApplicationOperation$.MODULE$.LABEL_KYUUBI_UNIQUE_KEY(), tag);
            int size = ((PodList)operation.list()).getItems().size();
            if (size == 1) break block0;
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Get Tag: ").append(tag).append(" Driver Pod In Kubernetes size: ").append(size).append(", we expect 1").toString());
        }
        return var2_2;
    }

    @Override
    public void stop() {
        block2: {
            if (this.kubernetesClient() == null) break block2;
            try {
                this.kubernetesClient().close();
            }
            catch (Exception e) {
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> e.getMessage());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ KubernetesClient liftedTree1$1(Option contextOpt$1) {
        KubernetesClient kubernetesClient;
        try {
            void var2_2;
            DefaultKubernetesClient client = new DefaultKubernetesClient(Config.autoConfigure((String)((String)contextOpt$1.get())));
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Initialized Kubernetes Client connect to: ").append(client.getMasterUrl()).toString());
            kubernetesClient = var2_2;
        }
        catch (KubernetesClientException e) {
            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Fail to init KubernetesClient for KubernetesApplicationOperation", e);
            kubernetesClient = null;
        }
        return kubernetesClient;
    }

    public KubernetesApplicationOperation() {
        Logging.$init$((Logging)this);
    }
}

