/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.AuthTypes$;
import org.apache.kyuubi.ha.client.ServiceDiscovery$;
import org.apache.kyuubi.package$;
import org.apache.kyuubi.server.KyuubiServer;
import org.apache.kyuubi.service.ServiceState$;
import org.apache.kyuubi.util.KyuubiHadoopUtils$;
import org.apache.kyuubi.util.SignalRegister$;
import org.apache.kyuubi.zookeeper.EmbeddedZookeeper;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.util.Properties$;

public final class KyuubiServer$
implements Logging {
    public static KyuubiServer$ MODULE$;
    private final EmbeddedZookeeper zkServer;
    private KyuubiServer kyuubiServer;
    private volatile Configuration hadoopConf;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        new KyuubiServer$();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private EmbeddedZookeeper zkServer() {
        return this.zkServer;
    }

    public KyuubiServer kyuubiServer() {
        return this.kyuubiServer;
    }

    public void kyuubiServer_$eq(KyuubiServer x$1) {
        this.kyuubiServer = x$1;
    }

    public Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public void hadoopConf_$eq(Configuration x$1) {
        this.hadoopConf = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public KyuubiServer startServer(KyuubiConf conf) {
        void var3_6;
        KyuubiServer kyuubiServer;
        BoxedUnit boxedUnit;
        this.hadoopConf_$eq(KyuubiHadoopUtils$.MODULE$.newHadoopConf(conf, KyuubiHadoopUtils$.MODULE$.newHadoopConf$default$2()));
        if (!ServiceDiscovery$.MODULE$.supportServiceDiscovery(conf)) {
            this.zkServer().initialize(conf);
            this.zkServer().start();
            conf.set(HighAvailabilityConf$.MODULE$.HA_ADDRESSES(), (Object)this.zkServer().getConnectString());
            boxedUnit = conf.set(HighAvailabilityConf$.MODULE$.HA_ZK_AUTH_TYPE(), (Object)AuthTypes$.MODULE$.NONE().toString());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Option option = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_NAME());
        if (option instanceof Some) {
            Some some = (Some)option;
            String s = (String)some.value();
            kyuubiServer = new KyuubiServer(s);
        } else {
            kyuubiServer = new KyuubiServer();
        }
        KyuubiServer server = kyuubiServer;
        try {
            server.initialize(conf);
        }
        catch (Exception e) {
            Enumeration.Value value = this.zkServer().getServiceState();
            Enumeration.Value value2 = ServiceState$.MODULE$.STARTED();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                this.zkServer().stop();
            }
            throw e;
        }
        server.start();
        Utils$.MODULE$.addShutdownHook(() -> server.stop(), Utils$.MODULE$.SERVER_SHUTDOWN_PRIORITY());
        return var3_6;
    }

    public void main(String[] args) {
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("\n        |                  Welcome to\n        |  __  __                           __\n        | /\\ \\/\\ \\                         /\\ \\      __\n        | \\ \\ \\/'/'  __  __  __  __  __  __\\ \\ \\____/\\_\\\n        |  \\ \\ , <  /\\ \\/\\ \\/\\ \\/\\ \\/\\ \\/\\ \\\\ \\ '__`\\/\\ \\\n        |   \\ \\ \\\\`\\\\ \\ \\_\\ \\ \\ \\_\\ \\ \\ \\_\\ \\\\ \\ \\L\\ \\ \\ \\\n        |    \\ \\_\\ \\_\\/`____ \\ \\____/\\ \\____/ \\ \\_,__/\\ \\_\\\n        |     \\/_/\\/_/`/___/> \\/___/  \\/___/   \\/___/  \\/_/\n        |                /\\___/\n        |                \\/__/\n       ")).stripMargin());
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(93).append("Version: ").append(package$.MODULE$.KYUUBI_VERSION()).append(", Revision: ").append(package$.MODULE$.REVISION()).append(", Branch: ").append(package$.MODULE$.BRANCH()).append(",").append(" Java: ").append(package$.MODULE$.JAVA_COMPILE_VERSION()).append(", Scala: ").append(package$.MODULE$.SCALA_COMPILE_VERSION()).append(",").append(" Spark: ").append(package$.MODULE$.SPARK_COMPILE_VERSION()).append(", Hadoop: ").append(package$.MODULE$.HADOOP_COMPILE_VERSION()).append(",").append(" Hive: ").append(package$.MODULE$.HIVE_COMPILE_VERSION()).append(", Flink: ").append(package$.MODULE$.FLINK_COMPILE_VERSION()).append(",").append(" Trino: ").append(package$.MODULE$.TRINO_COMPILE_VERSION()).toString());
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Using Scala ").append(Properties$.MODULE$.versionString()).append(", ").append(Properties$.MODULE$.javaVmName()).append(",").append(" ").append(Properties$.MODULE$.javaVersion()).toString());
        SignalRegister$.MODULE$.registerLogger(this.logger());
        KyuubiConf conf = new KyuubiConf(KyuubiConf$.MODULE$.$lessinit$greater$default$1()).loadFileDefaults();
        UserGroupInformation.setConfiguration((Configuration)KyuubiHadoopUtils$.MODULE$.newHadoopConf(conf, KyuubiHadoopUtils$.MODULE$.newHadoopConf$default$2()));
        this.startServer(conf);
    }

    public Configuration getHadoopConf() {
        return this.hadoopConf();
    }

    public synchronized void reloadHadoopConf() {
        Configuration _hadoopConf = KyuubiHadoopUtils$.MODULE$.newHadoopConf(new KyuubiConf(KyuubiConf$.MODULE$.$lessinit$greater$default$1()).loadFileDefaults(), KyuubiHadoopUtils$.MODULE$.newHadoopConf$default$2());
        this.hadoopConf_$eq(_hadoopConf);
    }

    private KyuubiServer$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.zkServer = new EmbeddedZookeeper();
    }
}

