/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.api.v1;

import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.hive.service.rpc.thrift.TColumn;
import org.apache.hive.service.rpc.thrift.TRowSet;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.client.api.v1.dto.Batch;
import org.apache.kyuubi.client.api.v1.dto.BatchRequest;
import org.apache.kyuubi.client.api.v1.dto.CloseBatchResponse;
import org.apache.kyuubi.client.api.v1.dto.GetBatchesResponse;
import org.apache.kyuubi.client.api.v1.dto.OperationLog;
import org.apache.kyuubi.client.exception.KyuubiRestException;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.ApplicationInfo;
import org.apache.kyuubi.operation.BatchJobSubmission;
import org.apache.kyuubi.operation.BatchJobSubmission$;
import org.apache.kyuubi.operation.FetchOrientation$;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.operation.OperationStatus;
import org.apache.kyuubi.server.KyuubiRestFrontendService;
import org.apache.kyuubi.server.api.ApiRequestContext;
import org.apache.kyuubi.server.api.v1.BatchesResource$;
import org.apache.kyuubi.server.api.v1.InternalRestClient;
import org.apache.kyuubi.server.metadata.MetadataManager$;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.metadata.api.Metadata$;
import org.apache.kyuubi.service.authentication.KyuubiAuthenticationFactory$;
import org.apache.kyuubi.session.KyuubiBatchSessionImpl;
import org.apache.kyuubi.session.KyuubiSessionManager;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionHandle$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.MapLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

@Tag(name="Batch")
@Produces(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\teh!B\r\u001b\u0001i1\u0003\"B\u001b\u0001\t\u00039\u0004b\u0002\u001e\u0001\u0005\u0004%Ia\u000f\u0005\u0007)\u0002\u0001\u000b\u0011\u0002\u001f\t\u0011U\u0003\u0001R1A\u0005\nYC\u0001B\u0017\u0001\t\u0006\u0004%IA\u0016\u0005\u00067\u0002!I\u0001\u0018\u0005\u0006?\u0002!I\u0001\u0019\u0005\u0006O\u0002!I\u0001\u001b\u0005\u0006O\u0002!Ia\u001e\u0005\b\u0003/\u0001A\u0011BA\r\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAq!!+\u0001\t\u0003\tY\u000bC\u0004\u0002X\u0002!\t!!7\t\u000f\te\u0002\u0001\"\u0001\u0003<!9!\u0011\u000f\u0001\u0005\u0002\tMta\u0002B`5!\u0005!\u0011\u0019\u0004\u00073iA\tAa1\t\rU\nB\u0011\u0001Bc\u0011%\u00119-\u0005b\u0001\n\u0003\u0011I\r\u0003\u0005\u0003bF\u0001\u000b\u0011\u0002Bf\u0011%\u0011\u0019/\u0005b\u0001\n\u0003\u0011I\r\u0003\u0005\u0003fF\u0001\u000b\u0011\u0002Bf\u0011\u001d\u00119/\u0005C\u0001\u0005SDqAa=\u0012\t\u0003\u0011)PA\bCCR\u001c\u0007.Z:SKN|WO]2f\u0015\tYB$\u0001\u0002wc)\u0011QDH\u0001\u0004CBL'BA\u0010!\u0003\u0019\u0019XM\u001d<fe*\u0011\u0011EI\u0001\u0007Wf,XOY5\u000b\u0005\r\"\u0013AB1qC\u000eDWMC\u0001&\u0003\ry'oZ\n\u0005\u0001\u001dj\u0013\u0007\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0004B]f\u0014VM\u001a\t\u0003]=j\u0011\u0001H\u0005\u0003aq\u0011\u0011#\u00119j%\u0016\fX/Z:u\u0007>tG/\u001a=u!\t\u00114'D\u0001!\u0013\t!\u0004EA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012\u0001\u000f\t\u0003s\u0001i\u0011AG\u0001\u0014S:$XM\u001d8bYJ+7\u000f^\"mS\u0016tGo]\u000b\u0002yA!Q\b\u0012$R\u001b\u0005q$BA A\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u0003\n\u000bA!\u001e;jY*\t1)\u0001\u0003kCZ\f\u0017BA#?\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0003\u000f:s!\u0001\u0013'\u0011\u0005%KS\"\u0001&\u000b\u0005-3\u0014A\u0002\u001fs_>$h(\u0003\u0002NS\u00051\u0001K]3eK\u001aL!a\u0014)\u0003\rM#(/\u001b8h\u0015\ti\u0015\u0006\u0005\u0002:%&\u00111K\u0007\u0002\u0013\u0013:$XM\u001d8bYJ+7\u000f^\"mS\u0016tG/\u0001\u000bj]R,'O\\1m%\u0016\u001cHo\u00117jK:$8\u000fI\u0001\u0016S:$XM\u001d8bYN{7m[3u)&lWm\\;u+\u00059\u0006C\u0001\u0015Y\u0013\tI\u0016F\u0001\u0003M_:<\u0017AF5oi\u0016\u0014h.\u00197D_:tWm\u0019;US6,w.\u001e;\u0002+\u001d,G/\u00138uKJt\u0017\r\u001c*fgR\u001cE.[3oiR\u0011\u0011+\u0018\u0005\u0006=\u001a\u0001\rAR\u0001\u000fWf,XOY5J]N$\u0018M\\2f\u00039\u0019Xm]:j_:l\u0015M\\1hKJ,\u0012!\u0019\t\u0003E\u0016l\u0011a\u0019\u0006\u0003I\u0002\nqa]3tg&|g.\u0003\u0002gG\n!2*_;vE&\u001cVm]:j_:l\u0015M\\1hKJ\f!BY;jY\u0012\u0014\u0015\r^2i)\tI7\u000f\u0005\u0002kc6\t1N\u0003\u0002m[\u0006\u0019A\r^8\u000b\u0005mq'BA\u000fp\u0015\t\u0001\b%\u0001\u0004dY&,g\u000e^\u0005\u0003e.\u0014QAQ1uG\"DQ\u0001\u001a\u0005A\u0002Q\u0004\"AY;\n\u0005Y\u001c'AF&zkV\u0014\u0017NQ1uG\"\u001cVm]:j_:LU\u000e\u001d7\u0015\t%D\u0018\u0011\u0001\u0005\u0006s&\u0001\rA_\u0001\t[\u0016$\u0018\rZ1uCB\u00111P`\u0007\u0002y*\u0011Q$ \u0006\u0003szI!a ?\u0003\u00115+G/\u00193bi\u0006Dq!a\u0001\n\u0001\u0004\t)!\u0001\bcCR\u001c\u0007.\u00119q'R\fG/^:\u0011\u000b!\n9!a\u0003\n\u0007\u0005%\u0011F\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011\u0003\u0011\u0002\r\u0015tw-\u001b8f\u0013\u0011\t)\"a\u0004\u0003\u001f\u0005\u0003\b\u000f\\5dCRLwN\\%oM>\f1CZ8s[\u0006$8+Z:tS>t\u0007*\u00198eY\u0016$B!a\u0007\u0002\"A\u0019!-!\b\n\u0007\u0005}1MA\u0007TKN\u001c\u0018n\u001c8IC:$G.\u001a\u0005\u0007\u0003GQ\u0001\u0019\u0001$\u0002!M,7o]5p]\"\u000bg\u000e\u001a7f'R\u0014\u0018\u0001E8qK:\u0014\u0015\r^2i'\u0016\u001c8/[8o)\rI\u0017\u0011\u0006\u0005\b\u0003WY\u0001\u0019AA\u0017\u0003\u001d\u0011X-];fgR\u00042A[A\u0018\u0013\r\t\td\u001b\u0002\r\u0005\u0006$8\r\u001b*fcV,7\u000f\u001e\u0015\b\u0017\u0005U\u0012\u0011JA&!\u0011\t9$!\u0012\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\t!A]:\u000b\t\u0005}\u0012\u0011I\u0001\u0003oNT!!a\u0011\u0002\u000b)\fg/\u0019=\n\t\u0005\u001d\u0013\u0011\b\u0002\t\u0007>t7/^7fg\u0006)a/\u00197vK2\u0012\u0011QJ\u0011\u0003\u0003\u001f\n\u0001#\u00199qY&\u001c\u0017\r^5p]>R7o\u001c8)\u0007-\t\u0019\u0006\u0005\u0003\u00028\u0005U\u0013\u0002BA,\u0003s\u0011A\u0001U(T)\"z1\"a\u0017\u0002|\u0005u\u0014\u0011QAB\u0003G\u000b)\u000b\u0005\u0003\u0002^\u0005]TBAA0\u0015\u0011\t\t'a\u0019\u0002\u0013I,7\u000f]8og\u0016\u001c(\u0002BA3\u0003O\n1\"\u00198o_R\fG/[8og*!\u0011\u0011NA6\u0003\ry\u0017m\u001d\u0006\u0005\u0003[\ny'\u0001\u0002wg)!\u0011\u0011OA:\u0003\u001d\u0019x/Y4hKJT!!!\u001e\u0002\u0005%|\u0017\u0002BA=\u0003?\u00121\"\u00119j%\u0016\u001c\bo\u001c8tK\u0006a!/Z:q_:\u001cXmQ8eK\u0006\u0012\u0011qP\u0001\u0004eA\u0002\u0014aB2p]R,g\u000e\u001e\u0017\u0003\u0003\u000b[#\"a\"\u0002\u0014\u00065\u0013QSAL!\u0011\tI)a$\u000e\u0005\u0005-%\u0002BAG\u0003G\nQ!\\3eS\u0006LA!!%\u0002\f\n91i\u001c8uK:$\u0018!C7fI&\fG+\u001f9f\u0003\u0019\u00198\r[3nC.2\u0011\u0011TAP\u0003C\u0003B!!#\u0002\u001c&!\u0011QTAF\u0005\u0019\u00196\r[3nC\u0006q\u0011.\u001c9mK6,g\u000e^1uS>t7%A5\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u0011\u0003\u0003O\u000bqd\u0019:fCR,\u0007%\u00198eA=\u0004XM\u001c\u0011bA\t\fGo\u00195!g\u0016\u001c8/[8o\u0003%\u0011\u0017\r^2i\u0013:4w\u000eF\u0002j\u0003[Ca!a,\r\u0001\u00041\u0015a\u00022bi\u000eD\u0017\n\u001a\u0015\t\u0003[\u000b\u0019,!\u0013\u0002:B!\u0011qGA[\u0013\u0011\t9,!\u000f\u0003\u0013A\u000bG\u000f\u001b)be\u0006l\u0017EAAXQ\u001da\u0011QXA%\u0003\u0007\u0004B!a\u000e\u0002@&!\u0011\u0011YA\u001d\u0005\u0011\u0001\u0016\r\u001e5\"\u0005\u0005\u0015\u0017!C>cCR\u001c\u0007.\u00133~Q\ra\u0011\u0011\u001a\t\u0005\u0003o\tY-\u0003\u0003\u0002N\u0006e\"aA$F)\"zA\"a\u0017\u0002|\u0005u\u0014\u0011QAi\u0003G\u000b\u0019\u000e\f\u0002\u0002\u0006\u0006\u0012\u0011Q[\u0001 O\u0016$\b\u0005\u001e5fA\t\fGo\u00195!S:4w\u000e\t<jC\u0002\u0012\u0017\r^2iA%$\u0017\u0001E4fi\n\u000bGo\u00195J]\u001a|G*[:u)A\tY.!9\u0002p\u0006]\u0018q B\u0004\u0005\u001f\u0011i\u0002E\u0002k\u0003;L1!a8l\u0005I9U\r\u001e\"bi\u000eDWm\u001d*fgB|gn]3\t\r\u0005\rX\u00021\u0001G\u0003%\u0011\u0017\r^2i)f\u0004X\r\u000b\u0005\u0002b\u0006\u001d\u0018\u0011JAw!\u0011\t9$!;\n\t\u0005-\u0018\u0011\b\u0002\u000b#V,'/\u001f)be\u0006l\u0017EAAr\u0011\u0019\t\t0\u0004a\u0001\r\u0006Q!-\u0019;dQN#\u0018\r^3)\u0011\u0005=\u0018q]A%\u0003k\f#!!=\t\r\u0005eX\u00021\u0001G\u0003%\u0011\u0017\r^2i+N,'\u000f\u000b\u0005\u0002x\u0006\u001d\u0018\u0011JA\u007fC\t\tI\u0010\u0003\u0004\u0003\u00025\u0001\raV\u0001\u000bGJ,\u0017\r^3US6,\u0007\u0006CA\u0000\u0003O\fIE!\u0002\"\u0005\t\u0005\u0001B\u0002B\u0005\u001b\u0001\u0007q+A\u0004f]\u0012$\u0016.\\3)\u0011\t\u001d\u0011q]A%\u0005\u001b\t#A!\u0003\t\u000f\tEQ\u00021\u0001\u0003\u0014\u0005!aM]8n!\rA#QC\u0005\u0004\u0005/I#aA%oi\"B!qBAt\u0003\u0013\u0012Y\"\t\u0002\u0003\u0012!9!qD\u0007A\u0002\tM\u0011\u0001B:ju\u0016D\u0003B!\b\u0002h\u0006%#1E\u0011\u0003\u0005?As!DA\u001b\u0003\u0013\u00129\u0003\f\u0002\u0002N!\u001aQ\"!3)\u001f5\tY&a\u001f\u0002~\u0005\u0005%QFAR\u0005ka#Aa\f,\u0015\u0005\u001d\u00151SA'\u0003+\u0013\td\u000b\u0004\u0002\u001a\u0006}%1G\u0012\u0003\u00037\f#Aa\u000e\u00027I,G/\u001e:og\u0002\"\b.\u001a\u0011cCR\u001c\u0007\u000eI:fgNLwN\\:/\u0003A9W\r\u001e\"bi\u000eDGj\\2bY2{w\r\u0006\u0005\u0003>\t\r#q\tB,!\rQ'qH\u0005\u0004\u0005\u0003Z'\u0001D(qKJ\fG/[8o\u0019><\u0007BBAX\u001d\u0001\u0007a\t\u000b\u0005\u0003D\u0005M\u0016\u0011JA]\u0011\u001d\u0011\tB\u0004a\u0001\u0005'A\u0003Ba\u0012\u0003L\u0005%#\u0011\u000b\t\u0005\u0003o\u0011i%\u0003\u0003\u0003P\u0005e\"\u0001\u0004#fM\u0006,H\u000e\u001e,bYV,\u0017E\u0001B*\u0003\ti\u0013\u0007\u000b\u0005\u0003H\u0005\u001d\u0018\u0011\nB\u000e\u0011\u001d\u0011yB\u0004a\u0001\u0005'A\u0003Ba\u0016\u0002h\u0006%#1\u0005\u0015\b\u001d\u0005u\u0016\u0011\nB/C\t\u0011y&\u0001\n|E\u0006$8\r[%e{>bwnY1m\u0019><\u0007f\u0001\b\u0002J\"za\"a\u0017\u0002|\u0005u\u0014\u0011\u0011B3\u0003G\u0013i\u0007\f\u0002\u0003h-R\u0011qQAJ\u0003\u001b\n)J!\u001b,\r\u0005e\u0015q\u0014B6G\t\u0011i$\t\u0002\u0003p\u00059s-\u001a;!i\",\u0007\u0005\\8dC2\u0004Cn\\4!Y&tWm\u001d\u0011ge>l\u0007\u0005\u001e5jg\u0002\u0012\u0017\r^2i\u0003E\u0019Gn\\:f\u0005\u0006$8\r[*fgNLwN\u001c\u000b\u0007\u0005k\u0012YHa \u0011\u0007)\u00149(C\u0002\u0003z-\u0014!c\u00117pg\u0016\u0014\u0015\r^2i%\u0016\u001c\bo\u001c8tK\"1\u0011qV\bA\u0002\u0019C\u0003Ba\u001f\u00024\u0006%\u0013\u0011\u0018\u0005\u0007\u0005\u0003{\u0001\u0019\u0001$\u0002\u0019!\u001c(\u0007\u0015:pqf,6/\u001a:)\u0011\t}\u0014q]A%\u0005\u000b\u000b#Aa\"\u0002/!Lg/\u001a\u0018tKJ4XM\u001d\u001a/aJ|\u00070\u001f\u0018vg\u0016\u0014\bfB\b\u0002>\u0006%\u00131\u0019\u0015\u0004\u001f\t5\u0005\u0003BA\u001c\u0005\u001fKAA!%\u0002:\t1A)\u0012'F)\u0016CsbDA.\u0003w\ni(!!\u0003\u0016\u0006\r&Q\u0014\u0017\u0003\u0005/[#\"a\"\u0002\u0014\u00065\u0013Q\u0013BMW\u0019\tI*a(\u0003\u001c\u000e\u0012!QO\u0011\u0003\u0005?\u000b\u0001e\u00197pg\u0016\u0004\u0013M\u001c3!G\u0006t7-\u001a7!C\u0002\u0012\u0017\r^2iAM,7o]5p]\":\u0001Aa)\u0002J\t%\u0006\u0003BA\u001c\u0005KKAAa*\u0002:\tA\u0001K]8ek\u000e,7\u000f\f\u0002\u0002N!:\u0001A!,\u0003:\nm\u0006\u0003\u0002BX\u0005kk!A!-\u000b\t\tM\u00161M\u0001\u0005i\u0006<7/\u0003\u0003\u00038\nE&a\u0001+bO\u0006!a.Y7fC\t\u0011i,A\u0003CCR\u001c\u0007.A\bCCR\u001c\u0007.Z:SKN|WO]2f!\tI\u0014c\u0005\u0002\u0012OQ\u0011!\u0011Y\u0001\u0016'V\u0003\u0006k\u0014*U\u000b\u0012{&)\u0011+D\u0011~#\u0016\fU#T+\t\u0011Y\r\u0005\u0004\u0003N\nM'q[\u0007\u0003\u0005\u001fT1A!5*\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005+\u0014yMA\u0002TKF\u0004BA!7\u0003`6\u0011!1\u001c\u0006\u0004\u0005;\u0014\u0015\u0001\u00027b]\u001eL1a\u0014Bn\u0003Y\u0019V\u000b\u0015)P%R+Ei\u0018\"B)\u000eCu\fV-Q\u000bN\u0003\u0013A\u0005,B\u0019&#uLQ!U\u0007\"{6\u000bV!U\u000bN\u000b1CV!M\u0013\u0012{&)\u0011+D\u0011~\u001bF+\u0011+F'\u0002\n!c];qa>\u0014H/\u001a3CCR\u001c\u0007\u000eV=qKR!!1\u001eBy!\rA#Q^\u0005\u0004\u0005_L#a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003G<\u0002\u0019\u0001$\u0002\u001fY\fG.\u001b3CCR\u001c\u0007n\u0015;bi\u0016$BAa;\u0003x\"1\u0011\u0011\u001f\rA\u0002\u0019\u0003")
public class BatchesResource
implements ApiRequestContext,
Logging {
    private long internalSocketTimeout;
    private long internalConnectTimeout;
    private final ConcurrentHashMap<String, InternalRestClient> internalRestClients;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;
    private volatile byte bitmap$0;

    public static boolean validBatchState(String string) {
        return BatchesResource$.MODULE$.validBatchState(string);
    }

    public static boolean supportedBatchType(String string) {
        return BatchesResource$.MODULE$.supportedBatchType(string);
    }

    public static Seq<String> VALID_BATCH_STATES() {
        return BatchesResource$.MODULE$.VALID_BATCH_STATES();
    }

    public static Seq<String> SUPPORTED_BATCH_TYPES() {
        return BatchesResource$.MODULE$.SUPPORTED_BATCH_TYPES();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public final KyuubiRestFrontendService fe() {
        return ApiRequestContext.fe$(this);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    private ConcurrentHashMap<String, InternalRestClient> internalRestClients() {
        return this.internalRestClients;
    }

    private long internalSocketTimeout$lzycompute() {
        BatchesResource batchesResource = this;
        synchronized (batchesResource) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.internalSocketTimeout = BoxesRunTime.unboxToLong((Object)this.fe().getConf().get(KyuubiConf$.MODULE$.BATCH_INTERNAL_REST_CLIENT_SOCKET_TIMEOUT()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.internalSocketTimeout;
    }

    private long internalSocketTimeout() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.internalSocketTimeout$lzycompute() : this.internalSocketTimeout;
    }

    private long internalConnectTimeout$lzycompute() {
        BatchesResource batchesResource = this;
        synchronized (batchesResource) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.internalConnectTimeout = BoxesRunTime.unboxToLong((Object)this.fe().getConf().get(KyuubiConf$.MODULE$.BATCH_INTERNAL_REST_CLIENT_CONNECT_TIMEOUT()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.internalConnectTimeout;
    }

    private long internalConnectTimeout() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.internalConnectTimeout$lzycompute() : this.internalConnectTimeout;
    }

    private InternalRestClient getInternalRestClient(String kyuubiInstance2) {
        return this.internalRestClients().computeIfAbsent(kyuubiInstance2, kyuubiInstance -> new InternalRestClient((String)kyuubiInstance, (int)this.internalSocketTimeout(), (int)this.internalConnectTimeout()));
    }

    private KyuubiSessionManager sessionManager() {
        return (KyuubiSessionManager)this.fe().be().sessionManager();
    }

    private Batch buildBatch(KyuubiBatchSessionImpl session) {
        BatchJobSubmission batchOp = session.batchJobSubmissionOp();
        OperationStatus batchOpStatus = batchOp.getStatus();
        Option<ApplicationInfo> batchAppStatus = batchOp.currentApplicationInfo();
        String name = (String)Option$.MODULE$.apply((Object)batchOp.batchName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (String)batchAppStatus.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name()).orNull(Predef$.MODULE$.$conforms()));
        String appId = null;
        String appUrl = null;
        String appState = null;
        String appDiagnostic = null;
        if (batchAppStatus.nonEmpty()) {
            appId = ((ApplicationInfo)batchAppStatus.get()).id();
            appUrl = (String)((ApplicationInfo)batchAppStatus.get()).url().orNull(Predef$.MODULE$.$conforms());
            appState = ((ApplicationInfo)batchAppStatus.get()).state().toString();
            appDiagnostic = (String)((ApplicationInfo)batchAppStatus.get()).error().orNull(Predef$.MODULE$.$conforms());
        } else {
            Metadata metadata = this.sessionManager().getBatchMetadata(batchOp.batchId());
            appId = metadata.engineId();
            appUrl = metadata.engineUrl();
            appState = metadata.engineState();
            appDiagnostic = (String)metadata.engineError().orNull(Predef$.MODULE$.$conforms());
        }
        return new Batch(batchOp.batchId(), session.user(), batchOp.batchType(), name, appId, appUrl, appState, appDiagnostic, this.fe().connectionUrl(), batchOpStatus.state().toString(), session.createTime(), batchOpStatus.completed());
    }

    private Batch buildBatch(Metadata metadata, Option<ApplicationInfo> batchAppStatus) {
        return (Batch)batchAppStatus.map((Function1 & Serializable & scala.Serializable)appStatus -> {
            String currentBatchState = BatchJobSubmission$.MODULE$.applicationFailed(batchAppStatus) ? OperationState$.MODULE$.ERROR().toString() : (BatchJobSubmission$.MODULE$.applicationTerminated(batchAppStatus) ? OperationState$.MODULE$.FINISHED().toString() : (batchAppStatus.isDefined() ? OperationState$.MODULE$.RUNNING().toString() : metadata.state()));
            String name = (String)Option$.MODULE$.apply((Object)metadata.requestName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> appStatus.name());
            String appId = appStatus.id();
            String appUrl = (String)appStatus.url().orNull(Predef$.MODULE$.$conforms());
            String appState = appStatus.state().toString();
            String appDiagnostic = (String)appStatus.error().orNull(Predef$.MODULE$.$conforms());
            return new Batch(metadata.identifier(), metadata.username(), metadata.engineType(), name, appId, appUrl, appState, appDiagnostic, metadata.kyuubiInstance(), currentBatchState, metadata.createTime(), metadata.endTime());
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> MetadataManager$.MODULE$.buildBatch(metadata));
    }

    private SessionHandle formatSessionHandle(String sessionHandleStr) {
        SessionHandle sessionHandle;
        try {
            sessionHandle = SessionHandle$.MODULE$.fromUUID(sessionHandleStr);
        }
        catch (IllegalArgumentException e) {
            throw new NotFoundException(new StringBuilder(17).append("Invalid batchId: ").append(sessionHandleStr).toString(), (Throwable)e);
        }
        return sessionHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=Batch.class))}, description="create and open a batch session")
    @POST
    @Consumes(value={"application/json"})
    public Batch openBatchSession(BatchRequest request) {
        Predef$.MODULE$.require(BatchesResource$.MODULE$.supportedBatchType(request.getBatchType()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append(request.getBatchType()).append(" is not in the supported list: ").append(BatchesResource$.MODULE$.SUPPORTED_BATCH_TYPES()).append("}").toString());
        Predef$.MODULE$.require(request.getResource() != null, (Function0 & Serializable & scala.Serializable)() -> "resource is a required parameter");
        Predef$.MODULE$.require(request.getClassName() != null, (Function0 & Serializable & scala.Serializable)() -> "classname is a required parameter");
        request.setBatchType(request.getBatchType().toUpperCase(Locale.ROOT));
        String userName = this.fe().getUserName((scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.getConf()).asScala()).toMap(Predef$.MODULE$.$conforms()));
        String ipAddress = this.fe().getIpAddress();
        request.setConf((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.getConf()).asScala()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.client.ipAddress"), (Object)ipAddress)})))).asJava());
        SessionHandle sessionHandle = this.sessionManager().openBatchSession(userName, "anonymous", ipAddress, (scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.getConf()).asScala()).toMap(Predef$.MODULE$.$conforms()), request);
        return this.buildBatch(this.sessionManager().getBatchSessionImpl(sessionHandle));
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=Batch.class))}, description="get the batch info via batch id")
    @GET
    @Path(value="{batchId}")
    public Batch batchInfo(@PathParam(value="batchId") String batchId) {
        String userName = this.fe().getUserName((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        SessionHandle sessionHandle = this.formatSessionHandle(batchId);
        return (Batch)Option$.MODULE$.apply((Object)this.sessionManager().getBatchSessionImpl(sessionHandle)).map((Function1 & Serializable & scala.Serializable)batchSession -> this.buildBatch((KyuubiBatchSessionImpl)((Object)batchSession))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Batch)Option$.MODULE$.apply((Object)this.sessionManager().getBatchMetadata(batchId)).map((Function1 & Serializable & scala.Serializable)metadata -> {
            Batch batch;
            block5: {
                block4: {
                    if (OperationState$.MODULE$.isTerminal(OperationState$.MODULE$.withName(metadata.state()))) break block4;
                    String string = metadata.kyuubiInstance();
                    String string2 = this.fe().connectionUrl();
                    if (string != null ? !string.equals(string2) : string2 != null) break block5;
                }
                batch = MetadataManager$.MODULE$.buildBatch((Metadata)metadata);
                return batch;
            }
            InternalRestClient internalRestClient = this.getInternalRestClient(metadata.kyuubiInstance());
            try {
                batch = internalRestClient.getBatch(userName, batchId);
                return batch;
            }
            catch (KyuubiRestException e) {
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Error redirecting get batch[").append(batchId).append("] to ").append(metadata.kyuubiInstance()).toString(), e);
                Option<ApplicationInfo> batchAppStatus = this.sessionManager().applicationManager().getApplicationInfo(metadata.clusterManager(), batchId);
                batch = this.buildBatch((Metadata)metadata, batchAppStatus);
                return batch;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Invalid batchId: ").append(batchId).toString());
            throw new NotFoundException(new StringBuilder(17).append("Invalid batchId: ").append(batchId).toString());
        }));
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetBatchesResponse.class))}, description="returns the batch sessions.")
    @GET
    @Consumes(value={"application/json"})
    public GetBatchesResponse getBatchInfoList(@QueryParam(value="batchType") String batchType, @QueryParam(value="batchState") String batchState, @QueryParam(value="batchUser") String batchUser, @QueryParam(value="createTime") long createTime, @QueryParam(value="endTime") long endTime, @QueryParam(value="from") int from, @QueryParam(value="size") int size) {
        Predef$.MODULE$.require(createTime >= 0L && endTime >= 0L && (endTime == 0L || createTime <= endTime), (Function0 & Serializable & scala.Serializable)() -> "Invalid time range");
        if (batchState != null) {
            Predef$.MODULE$.require(BatchesResource$.MODULE$.validBatchState(batchState), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("The valid batch state can be one of the following: ").append(BatchesResource$.MODULE$.VALID_BATCH_STATES().mkString(",")).toString());
        }
        Seq<Batch> batches = this.sessionManager().getBatchesFromMetadataStore(batchType, batchUser, batchState, createTime, endTime, from, size);
        return new GetBatchesResponse(from, batches.size(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(batches).asJava());
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationLog.class))}, description="get the local log lines from this batch")
    @GET
    @Path(value="{batchId}/localLog")
    public OperationLog getBatchLocalLog(@PathParam(value="batchId") String batchId, @QueryParam(value="from") @DefaultValue(value="-1") int from, @QueryParam(value="size") int size) {
        String userName = this.fe().getUserName((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        SessionHandle sessionHandle = this.formatSessionHandle(batchId);
        return (OperationLog)Option$.MODULE$.apply((Object)this.sessionManager().getBatchSessionImpl(sessionHandle)).map((Function1 & Serializable & scala.Serializable)batchSession -> {
            OperationLog operationLog;
            try {
                BatchJobSubmission submissionOp = batchSession.batchJobSubmissionOp();
                TRowSet rowSet = submissionOp.getOperationLogRowSet(FetchOrientation$.MODULE$.FETCH_NEXT(), from, size);
                Buffer logRowSet = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((TColumn)rowSet.getColumns().get(0)).getStringVal().getValues()).asScala();
                operationLog = new OperationLog((List)JavaConverters$.MODULE$.bufferAsJavaListConverter(logRowSet).asJava(), logRowSet.size());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    String errorMsg = new StringBuilder(41).append("Error getting operation log for batchId: ").append(batchId).toString();
                    this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                    throw new NotFoundException(errorMsg);
                }
                throw throwable;
            }
            return operationLog;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> (OperationLog)Option$.MODULE$.apply((Object)this.sessionManager().getBatchMetadata(batchId)).map((Function1 & Serializable & scala.Serializable)metadata -> {
            String string = this.fe().connectionUrl();
            String string2 = metadata.kyuubiInstance();
            if (!(string == null ? string2 != null : !string.equals(string2))) {
                throw new NotFoundException(new StringBuilder(30).append("No local log found for batch: ").append(batchId).toString());
            }
            InternalRestClient internalRestClient = this.getInternalRestClient(metadata.kyuubiInstance());
            return internalRestClient.getBatchLocalLog(userName, batchId, from, size);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Invalid batchId: ").append(batchId).toString());
            throw new NotFoundException(new StringBuilder(17).append("Invalid batchId: ").append(batchId).toString());
        }));
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=CloseBatchResponse.class))}, description="close and cancel a batch session")
    @DELETE
    @Path(value="{batchId}")
    public CloseBatchResponse closeBatchSession(@PathParam(value="batchId") String batchId, @QueryParam(value="hive.server2.proxy.user") String hs2ProxyUser) {
        SessionHandle sessionHandle = this.formatSessionHandle(batchId);
        scala.collection.immutable.Map sessionConf = (scala.collection.immutable.Map)Option$.MODULE$.apply((Object)hs2ProxyUser).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BatchesResource.$anonfun$closeBatchSession$1(x$2))).map((Function1 & Serializable & scala.Serializable)proxyUser -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KyuubiAuthenticationFactory$.MODULE$.HS2_PROXY_USER()), proxyUser)}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        ObjectRef userName = ObjectRef.create(null);
        try {
            userName.elem = this.fe().getUserName((scala.collection.immutable.Map<String, String>)sessionConf);
        }
        catch (Throwable t) {
            throw new NotAllowedException(t.getMessage(), new String[0]);
        }
        return (CloseBatchResponse)Option$.MODULE$.apply((Object)this.sessionManager().getBatchSessionImpl(sessionHandle)).map((Function1 & Serializable & scala.Serializable)batchSession -> {
            String string = (String)userName$3.elem;
            String string2 = batchSession.user();
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new NotAllowedException(new StringBuilder(47).append((String)userName$3.elem).append(" is not allowed to close the session belong to ").append(batchSession.user()).toString(), new String[0]);
            }
            this.sessionManager().closeSession(batchSession.handle());
            Tuple2<Object, String> tuple2 = batchSession.batchJobSubmissionOp().getKillMessage();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            boolean success = tuple2._1$mcZ$sp();
            String msg = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)success), (Object)msg);
            Tuple2 tuple23 = tuple22;
            boolean success2 = tuple23._1$mcZ$sp();
            String msg2 = (String)tuple23._2();
            return new CloseBatchResponse(success2, msg2);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> (CloseBatchResponse)Option$.MODULE$.apply((Object)this.sessionManager().getBatchMetadata(batchId)).map((Function1 & Serializable & scala.Serializable)metadata -> {
            CloseBatchResponse closeBatchResponse;
            block7: {
                block6: {
                    String string = (String)userName$3.elem;
                    String string2 = metadata.username();
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        throw new NotAllowedException(new StringBuilder(47).append((String)userName$3.elem).append(" is not allowed to close the session belong to ").append(metadata.username()).toString(), new String[0]);
                    }
                    if (OperationState$.MODULE$.isTerminal(OperationState$.MODULE$.withName(metadata.state()))) break block6;
                    String string3 = metadata.kyuubiInstance();
                    String string4 = this.fe().connectionUrl();
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block7;
                }
                closeBatchResponse = new CloseBatchResponse(false, new StringBuilder(32).append("The batch[").append(metadata).append("] has been terminated.").toString());
                return closeBatchResponse;
            }
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Redirecting delete batch[").append(batchId).append("] to ").append(metadata.kyuubiInstance()).toString());
            InternalRestClient internalRestClient = this.getInternalRestClient(metadata.kyuubiInstance());
            try {
                closeBatchResponse = internalRestClient.deleteBatch((String)userName$3.elem, batchId);
                return closeBatchResponse;
            }
            catch (KyuubiRestException e) {
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Error redirecting delete batch[").append(batchId).append("] to ").append(metadata.kyuubiInstance()).toString(), e);
                Tuple2<Object, String> appMgrKillResp = this.sessionManager().applicationManager().killApplication(metadata.clusterManager(), batchId);
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Marking batch[").append(batchId).append("/").append(metadata.kyuubiInstance()).append("] closed by ").append(this.fe().connectionUrl()).toString());
                String x$1 = batchId;
                boolean x$2 = true;
                Enumeration.Value x$3 = Metadata$.MODULE$.apply$default$2();
                String x$4 = Metadata$.MODULE$.apply$default$3();
                String x$5 = Metadata$.MODULE$.apply$default$4();
                String x$6 = Metadata$.MODULE$.apply$default$5();
                String x$7 = Metadata$.MODULE$.apply$default$6();
                String x$8 = Metadata$.MODULE$.apply$default$7();
                String x$9 = Metadata$.MODULE$.apply$default$8();
                String x$10 = Metadata$.MODULE$.apply$default$9();
                String x$11 = Metadata$.MODULE$.apply$default$10();
                scala.collection.immutable.Map<String, String> x$12 = Metadata$.MODULE$.apply$default$11();
                Seq<String> x$13 = Metadata$.MODULE$.apply$default$12();
                long x$14 = Metadata$.MODULE$.apply$default$13();
                String x$15 = Metadata$.MODULE$.apply$default$14();
                Option<String> x$16 = Metadata$.MODULE$.apply$default$15();
                String x$17 = Metadata$.MODULE$.apply$default$16();
                String x$18 = Metadata$.MODULE$.apply$default$17();
                String x$19 = Metadata$.MODULE$.apply$default$18();
                String x$20 = Metadata$.MODULE$.apply$default$19();
                Option<String> x$21 = Metadata$.MODULE$.apply$default$20();
                long x$22 = Metadata$.MODULE$.apply$default$21();
                this.sessionManager().updateMetadata(new Metadata(x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$2));
                if (appMgrKillResp._1$mcZ$sp()) {
                    closeBatchResponse = new CloseBatchResponse(appMgrKillResp._1$mcZ$sp(), (String)appMgrKillResp._2());
                    return closeBatchResponse;
                }
                closeBatchResponse = new CloseBatchResponse(false, Utils$.MODULE$.stringifyException((Throwable)e));
            }
            return closeBatchResponse;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Invalid batchId: ").append(batchId).toString());
            throw new NotFoundException(new StringBuilder(17).append("Invalid batchId: ").append(batchId).toString());
        }));
    }

    public static final /* synthetic */ boolean $anonfun$closeBatchSession$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public BatchesResource() {
        ApiRequestContext.$init$(this);
        Logging.$init$((Logging)this);
        this.internalRestClients = new ConcurrentHashMap();
    }
}

