/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.http.authentication;

import java.io.IOException;
import java.io.Serializable;
import javax.security.sasl.AuthenticationException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.server.http.authentication.AuthenticationFilter$;
import org.apache.kyuubi.server.http.authentication.AuthenticationHandler;
import org.apache.kyuubi.server.http.authentication.BasicAuthenticationHandler;
import org.apache.kyuubi.server.http.authentication.KerberosAuthenticationHandler;
import org.apache.kyuubi.server.http.authentication.KyuubiInternalAuthenticationHandler;
import org.apache.kyuubi.service.authentication.AuthTypes$;
import org.apache.kyuubi.service.authentication.InternalSecurityAccessor$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001\u0002\r\u001a\u0001\u0019B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\u0006\u0005\u0002!\ta\u0011\u0005\t\u000f\u0002\u0011\r\u0011\"\u0001\u001a\u0011\"1Q\f\u0001Q\u0001\n%CaA\u0018\u0001\u0005\u0002ey\u0006B\u00024\u0001\t\u0003yr\rC\u0003i\u0001\u0011\u0005\u0013\u000e\u0003\u0004p\u0001\u0011\u0005q\u0004\u001d\u0005\b\u0003\u0007\u0001A\u0011IA\u0003\u0011\u001d\t\u0019\u0001\u0001C\t\u0003KAa!a'\u0001\t\u0003:waBAO3!\u0005\u0011q\u0014\u0004\u00071eA\t!!)\t\r\tkA\u0011AAU\u0011%\tY+\u0004b\u0001\n\u000b\ti\u000b\u0003\u0005\u000266\u0001\u000bQBAX\u0011%\t9,\u0004b\u0001\n\u000b\ti\u000b\u0003\u0005\u0002:6\u0001\u000bQBAX\u0011%\tY,\u0004b\u0001\n\u000b\ti\u000b\u0003\u0005\u0002>6\u0001\u000bQBAX\u0011\u001d\ty,\u0004C\u0001\u0003#Bq!!1\u000e\t\u0003\t\t\u0006C\u0004\u0002D6!\t!!\u0015\u0003)\u0005+H\u000f[3oi&\u001c\u0017\r^5p]\u001aKG\u000e^3s\u0015\tQ2$\u0001\bbkRDWM\u001c;jG\u0006$\u0018n\u001c8\u000b\u0005qi\u0012\u0001\u00025uiBT!AH\u0010\u0002\rM,'O^3s\u0015\t\u0001\u0013%\u0001\u0004lsV,(-\u001b\u0006\u0003E\r\na!\u00199bG\",'\"\u0001\u0013\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u00019sf\u000e\t\u0003Q5j\u0011!\u000b\u0006\u0003U-\nA\u0001\\1oO*\tA&\u0001\u0003kCZ\f\u0017B\u0001\u0018*\u0005\u0019y%M[3diB\u0011\u0001'N\u0007\u0002c)\u0011!gM\u0001\bg\u0016\u0014h\u000f\\3u\u0015\u0005!\u0014!\u00026bm\u0006D\u0018B\u0001\u001c2\u0005\u00191\u0015\u000e\u001c;feB\u0011\u0001(O\u0007\u0002?%\u0011!h\b\u0002\b\u0019><w-\u001b8h\u0003\u0011\u0019wN\u001c4\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}z\u0012AB2p]\u001aLw-\u0003\u0002B}\tQ1*_;vE&\u001cuN\u001c4\u0002\rqJg.\u001b;?)\t!e\t\u0005\u0002F\u00015\t\u0011\u0004C\u0003<\u0005\u0001\u0007A(\u0001\nbkRD7k\u00195f[\u0016D\u0015M\u001c3mKJ\u001cX#A%\u0011\t)\u000b6KW\u0007\u0002\u0017*\u0011A*T\u0001\b[V$\u0018M\u00197f\u0015\tqu*\u0001\u0006d_2dWm\u0019;j_:T\u0011\u0001U\u0001\u0006g\u000e\fG.Y\u0005\u0003%.\u0013q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002U/:\u0011Q)V\u0005\u0003-f\t1\"Q;uQN\u001b\u0007.Z7fg&\u0011\u0001,\u0017\u0002\u000b\u0003V$\bnU2iK6,'B\u0001,\u001a!\t)5,\u0003\u0002]3\t)\u0012)\u001e;iK:$\u0018nY1uS>t\u0007*\u00198eY\u0016\u0014\u0018aE1vi\"\u001c6\r[3nK\"\u000bg\u000e\u001a7feN\u0004\u0013AD1eI\u0006+H\u000f\u001b%b]\u0012dWM\u001d\u000b\u0003A\u0012\u0004\"!\u00192\u000e\u0003=K!aY(\u0003\tUs\u0017\u000e\u001e\u0005\u0006K\u0016\u0001\rAW\u0001\fCV$\b\u000eS1oI2,'/\u0001\tj]&$\u0018)\u001e;i\u0011\u0006tG\r\\3sgR\t\u0001-\u0001\u0003j]&$HC\u00011k\u0011\u0015Yw\u00011\u0001m\u000311\u0017\u000e\u001c;fe\u000e{gNZ5h!\t\u0001T.\u0003\u0002oc\taa)\u001b7uKJ\u001cuN\u001c4jO\u0006\tr-\u001a;NCR\u001c\u0007.\u001a3IC:$G.\u001a:\u0015\u0005E$\bcA1s5&\u00111o\u0014\u0002\u0007\u001fB$\u0018n\u001c8\t\u000bUD\u0001\u0019\u0001<\u0002\u001b\u0005,H\u000f[8sSj\fG/[8o!\t9hP\u0004\u0002yyB\u0011\u0011pT\u0007\u0002u*\u001110J\u0001\u0007yI|w\u000e\u001e \n\u0005u|\u0015A\u0002)sK\u0012,g-C\u0002\u0000\u0003\u0003\u0011aa\u0015;sS:<'BA?P\u0003!!wNR5mi\u0016\u0014Hc\u00021\u0002\b\u0005E\u00111\u0004\u0005\b\u0003\u0013I\u0001\u0019AA\u0006\u0003\u001d\u0011X-];fgR\u00042\u0001MA\u0007\u0013\r\ty!\r\u0002\u000f'\u0016\u0014h\u000f\\3u%\u0016\fX/Z:u\u0011\u001d\t\u0019\"\u0003a\u0001\u0003+\t\u0001B]3ta>t7/\u001a\t\u0004a\u0005]\u0011bAA\rc\ty1+\u001a:wY\u0016$(+Z:q_:\u001cX\rC\u0004\u0002\u001e%\u0001\r!a\b\u0002\u0017\u0019LG\u000e^3s\u0007\"\f\u0017N\u001c\t\u0004a\u0005\u0005\u0012bAA\u0012c\tYa)\u001b7uKJ\u001c\u0005.Y5o)\u001d\u0001\u0017qEA\u0015\u0003kAq!!\b\u000b\u0001\u0004\ty\u0002C\u0004\u0002\n)\u0001\r!a\u000b\u0011\t\u00055\u0012\u0011G\u0007\u0003\u0003_Q!\u0001H\u0019\n\t\u0005M\u0012q\u0006\u0002\u0013\u0011R$\boU3sm2,GOU3rk\u0016\u001cH\u000fC\u0004\u0002\u0014)\u0001\r!a\u000e\u0011\t\u00055\u0012\u0011H\u0005\u0005\u0003w\tyCA\nIiR\u00048+\u001a:wY\u0016$(+Z:q_:\u001cX\rK\u0003\u000b\u0003\u007f\tY\u0005E\u0003b\u0003\u0003\n)%C\u0002\u0002D=\u0013a\u0001\u001e5s_^\u001c\bc\u0001\u0019\u0002H%\u0019\u0011\u0011J\u0019\u0003!M+'O\u001e7fi\u0016C8-\u001a9uS>t\u0017G\u0002\u0010w\u0003\u001b\ny(M\u0005$\u0003\u001f\n9&!\u001e\u0002ZU!\u0011\u0011KA*+\u00051HaBA+K\t\u0007\u0011q\f\u0002\u0002)&!\u0011\u0011LA.\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0019\u0011QL(\u0002\rQD'o\\<t#\u0011\t\t'a\u001a\u0011\u0007\u0005\f\u0019'C\u0002\u0002f=\u0013qAT8uQ&tw\r\u0005\u0003\u0002j\u0005=dbA1\u0002l%\u0019\u0011QN(\u0002\u000fA\f7m[1hK&!\u0011\u0011OA:\u0005%!\u0006N]8xC\ndWMC\u0002\u0002n=\u000b\u0014bIA<\u0003s\nY(!\u0018\u000f\u0007\u0005\fI(C\u0002\u0002^=\u000bTAI1P\u0003{\u0012Qa]2bY\u0006\f4AJA#Q\u0015Q\u00111QAI!\u0015\t\u0017\u0011IAC!\u0011\t9)!$\u000e\u0005\u0005%%bAAFW\u0005\u0011\u0011n\\\u0005\u0005\u0003\u001f\u000bIIA\u0006J\u001f\u0016C8-\u001a9uS>t\u0017G\u0002\u0010w\u0003'\u000bI*M\u0005$\u0003\u001f\n9&!&\u0002ZEJ1%a\u001e\u0002z\u0005]\u0015QL\u0019\u0006E\u0005|\u0015QP\u0019\u0004M\u0005\u0015\u0015a\u00023fgR\u0014x._\u0001\u0015\u0003V$\b.\u001a8uS\u000e\fG/[8o\r&dG/\u001a:\u0011\u0005\u0015k1cA\u0007\u0002$B\u0019\u0011-!*\n\u0007\u0005\u001dvJ\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003?\u000ba\u0003\u0013+U!~\u001bE*S#O)~K\u0005kX!E\tJ+5kU\u000b\u0003\u0003_\u0003B\u0001KAYm&\u0019\u00111W\u0015\u0003\u0017QC'/Z1e\u0019>\u001c\u0017\r\\\u0001\u0018\u0011R#\u0006kX\"M\u0013\u0016sEkX%Q?\u0006#EIU#T'\u0002\n1\u0005\u0013+U!~\u0003&k\u0014-Z?\"+\u0015\tR#S?\u000ec\u0015*\u0012(U?&\u0003v,\u0011#E%\u0016\u001b6+\u0001\u0013I)R\u0003v\f\u0015*P1f{\u0006*R!E\u000bJ{6\tT%F\u001dR{\u0016\nU0B\t\u0012\u0013ViU*!\u0003UAE\u000b\u0016)`\u00072KUI\u0014+`+N+%k\u0018(B\u001b\u0016\u000ba\u0003\u0013+U!~\u001bE*S#O)~+6+\u0012*`\u001d\u0006kU\tI\u0001\u0011O\u0016$Xk]3s\u0013B\fE\r\u001a:fgN\f1dZ3u+N,'\u000f\u0015:pqfDU-\u00193fe&\u0003\u0018\t\u001a3sKN\u001c\u0018aC4fiV\u001bXM\u001d(b[\u0016\u0004")
public class AuthenticationFilter
implements Filter,
Logging {
    private final KyuubiConf conf;
    private final HashMap<Enumeration.Value, AuthenticationHandler> authSchemeHandlers;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    public static String getUserName() {
        return AuthenticationFilter$.MODULE$.getUserName();
    }

    public static String getUserProxyHeaderIpAddress() {
        return AuthenticationFilter$.MODULE$.getUserProxyHeaderIpAddress();
    }

    public static String getUserIpAddress() {
        return AuthenticationFilter$.MODULE$.getUserIpAddress();
    }

    public static ThreadLocal<String> HTTP_CLIENT_USER_NAME() {
        return AuthenticationFilter$.MODULE$.HTTP_CLIENT_USER_NAME();
    }

    public static ThreadLocal<String> HTTP_PROXY_HEADER_CLIENT_IP_ADDRESS() {
        return AuthenticationFilter$.MODULE$.HTTP_PROXY_HEADER_CLIENT_IP_ADDRESS();
    }

    public static ThreadLocal<String> HTTP_CLIENT_IP_ADDRESS() {
        return AuthenticationFilter$.MODULE$.HTTP_CLIENT_IP_ADDRESS();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public HashMap<Enumeration.Value, AuthenticationHandler> authSchemeHandlers() {
        return this.authSchemeHandlers;
    }

    public void addAuthHandler(AuthenticationHandler authHandler) {
        authHandler.init(this.conf);
        if (authHandler.authenticationSupported()) {
            if (this.authSchemeHandlers().contains((Object)authHandler.authScheme())) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Authentication handler has been defined for scheme ").append(authHandler.authScheme()).toString());
            } else {
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Add authentication handler ").append(authHandler.getClass().getSimpleName()).append(" for scheme ").append(authHandler.authScheme()).toString());
                this.authSchemeHandlers().put((Object)authHandler.authScheme(), (Object)authHandler);
            }
        } else {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("The authentication handler ").append(authHandler.getClass().getSimpleName()).append(" for scheme ").append(authHandler.authScheme()).append(" is not supported").toString());
        }
    }

    public void initAuthHandlers() {
        block1: {
            Option basicAuthTypeOpt;
            Seq authTypes = (Seq)((TraversableLike)this.conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_METHOD())).map((Function1 & Serializable & scala.Serializable)s -> AuthTypes$.MODULE$.withName(s), Seq$.MODULE$.canBuildFrom());
            boolean spnegoKerberosEnabled = authTypes.contains((Object)AuthTypes$.MODULE$.KERBEROS());
            Seq seq = authTypes;
            .colon.colon colon2 = new .colon.colon((Object)AuthTypes$.MODULE$.NOSASL(), (List)Nil$.MODULE$);
            Option option = !(seq != null ? !seq.equals(colon2) : colon2 != null) ? authTypes.headOption() : (basicAuthTypeOpt = ((TraversableLike)((TraversableLike)authTypes.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.equals((Object)AuthTypes$.MODULE$.KERBEROS())))).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.equals((Object)AuthTypes$.MODULE$.NOSASL())))).headOption());
            if (spnegoKerberosEnabled) {
                KerberosAuthenticationHandler kerberosHandler = new KerberosAuthenticationHandler();
                this.addAuthHandler(kerberosHandler);
            }
            basicAuthTypeOpt.foreach((Function1 & Serializable & scala.Serializable)basicAuthType -> {
                AuthenticationFilter.$anonfun$initAuthHandlers$4(this, basicAuthType);
                return BoxedUnit.UNIT;
            });
            if (InternalSecurityAccessor$.MODULE$.get() == null) break block1;
            KyuubiInternalAuthenticationHandler internalHandler = new KyuubiInternalAuthenticationHandler();
            this.addAuthHandler(internalHandler);
        }
    }

    public void init(FilterConfig filterConfig) {
        this.initAuthHandlers();
        super.init(filterConfig);
    }

    public Option<AuthenticationHandler> getMatchedHandler(String authorization) {
        return this.authSchemeHandlers().values().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.matchAuthScheme(authorization)));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String authorization = httpRequest.getHeader("Authorization");
        AuthenticationHandler matchedHandler = (AuthenticationHandler)this.getMatchedHandler(authorization).orNull(Predef$.MODULE$.$conforms());
        if (matchedHandler == null) {
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("No auth scheme matched for url: ").append(httpRequest.getRequestURL()).toString());
            httpResponse.setStatus(401);
            httpResponse.sendError(401, new StringBuilder(27).append("No auth scheme matched for ").append(authorization).toString());
        } else {
            AuthenticationFilter$.MODULE$.HTTP_CLIENT_IP_ADDRESS().set(httpRequest.getRemoteAddr());
            AuthenticationFilter$.MODULE$.HTTP_PROXY_HEADER_CLIENT_IP_ADDRESS().set(httpRequest.getHeader((String)this.conf.get(KyuubiConf$.MODULE$.FRONTEND_PROXY_HTTP_CLIENT_IP_HEADER())));
            try {
                String authUser = matchedHandler.authenticate(httpRequest, httpResponse);
                if (authUser != null) {
                    AuthenticationFilter$.MODULE$.HTTP_CLIENT_USER_NAME().set(authUser);
                    this.doFilter(filterChain, httpRequest, httpResponse);
                }
            }
            catch (AuthenticationException e) {
                AuthenticationFilter$.MODULE$.HTTP_CLIENT_USER_NAME().remove();
                AuthenticationFilter$.MODULE$.HTTP_CLIENT_IP_ADDRESS().remove();
                AuthenticationFilter$.MODULE$.HTTP_PROXY_HEADER_CLIENT_IP_ADDRESS().remove();
                httpResponse.setStatus(403);
                httpResponse.sendError(403, e.getMessage());
            }
        }
    }

    public void doFilter(FilterChain filterChain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
        block0: {
            if (this.authSchemeHandlers().isEmpty()) break block0;
            this.authSchemeHandlers().values().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.destroy();
                return BoxedUnit.UNIT;
            });
            this.authSchemeHandlers().clear();
        }
    }

    public static final /* synthetic */ void $anonfun$initAuthHandlers$4(AuthenticationFilter $this, Enumeration.Value basicAuthType) {
        BasicAuthenticationHandler basicHandler = new BasicAuthenticationHandler(basicAuthType);
        $this.addAuthHandler(basicHandler);
    }

    public AuthenticationFilter(KyuubiConf conf) {
        this.conf = conf;
        Logging.$init$((Logging)this);
        this.authSchemeHandlers = new HashMap();
    }
}

