/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging.support;

import java.util.HashMap;
import java.util.Map;

public class LoggerMessageFormat {
    static final char DELIM_START = '{';
    static final char DELIM_STOP = '}';
    static final String DELIM_STR = "{}";
    private static final char ESCAPE_CHAR = '\\';

    public static String format(String messagePattern, Object ... argArray) {
        return LoggerMessageFormat.format(null, messagePattern, argArray);
    }

    public static String format(String prefix, String messagePattern, Object ... argArray) {
        if (messagePattern == null) {
            return null;
        }
        if (argArray == null) {
            if (prefix == null) {
                return messagePattern;
            }
            return prefix + messagePattern;
        }
        int i = 0;
        StringBuilder sbuf = new StringBuilder(messagePattern.length() + 50);
        if (prefix != null) {
            sbuf.append(prefix);
        }
        for (int L = 0; L < argArray.length; ++L) {
            int j = messagePattern.indexOf(DELIM_STR, i);
            if (j == -1) {
                if (i == 0) {
                    return messagePattern;
                }
                sbuf.append(messagePattern.substring(i, messagePattern.length()));
                return sbuf.toString();
            }
            if (LoggerMessageFormat.isEscapedDelimeter(messagePattern, j)) {
                if (!LoggerMessageFormat.isDoubleEscaped(messagePattern, j)) {
                    --L;
                    sbuf.append(messagePattern.substring(i, j - 1));
                    sbuf.append('{');
                    i = j + 1;
                    continue;
                }
                sbuf.append(messagePattern.substring(i, j - 1));
                LoggerMessageFormat.deeplyAppendParameter(sbuf, argArray[L], new HashMap());
                i = j + 2;
                continue;
            }
            sbuf.append(messagePattern.substring(i, j));
            LoggerMessageFormat.deeplyAppendParameter(sbuf, argArray[L], new HashMap());
            i = j + 2;
        }
        sbuf.append(messagePattern.substring(i, messagePattern.length()));
        return sbuf.toString();
    }

    static boolean isEscapedDelimeter(String messagePattern, int delimeterStartIndex) {
        if (delimeterStartIndex == 0) {
            return false;
        }
        char potentialEscape = messagePattern.charAt(delimeterStartIndex - 1);
        return potentialEscape == '\\';
    }

    static boolean isDoubleEscaped(String messagePattern, int delimeterStartIndex) {
        return delimeterStartIndex >= 2 && messagePattern.charAt(delimeterStartIndex - 2) == '\\';
    }

    private static void deeplyAppendParameter(StringBuilder sbuf, Object o, Map seenMap) {
        if (o == null) {
            sbuf.append("null");
            return;
        }
        if (!o.getClass().isArray()) {
            LoggerMessageFormat.safeObjectAppend(sbuf, o);
        } else if (o instanceof boolean[]) {
            LoggerMessageFormat.booleanArrayAppend(sbuf, (boolean[])o);
        } else if (o instanceof byte[]) {
            LoggerMessageFormat.byteArrayAppend(sbuf, (byte[])o);
        } else if (o instanceof char[]) {
            LoggerMessageFormat.charArrayAppend(sbuf, (char[])o);
        } else if (o instanceof short[]) {
            LoggerMessageFormat.shortArrayAppend(sbuf, (short[])o);
        } else if (o instanceof int[]) {
            LoggerMessageFormat.intArrayAppend(sbuf, (int[])o);
        } else if (o instanceof long[]) {
            LoggerMessageFormat.longArrayAppend(sbuf, (long[])o);
        } else if (o instanceof float[]) {
            LoggerMessageFormat.floatArrayAppend(sbuf, (float[])o);
        } else if (o instanceof double[]) {
            LoggerMessageFormat.doubleArrayAppend(sbuf, (double[])o);
        } else {
            LoggerMessageFormat.objectArrayAppend(sbuf, (Object[])o, seenMap);
        }
    }

    private static void safeObjectAppend(StringBuilder sbuf, Object o) {
        try {
            String oAsString = o.toString();
            sbuf.append(oAsString);
        }
        catch (Throwable t) {
            sbuf.append("[FAILED toString()]");
        }
    }

    private static void objectArrayAppend(StringBuilder sbuf, Object[] a, Map seenMap) {
        sbuf.append('[');
        if (!seenMap.containsKey(a)) {
            seenMap.put(a, null);
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                LoggerMessageFormat.deeplyAppendParameter(sbuf, a[i], seenMap);
                if (i == len - 1) continue;
                sbuf.append(", ");
            }
            seenMap.remove(a);
        } else {
            sbuf.append("...");
        }
        sbuf.append(']');
    }

    private static void booleanArrayAppend(StringBuilder sbuf, boolean[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void byteArrayAppend(StringBuilder sbuf, byte[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void charArrayAppend(StringBuilder sbuf, char[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void shortArrayAppend(StringBuilder sbuf, short[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void intArrayAppend(StringBuilder sbuf, int[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void longArrayAppend(StringBuilder sbuf, long[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void floatArrayAppend(StringBuilder sbuf, float[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void doubleArrayAppend(StringBuilder sbuf, double[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }
}

