/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.docvaluesformat;

import java.util.Map;
import org.apache.lucene.codecs.DocValuesFormat;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.settings.IndexSettings;

public interface DocValuesFormatProvider {
    public static final String DOC_VALUES_FORMAT_SETTINGS_PREFIX = "index.codec.doc_values_format";

    public DocValuesFormat get();

    public String name();

    public static interface Factory {
        public DocValuesFormatProvider create(String var1, Settings var2);
    }

    public static class Helper {
        public static DocValuesFormatProvider lookup(@IndexSettings Settings indexSettings, String name, Map<String, Factory> docValuesFormatFactories) throws ElasticsearchIllegalArgumentException {
            Factory factory = docValuesFormatFactories.get(name);
            if (factory == null) {
                throw new ElasticsearchIllegalArgumentException("failed to find doc_values_format [" + name + "]");
            }
            Settings settings = indexSettings.getGroups(DocValuesFormatProvider.DOC_VALUES_FORMAT_SETTINGS_PREFIX).get(name);
            if (settings == null) {
                settings = ImmutableSettings.Builder.EMPTY_SETTINGS;
            }
            return factory.create(name, settings);
        }
    }
}

