/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.IdentityHashMap;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.search.NoCacheFilter;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.SearchContext;

public class CustomQueryWrappingFilter
extends NoCacheFilter
implements Releasable {
    private final Query query;
    private IndexSearcher searcher;
    private IdentityHashMap<AtomicReader, DocIdSet> docIdSets;

    public CustomQueryWrappingFilter(Query query) {
        if (query == null) {
            throw new NullPointerException("Query may not be null");
        }
        this.query = query;
    }

    public final Query getQuery() {
        return this.query;
    }

    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        DocIdSet set;
        SearchContext searchContext = SearchContext.current();
        if (this.docIdSets == null) {
            assert (this.searcher == null);
            ContextIndexSearcher searcher = searchContext.searcher();
            this.docIdSets = new IdentityHashMap();
            this.searcher = searcher;
            searchContext.addReleasable(this);
            final Weight weight = searcher.createNormalizedWeight(this.query);
            for (final AtomicReaderContext leaf : searcher.getTopReaderContext().leaves()) {
                DocIdSet set2 = DocIdSets.toCacheable(leaf.reader(), new DocIdSet(){

                    public DocIdSetIterator iterator() throws IOException {
                        return weight.scorer(leaf, true, false, null);
                    }

                    public boolean isCacheable() {
                        return false;
                    }
                });
                this.docIdSets.put(leaf.reader(), set2);
            }
        } else assert (this.searcher == SearchContext.current().searcher());
        if ((set = this.docIdSets.get(context.reader())) != null && acceptDocs != null) {
            return BitsFilteredDocIdSet.wrap((DocIdSet)set, (Bits)acceptDocs);
        }
        return set;
    }

    @Override
    public boolean release() throws ElasticsearchException {
        this.docIdSets = null;
        this.searcher = null;
        return true;
    }

    public String toString() {
        return "CustomQueryWrappingFilter(" + this.query + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o != null && o instanceof CustomQueryWrappingFilter && this.query.equals((Object)((CustomQueryWrappingFilter)o).query);
    }

    public int hashCode() {
        return this.query.hashCode() ^ 0x823D64C9;
    }
}

