/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage.j2d;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.util.Arrays;
import java.util.Objects;
import org.apache.sis.internal.coverage.j2d.MultiBandsIndexColorModel;

final class ColorModelPatch<T extends ColorModel> {
    final T cm;

    ColorModelPatch(T t) {
        this.cm = t;
    }

    private static boolean equals(ColorModel colorModel, ColorModel colorModel2) {
        if (colorModel == colorModel2) {
            return true;
        }
        if (colorModel != null && colorModel.equals(colorModel2) && colorModel.getClass().equals(colorModel2.getClass()) && colorModel.getTransferType() == colorModel2.getTransferType() && Objects.equals(colorModel.getColorSpace(), colorModel2.getColorSpace())) {
            if (colorModel instanceof IndexColorModel) {
                IndexColorModel indexColorModel = (IndexColorModel)colorModel;
                IndexColorModel indexColorModel2 = (IndexColorModel)colorModel2;
                int n = indexColorModel.getMapSize();
                if (indexColorModel2.getMapSize() == n && indexColorModel.getTransparentPixel() == indexColorModel2.getTransparentPixel() && Objects.equals(indexColorModel.getValidPixels(), indexColorModel2.getValidPixels())) {
                    for (int i = 0; i < n; ++i) {
                        if (indexColorModel.getRGB(i) == indexColorModel2.getRGB(i)) continue;
                        return false;
                    }
                }
                if (colorModel instanceof MultiBandsIndexColorModel) {
                    MultiBandsIndexColorModel multiBandsIndexColorModel = (MultiBandsIndexColorModel)colorModel;
                    MultiBandsIndexColorModel multiBandsIndexColorModel2 = (MultiBandsIndexColorModel)colorModel2;
                    if (multiBandsIndexColorModel.numBands != multiBandsIndexColorModel2.numBands || multiBandsIndexColorModel.visibleBand != multiBandsIndexColorModel2.visibleBand) {
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        return object instanceof ColorModelPatch && ColorModelPatch.equals(this.cm, ((ColorModelPatch)object).cm);
    }

    public int hashCode() {
        int n = ((ColorModel)this.cm).hashCode() ^ this.cm.getClass().hashCode();
        if (this.cm instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)this.cm;
            int[] nArray = new int[indexColorModel.getMapSize()];
            indexColorModel.getRGBs(nArray);
            n ^= Arrays.hashCode(nArray);
        }
        return n;
    }
}

