/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.notificationconnectorpool;

import org.apache.manifoldcf.core.connectorpool.ConnectorPool;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.interfaces.INotificationConnection;
import org.apache.manifoldcf.crawler.interfaces.INotificationConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.INotificationConnector;
import org.apache.manifoldcf.crawler.interfaces.INotificationConnectorManager;
import org.apache.manifoldcf.crawler.interfaces.INotificationConnectorPool;
import org.apache.manifoldcf.crawler.interfaces.NotificationConnectionManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.NotificationConnectorManagerFactory;

public class NotificationConnectorPool
implements INotificationConnectorPool {
    public static final String _rcsid = "@(#)$Id$";
    protected static final LocalPool localPool = new LocalPool();
    protected final IThreadContext threadContext;

    public NotificationConnectorPool(IThreadContext threadContext) throws ManifoldCFException {
        this.threadContext = threadContext;
    }

    @Override
    public INotificationConnector[] grabMultiple(String[] orderingKeys, INotificationConnection[] notificationConnections) throws ManifoldCFException {
        String[] connectionNames = new String[notificationConnections.length];
        String[] classNames = new String[notificationConnections.length];
        ConfigParams[] configInfos = new ConfigParams[notificationConnections.length];
        int[] maxPoolSizes = new int[notificationConnections.length];
        for (int i = 0; i < notificationConnections.length; ++i) {
            connectionNames[i] = notificationConnections[i].getName();
            classNames[i] = notificationConnections[i].getClassName();
            configInfos[i] = notificationConnections[i].getConfigParams();
            maxPoolSizes[i] = notificationConnections[i].getMaxConnections();
        }
        return localPool.grabMultiple(this.threadContext, orderingKeys, connectionNames, classNames, configInfos, maxPoolSizes);
    }

    @Override
    public INotificationConnector grab(INotificationConnection notificationConnection) throws ManifoldCFException {
        return (INotificationConnector)localPool.grab(this.threadContext, notificationConnection.getName(), notificationConnection.getClassName(), notificationConnection.getConfigParams(), notificationConnection.getMaxConnections());
    }

    @Override
    public void releaseMultiple(INotificationConnection[] connections, INotificationConnector[] connectors) throws ManifoldCFException {
        String[] connectionNames = new String[connections.length];
        for (int i = 0; i < connections.length; ++i) {
            connectionNames[i] = connections[i].getName();
        }
        localPool.releaseMultiple(this.threadContext, connectionNames, connectors);
    }

    @Override
    public void release(INotificationConnection connection, INotificationConnector connector) throws ManifoldCFException {
        localPool.release(this.threadContext, connection.getName(), connector);
    }

    @Override
    public void pollAllConnectors() throws ManifoldCFException {
        localPool.pollAllConnectors(this.threadContext);
    }

    @Override
    public void flushUnusedConnectors() throws ManifoldCFException {
        localPool.flushUnusedConnectors(this.threadContext);
    }

    @Override
    public void closeAllConnectors() throws ManifoldCFException {
        localPool.closeAllConnectors(this.threadContext);
    }

    protected static class LocalPool
    extends ConnectorPool<INotificationConnector> {
        public LocalPool() {
            super("_NOTIFICATIONCONNECTORPOOL_");
        }

        protected boolean isInstalled(IThreadContext tc, String className) throws ManifoldCFException {
            INotificationConnectorManager connectorManager = NotificationConnectorManagerFactory.make(tc);
            return connectorManager.isInstalled(className);
        }

        protected boolean isConnectionNameValid(IThreadContext tc, String connectionName) throws ManifoldCFException {
            INotificationConnectionManager connectionManager = NotificationConnectionManagerFactory.make(tc);
            return connectionManager.load(connectionName) != null;
        }

        public INotificationConnector[] grabMultiple(IThreadContext tc, String[] orderingKeys, String[] connectionNames, String[] classNames, ConfigParams[] configInfos, int[] maxPoolSizes) throws ManifoldCFException {
            return (INotificationConnector[])this.grabMultiple(tc, INotificationConnector.class, orderingKeys, connectionNames, classNames, configInfos, maxPoolSizes);
        }
    }
}

