/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.tests;

import org.apache.manifoldcf.agents.interfaces.IOutputConnection;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectionManager;
import org.apache.manifoldcf.agents.interfaces.OutputConnectionManagerFactory;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnection;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.tests.ManifoldCFInstance;

public class ConnectionChangeTester {
    protected final ManifoldCFInstance instance;

    public ConnectionChangeTester(ManifoldCFInstance instance) {
        this.instance = instance;
    }

    public void executeTest() throws Exception {
        this.instance.start();
        IThreadContext tc = ThreadContextFactory.make();
        IRepositoryConnectionManager mgr = RepositoryConnectionManagerFactory.make((IThreadContext)tc);
        IRepositoryConnection conn = mgr.create();
        conn.setName("ConnectionChangeTest Connection");
        conn.setDescription("ConnectionChangeTest Connection");
        conn.setClassName("org.apache.manifoldcf.crawler.tests.ConnectionChangeRepositoryConnector");
        conn.setMaxConnections(100);
        mgr.save(conn);
        IOutputConnectionManager outputMgr = OutputConnectionManagerFactory.make((IThreadContext)tc);
        IOutputConnection outputConn = outputMgr.create();
        outputConn.setName("Null Connection");
        outputConn.setDescription("Null Connection");
        outputConn.setClassName("org.apache.manifoldcf.agents.tests.TestingOutputConnector");
        outputConn.setMaxConnections(100);
        outputMgr.save(outputConn);
        IJobManager jobManager = JobManagerFactory.make((IThreadContext)tc);
        IJobDescription job = jobManager.createJob();
        job.setDescription("Test Job");
        job.setConnectionName("ConnectionChangeTest Connection");
        job.addPipelineStage(-1, true, "Null Connection", "");
        job.setType(1);
        job.setStartMethod(2);
        job.setHopcountMode(0);
        jobManager.save(job);
        jobManager.manualStart(job.getID());
        this.instance.waitJobRunningNative(jobManager, job.getID(), 30000L);
        conn = mgr.load("ConnectionChangeTest Connection");
        ConfigParams cp = conn.getConfigParams();
        cp.setParameter("proceed", "true");
        mgr.save(conn);
        this.instance.waitJobInactiveNative(jobManager, job.getID(), 30000L);
        if (jobManager.getStatus(job.getID()).getDocumentsProcessed() != 10L) {
            throw new Exception("Expected 10 documents, saw " + jobManager.getStatus(job.getID()).getDocumentsProcessed());
        }
        jobManager.deleteJob(job.getID());
        this.instance.waitJobDeletedNative(jobManager, job.getID(), 60000L);
        this.instance.stop();
    }
}

