/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.connectorcommon.fuzzyml;

import java.util.ArrayList;
import java.util.List;

public class ByteBuffer {
    protected static final int arraySize = 65536;
    protected static final int arrayShift = 16;
    protected final List<byte[]> arrayOfArrays = new ArrayList<byte[]>();
    protected int totalBytes = 0;
    protected int currentIndex = -1;
    protected byte[] currentBuffer = null;

    public void clear() {
        this.arrayOfArrays.clear();
        this.totalBytes = 0;
        this.currentIndex = -1;
        this.currentBuffer = null;
    }

    public int size() {
        return this.totalBytes;
    }

    public void appendByte(byte b) {
        if (this.currentIndex == 65536 || this.currentIndex == -1) {
            this.currentBuffer = new byte[65536];
            this.arrayOfArrays.add(this.currentBuffer);
            this.currentIndex = 0;
        }
        this.currentBuffer[this.currentIndex++] = b;
        ++this.totalBytes;
    }

    public byte readByte(int position) {
        int arrayNumber = position >> 16;
        int offset = position & 0xFFFF;
        return this.arrayOfArrays.get(arrayNumber)[offset];
    }
}

