/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.storedobj.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.apache.chemistry.opencmis.inmemory.ConfigurationSettings;
import org.apache.chemistry.opencmis.inmemory.FilterParser;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.DocumentVersion;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.MultiFiling;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.VersionedDocument;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.StoredObjectImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.VersionedDocumentImpl;

public class DocumentVersionImpl
extends StoredObjectImpl
implements DocumentVersion,
MultiFiling {
    private static final Long MAX_CONTENT_SIZE_KB = ConfigurationSettings.getConfigurationValueAsLong("InMemoryServer.MaxContentSizeKB");
    private ContentStream fContent;
    private final VersionedDocumentImpl fContainer;
    private String fComment;
    private boolean fIsMajor;
    private boolean fIsPwc;

    public DocumentVersionImpl(String repositoryId, VersionedDocument container, VersioningState verState) {
        this.setRepositoryId(repositoryId);
        this.fContainer = (VersionedDocumentImpl)container;
        this.fIsMajor = verState == VersioningState.MAJOR || verState == null;
        this.fIsPwc = verState == VersioningState.CHECKEDOUT;
        this.fProperties = new HashMap();
        DocumentVersionImpl src = (DocumentVersionImpl)container.getLatestVersion(false);
        if (null != src && null != src.fProperties) {
            for (Map.Entry prop : src.fProperties.entrySet()) {
                this.fProperties.put(prop.getKey(), prop.getValue());
            }
        }
    }

    @Override
    public void setContent(ContentStream content) {
        this.setContentIntern(content);
    }

    private void setContentIntern(ContentStream content) {
        this.fContent = content;
    }

    @Override
    public void setCheckinComment(String comment) {
        this.fComment = comment;
    }

    @Override
    public String getCheckinComment() {
        return this.fComment;
    }

    private String createVersionLabel() {
        int majorNo = 0;
        int minorNo = 0;
        List<DocumentVersion> allVersions = this.fContainer.getAllVersions();
        for (DocumentVersion ver : allVersions) {
            if (ver.isMajor()) {
                ++majorNo;
                minorNo = 0;
            } else {
                ++minorNo;
            }
            if (ver != this) continue;
            break;
        }
        String label = majorNo + "." + minorNo;
        return label;
    }

    @Override
    public boolean isMajor() {
        return this.fIsMajor && !this.isPwc();
    }

    @Override
    public boolean isPwc() {
        return this.fIsPwc;
    }

    @Override
    public void commit(boolean isMajor) {
        this.fIsPwc = false;
        this.fIsMajor = isMajor;
    }

    @Override
    public ContentStream getContent() {
        return this.fContent;
    }

    @Override
    public VersionedDocument getParentDocument() {
        return this.fContainer;
    }

    private boolean isLatestVersion() {
        boolean hasPwc;
        List<DocumentVersion> allVers = this.fContainer.getAllVersions();
        boolean bl = hasPwc = null != this.fContainer.getPwc();
        boolean isLatestVersion = hasPwc ? allVers.size() > 1 && allVers.get(allVers.size() - 2) == this : allVers.get(allVers.size() - 1) == this;
        return isLatestVersion;
    }

    private boolean isLatestMajorVersion() {
        if (!this.fIsMajor) {
            return false;
        }
        List<DocumentVersion> allVersions = this.fContainer.getAllVersions();
        DocumentVersion latestMajor = null;
        for (DocumentVersion ver : allVersions) {
            if (!ver.isMajor() || ver.isPwc()) continue;
            latestMajor = ver;
        }
        boolean isLatestMajorVersion = latestMajor == this;
        return isLatestMajorVersion;
    }

    @Override
    public void fillProperties(Map<String, PropertyData<?>> properties, BindingsObjectFactory objFactory, List<String> requestedIds) {
        DocumentVersion pwc = this.fContainer.getPwc();
        this.fContainer.fillProperties(properties, objFactory, requestedIds);
        super.fillProperties(properties, objFactory, requestedIds);
        if (FilterParser.isContainedInFilter("cmis:isImmutable", requestedIds)) {
            properties.put("cmis:isImmutable", (PropertyData<?>)objFactory.createPropertyBooleanData("cmis:isImmutable", Boolean.valueOf(false)));
        }
        if (FilterParser.isContainedInFilter("cmis:isLatestVersion", requestedIds)) {
            properties.put("cmis:isLatestVersion", (PropertyData<?>)objFactory.createPropertyBooleanData("cmis:isLatestVersion", Boolean.valueOf(this.isLatestVersion())));
        }
        if (FilterParser.isContainedInFilter("cmis:isMajorVersion", requestedIds)) {
            properties.put("cmis:isMajorVersion", (PropertyData<?>)objFactory.createPropertyBooleanData("cmis:isMajorVersion", Boolean.valueOf(this.fIsMajor)));
        }
        if (FilterParser.isContainedInFilter("cmis:isLatestMajorVersion", requestedIds)) {
            properties.put("cmis:isLatestMajorVersion", (PropertyData<?>)objFactory.createPropertyBooleanData("cmis:isLatestMajorVersion", Boolean.valueOf(this.isLatestMajorVersion())));
        }
        if (FilterParser.isContainedInFilter("cmis:versionSeriesId", requestedIds)) {
            properties.put("cmis:versionSeriesId", (PropertyData<?>)objFactory.createPropertyIdData("cmis:versionSeriesId", this.fContainer.getId()));
        }
        if (FilterParser.isContainedInFilter("cmis:isVersionSeriesCheckedOut", requestedIds)) {
            properties.put("cmis:isVersionSeriesCheckedOut", (PropertyData<?>)objFactory.createPropertyBooleanData("cmis:isVersionSeriesCheckedOut", Boolean.valueOf(this.fContainer.isCheckedOut())));
        }
        if (FilterParser.isContainedInFilter("cmis:versionSeriesCheckedOutBy", requestedIds)) {
            properties.put("cmis:versionSeriesCheckedOutBy", (PropertyData<?>)objFactory.createPropertyStringData("cmis:versionSeriesCheckedOutBy", this.fContainer.getCheckedOutBy()));
        }
        if (FilterParser.isContainedInFilter("cmis:versionSeriesCheckedOutId", requestedIds)) {
            properties.put("cmis:versionSeriesCheckedOutId", (PropertyData<?>)objFactory.createPropertyIdData("cmis:versionSeriesCheckedOutId", pwc == null ? null : pwc.getId()));
        }
        if (FilterParser.isContainedInFilter("cmis:checkinComment", requestedIds)) {
            properties.put("cmis:checkinComment", (PropertyData<?>)objFactory.createPropertyStringData("cmis:checkinComment", this.fComment));
        }
        if (FilterParser.isContainedInFilter("cmis:versionLabel", requestedIds)) {
            properties.put("cmis:versionLabel", (PropertyData<?>)objFactory.createPropertyStringData("cmis:versionLabel", this.getVersionLabel()));
        }
        if (null != this.fContent) {
            if (FilterParser.isContainedInFilter("cmis:contentStreamFileName", requestedIds)) {
                properties.put("cmis:contentStreamFileName", (PropertyData<?>)objFactory.createPropertyStringData("cmis:contentStreamFileName", this.fContent.getFileName()));
            }
            if (FilterParser.isContainedInFilter("cmis:contentStreamId", requestedIds)) {
                properties.put("cmis:contentStreamId", (PropertyData<?>)objFactory.createPropertyStringData("cmis:contentStreamId", (String)null));
            }
            if (FilterParser.isContainedInFilter("cmis:contentStreamLength", requestedIds)) {
                properties.put("cmis:contentStreamLength", (PropertyData<?>)objFactory.createPropertyIntegerData("cmis:contentStreamLength", this.fContent.getBigLength()));
            }
            if (FilterParser.isContainedInFilter("cmis:contentStreamMimeType", requestedIds)) {
                properties.put("cmis:contentStreamMimeType", (PropertyData<?>)objFactory.createPropertyStringData("cmis:contentStreamMimeType", this.fContent.getMimeType()));
            }
        }
        if (FilterParser.isContainedInFilter("cmis:isPrivateWorkingCopy", requestedIds)) {
            properties.put("cmis:isPrivateWorkingCopy", (PropertyData<?>)objFactory.createPropertyBooleanData("cmis:isPrivateWorkingCopy", Boolean.valueOf(this.isPwc())));
        }
    }

    @Override
    public int getAclId() {
        return this.fContainer.getAclId();
    }

    @Override
    public void setAclId(int id) {
        this.fContainer.setAclId(id);
    }

    @Override
    public List<String> getParentIds() {
        return this.fContainer.getParentIds();
    }

    @Override
    public String getPathSegment() {
        return this.fContainer.getPathSegment();
    }

    @Override
    public boolean hasContent() {
        return null != this.fContent;
    }

    @Override
    public boolean hasParent() {
        return this.fContainer.hasParent();
    }

    @Override
    public String getVersionLabel() {
        return this.createVersionLabel();
    }

    @Override
    public void addParentId(String parentId) {
        this.fContainer.addParentId(parentId);
    }

    @Override
    public void removeParentId(String parentId) {
        this.fContainer.removeParentId(parentId);
    }
}

